/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.BuildStatus;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.transform.BuildMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Build
implements StructuredPojo,
ToCopyableBuilder<Builder, Build> {
    private final String buildId;
    private final String name;
    private final String version;
    private final String status;
    private final Long sizeOnDisk;
    private final String operatingSystem;
    private final Instant creationTime;

    private Build(BuilderImpl builder) {
        this.buildId = builder.buildId;
        this.name = builder.name;
        this.version = builder.version;
        this.status = builder.status;
        this.sizeOnDisk = builder.sizeOnDisk;
        this.operatingSystem = builder.operatingSystem;
        this.creationTime = builder.creationTime;
    }

    public String buildId() {
        return this.buildId;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public BuildStatus status() {
        return BuildStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Long sizeOnDisk() {
        return this.sizeOnDisk;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeOnDisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        return Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sizeOnDisk(), other.sizeOnDisk()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"Build").add("BuildId", (Object)this.buildId()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("SizeOnDisk", (Object)this.sizeOnDisk()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BuildId": {
                return Optional.ofNullable(clazz.cast(this.buildId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SizeOnDisk": {
                return Optional.ofNullable(clazz.cast(this.sizeOnDisk()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String buildId;
        private String name;
        private String version;
        private String status;
        private Long sizeOnDisk;
        private String operatingSystem;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.buildId(model.buildId);
            this.name(model.name);
            this.version(model.version);
            this.status(model.status);
            this.sizeOnDisk(model.sizeOnDisk);
            this.operatingSystem(model.operatingSystem);
            this.creationTime(model.creationTime);
        }

        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BuildStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getSizeOnDisk() {
            return this.sizeOnDisk;
        }

        @Override
        public final Builder sizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
            return this;
        }

        public final void setSizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public Build build() {
            return new Build(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Build> {
        public Builder buildId(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(BuildStatus var1);

        public Builder sizeOnDisk(Long var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder creationTime(Instant var1);
    }
}

