/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.ServerProcess;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServerProcessMarshaller {
    private static final MarshallingInfo<String> LAUNCHPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchPath").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<Integer> CONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConcurrentExecutions").isBinary(false).build();
    private static final ServerProcessMarshaller INSTANCE = new ServerProcessMarshaller();

    private ServerProcessMarshaller() {
    }

    public static ServerProcessMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServerProcess serverProcess, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serverProcess, (String)"serverProcess");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serverProcess.launchPath(), LAUNCHPATH_BINDING);
            protocolMarshaller.marshall((Object)serverProcess.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)serverProcess.concurrentExecutions(), CONCURRENTEXECUTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

