/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.MatchmakingTicket;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MatchmakingTicketMarshaller {
    private static final MarshallingInfo<String> TICKETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TicketId").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationName").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusReason").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<List> PLAYERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Players").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GAMESESSIONCONNECTIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionConnectionInfo").isBinary(false).build();
    private static final MarshallingInfo<Integer> ESTIMATEDWAITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EstimatedWaitTime").isBinary(false).build();
    private static final MatchmakingTicketMarshaller INSTANCE = new MatchmakingTicketMarshaller();

    private MatchmakingTicketMarshaller() {
    }

    public static MatchmakingTicketMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MatchmakingTicket matchmakingTicket, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)matchmakingTicket, (String)"matchmakingTicket");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)matchmakingTicket.ticketId(), TICKETID_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.configurationName(), CONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.statusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(matchmakingTicket.players(), PLAYERS_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.gameSessionConnectionInfo(), GAMESESSIONCONNECTIONINFO_BINDING);
            protocolMarshaller.marshall((Object)matchmakingTicket.estimatedWaitTime(), ESTIMATEDWAITTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

