/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EC2InstanceLimitMarshaller {
    private static final MarshallingInfo<String> EC2INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> CURRENTINSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentInstances").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceLimit").isBinary(false).build();
    private static final EC2InstanceLimitMarshaller INSTANCE = new EC2InstanceLimitMarshaller();

    private EC2InstanceLimitMarshaller() {
    }

    public static EC2InstanceLimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EC2InstanceLimit ec2InstanceLimit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2InstanceLimit, (String)"ec2InstanceLimit");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ec2InstanceLimit.ec2InstanceTypeAsString(), EC2INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceLimit.currentInstances(), CURRENTINSTANCES_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceLimit.instanceLimit(), INSTANCELIMIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

