/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.gamelift.model.AttributeValue;

public class AttributeValueUnmarshaller
implements Unmarshaller<AttributeValue, JsonUnmarshallerContext> {
    private static final AttributeValueUnmarshaller INSTANCE = new AttributeValueUnmarshaller();

    public AttributeValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        AttributeValue.Builder attributeValueBuilder = AttributeValue.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.s((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("N", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.n((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("SL", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.sl(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SDM", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.sdm(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Double.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AttributeValue)attributeValueBuilder.build();
    }

    public static AttributeValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}

