/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceLimitListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEc2InstanceLimitsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeEc2InstanceLimitsResponse> {
    private final List<EC2InstanceLimit> ec2InstanceLimits;

    private DescribeEc2InstanceLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceLimits = builder.ec2InstanceLimits;
    }

    public List<EC2InstanceLimit> ec2InstanceLimits() {
        return this.ec2InstanceLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceLimits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEc2InstanceLimitsResponse)) {
            return false;
        }
        DescribeEc2InstanceLimitsResponse other = (DescribeEc2InstanceLimitsResponse)((Object)obj);
        return Objects.equals(this.ec2InstanceLimits(), other.ec2InstanceLimits());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEc2InstanceLimitsResponse").add("EC2InstanceLimits", this.ec2InstanceLimits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceLimits": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceLimits()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<EC2InstanceLimit> ec2InstanceLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEc2InstanceLimitsResponse model) {
            super(model);
            this.ec2InstanceLimits(model.ec2InstanceLimits);
        }

        public final Collection<EC2InstanceLimit.Builder> getEC2InstanceLimits() {
            return this.ec2InstanceLimits != null ? (Collection)this.ec2InstanceLimits.stream().map(EC2InstanceLimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2InstanceLimits(Collection<EC2InstanceLimit> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copy(ec2InstanceLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceLimits(EC2InstanceLimit ... ec2InstanceLimits) {
            this.ec2InstanceLimits(Arrays.asList(ec2InstanceLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder> ... ec2InstanceLimits) {
            this.ec2InstanceLimits(Stream.of(ec2InstanceLimits).map(c -> (EC2InstanceLimit)((EC2InstanceLimit.Builder)EC2InstanceLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEC2InstanceLimits(Collection<EC2InstanceLimit.BuilderImpl> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copyFromBuilder(ec2InstanceLimits);
        }

        @Override
        public DescribeEc2InstanceLimitsResponse build() {
            return new DescribeEc2InstanceLimitsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribeEc2InstanceLimitsResponse> {
        public Builder ec2InstanceLimits(Collection<EC2InstanceLimit> var1);

        public Builder ec2InstanceLimits(EC2InstanceLimit ... var1);

        public Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder> ... var1);
    }
}

