/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEc2InstanceLimitsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeEc2InstanceLimitsRequest> {
    private final String ec2InstanceType;

    private DescribeEc2InstanceLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceType = builder.ec2InstanceType;
    }

    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public String ec2InstanceTypeAsString() {
        return this.ec2InstanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEc2InstanceLimitsRequest)) {
            return false;
        }
        DescribeEc2InstanceLimitsRequest other = (DescribeEc2InstanceLimitsRequest)((Object)obj);
        return Objects.equals(this.ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEc2InstanceLimitsRequest").add("EC2InstanceType", (Object)this.ec2InstanceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceType": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String ec2InstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEc2InstanceLimitsRequest model) {
            super(model);
            this.ec2InstanceType(model.ec2InstanceType);
        }

        public final String getEC2InstanceType() {
            return this.ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType.toString());
            return this;
        }

        public final void setEC2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEc2InstanceLimitsRequest build() {
            return new DescribeEc2InstanceLimitsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DescribeEc2InstanceLimitsRequest> {
        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

