/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.Player;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PlayerMarshaller {
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").isBinary(false).build();
    private static final MarshallingInfo<Map> PLAYERATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> TEAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Team").isBinary(false).build();
    private static final MarshallingInfo<Map> LATENCYINMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatencyInMs").isBinary(false).build();
    private static final PlayerMarshaller INSTANCE = new PlayerMarshaller();

    private PlayerMarshaller() {
    }

    public static PlayerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Player player, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)player, (String)"player");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)player.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall(player.playerAttributes(), PLAYERATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)player.team(), TEAM_BINDING);
            protocolMarshaller.marshall(player.latencyInMs(), LATENCYINMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

