/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FleetCapacityMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCECOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCounts").isBinary(false).build();
    private static final FleetCapacityMarshaller INSTANCE = new FleetCapacityMarshaller();

    private FleetCapacityMarshaller() {
    }

    public static FleetCapacityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FleetCapacity fleetCapacity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fleetCapacity, (String)"fleetCapacity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fleetCapacity.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)fleetCapacity.instanceTypeAsString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)fleetCapacity.instanceCounts(), INSTANCECOUNTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

