/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.gamelift.model.CreateFleetRequest;
import software.amazon.awssdk.services.gamelift.transform.CreateFleetRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("GameLift.CreateFleet").serviceName("Amazon GameLift").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateFleetRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        Validate.paramNotNull((Object)((Object)createFleetRequest), (String)"createFleetRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createFleetRequest);
            protocolMarshaller.startMarshalling();
            CreateFleetRequestModelMarshaller.getInstance().marshall(createFleetRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

