/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.RoutingStrategyType;
import software.amazon.awssdk.services.gamelift.transform.RoutingStrategyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RoutingStrategy
implements StructuredPojo,
ToCopyableBuilder<Builder, RoutingStrategy> {
    private final String type;
    private final String fleetId;
    private final String message;

    private RoutingStrategy(BuilderImpl builder) {
        this.type = builder.type;
        this.fleetId = builder.fleetId;
        this.message = builder.message;
    }

    public RoutingStrategyType type() {
        return RoutingStrategyType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingStrategy)) {
            return false;
        }
        RoutingStrategy other = (RoutingStrategy)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"RoutingStrategy").add("Type", (Object)this.typeAsString()).add("FleetId", (Object)this.fleetId()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoutingStrategyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String fleetId;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingStrategy model) {
            this.type(model.type);
            this.fleetId(model.fleetId);
            this.message(model.message);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoutingStrategyType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public RoutingStrategy build() {
            return new RoutingStrategy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoutingStrategy> {
        public Builder type(String var1);

        public Builder type(RoutingStrategyType var1);

        public Builder fleetId(String var1);

        public Builder message(String var1);
    }
}

