/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.gamelift.model.Build;
import software.amazon.awssdk.services.gamelift.model.BuildListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBuildsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListBuildsResponse> {
    private final List<Build> builds;
    private final String nextToken;

    private ListBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.builds = builder.builds;
        this.nextToken = builder.nextToken;
    }

    public List<Build> builds() {
        return this.builds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.builds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResponse)) {
            return false;
        }
        ListBuildsResponse other = (ListBuildsResponse)((Object)obj);
        return Objects.equals(this.builds(), other.builds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBuildsResponse").add("Builds", this.builds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Builds": {
                return Optional.of(clazz.cast(this.builds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<Build> builds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsResponse model) {
            super(model);
            this.builds(model.builds);
            this.nextToken(model.nextToken);
        }

        public final Collection<Build.Builder> getBuilds() {
            return this.builds != null ? (Collection)this.builds.stream().map(Build::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildListCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build ... builds) {
            this.builds(Arrays.asList(builds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Consumer<Build.Builder> ... builds) {
            this.builds(Stream.of(builds).map(c -> (Build)((Build.Builder)Build.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildListCopier.copyFromBuilder(builds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBuildsResponse build() {
            return new ListBuildsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, ListBuildsResponse> {
        public Builder builds(Collection<Build> var1);

        public Builder builds(Build ... var1);

        public Builder builds(Consumer<Build.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

