/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.RoutingStrategyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAliasesRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, ListAliasesRequest> {
    private final String routingStrategyType;
    private final String name;
    private final Integer limit;
    private final String nextToken;

    private ListAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.routingStrategyType = builder.routingStrategyType;
        this.name = builder.name;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public RoutingStrategyType routingStrategyType() {
        return RoutingStrategyType.fromValue(this.routingStrategyType);
    }

    public String routingStrategyTypeAsString() {
        return this.routingStrategyType;
    }

    public String name() {
        return this.name;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routingStrategyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesRequest)) {
            return false;
        }
        ListAliasesRequest other = (ListAliasesRequest)((Object)obj);
        return Objects.equals(this.routingStrategyTypeAsString(), other.routingStrategyTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAliasesRequest").add("RoutingStrategyType", (Object)this.routingStrategyTypeAsString()).add("Name", (Object)this.name()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingStrategyType": {
                return Optional.of(clazz.cast(this.routingStrategyTypeAsString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String routingStrategyType;
        private String name;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesRequest model) {
            super(model);
            this.routingStrategyType(model.routingStrategyType);
            this.name(model.name);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getRoutingStrategyType() {
            return this.routingStrategyType;
        }

        @Override
        public final Builder routingStrategyType(String routingStrategyType) {
            this.routingStrategyType = routingStrategyType;
            return this;
        }

        @Override
        public final Builder routingStrategyType(RoutingStrategyType routingStrategyType) {
            this.routingStrategyType(routingStrategyType.toString());
            return this;
        }

        public final void setRoutingStrategyType(String routingStrategyType) {
            this.routingStrategyType = routingStrategyType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListAliasesRequest build() {
            return new ListAliasesRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, ListAliasesRequest> {
        public Builder routingStrategyType(String var1);

        public Builder routingStrategyType(RoutingStrategyType var1);

        public Builder name(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

