/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGameSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateGameSessionRequest> {
    private final String fleetId;
    private final String aliasId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final List<GameProperty> gameProperties;
    private final String creatorId;
    private final String gameSessionId;
    private final String idempotencyToken;
    private final String gameSessionData;

    private CreateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.gameProperties = builder.gameProperties;
        this.creatorId = builder.creatorId;
        this.gameSessionId = builder.gameSessionId;
        this.idempotencyToken = builder.idempotencyToken;
        this.gameSessionData = builder.gameSessionData;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String name() {
        return this.name;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public String gameSessionData() {
        return this.gameSessionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionRequest)) {
            return false;
        }
        CreateGameSessionRequest other = (CreateGameSessionRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.gameSessionData(), other.gameSessionData());
    }

    public String toString() {
        return ToString.builder((String)"CreateGameSessionRequest").add("FleetId", (Object)this.fleetId()).add("AliasId", (Object)this.aliasId()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("Name", (Object)this.name()).add("GameProperties", this.gameProperties()).add("CreatorId", (Object)this.creatorId()).add("GameSessionId", (Object)this.gameSessionId()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("GameSessionData", (Object)this.gameSessionData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "AliasId": {
                return Optional.of(clazz.cast(this.aliasId()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.of(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GameProperties": {
                return Optional.of(clazz.cast(this.gameProperties()));
            }
            case "CreatorId": {
                return Optional.of(clazz.cast(this.creatorId()));
            }
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "IdempotencyToken": {
                return Optional.of(clazz.cast(this.idempotencyToken()));
            }
            case "GameSessionData": {
                return Optional.of(clazz.cast(this.gameSessionData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String aliasId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private List<GameProperty> gameProperties;
        private String creatorId;
        private String gameSessionId;
        private String idempotencyToken;
        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameSessionRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.aliasId(model.aliasId);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.name(model.name);
            this.gameProperties(model.gameProperties);
            this.creatorId(model.creatorId);
            this.gameSessionId(model.gameSessionId);
            this.idempotencyToken(model.idempotencyToken);
            this.gameSessionData(model.gameSessionData);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateGameSessionRequest build() {
            return new CreateGameSessionRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, CreateGameSessionRequest> {
        public Builder fleetId(String var1);

        public Builder aliasId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder creatorId(String var1);

        public Builder gameSessionId(String var1);

        public Builder idempotencyToken(String var1);

        public Builder gameSessionData(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

