/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration;

@SdkInternalApi
public class RuntimeConfigurationMarshaller {
    private static final MarshallingInfo<List> SERVERPROCESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerProcesses").build();
    private static final MarshallingInfo<Integer> MAXCONCURRENTGAMESESSIONACTIVATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrentGameSessionActivations").build();
    private static final MarshallingInfo<Integer> GAMESESSIONACTIVATIONTIMEOUTSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionActivationTimeoutSeconds").build();
    private static final RuntimeConfigurationMarshaller instance = new RuntimeConfigurationMarshaller();

    public static RuntimeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(RuntimeConfiguration runtimeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (runtimeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(runtimeConfiguration.serverProcesses(), SERVERPROCESSES_BINDING);
            protocolMarshaller.marshall((Object)runtimeConfiguration.maxConcurrentGameSessionActivations(), MAXCONCURRENTGAMESESSIONACTIVATIONS_BINDING);
            protocolMarshaller.marshall((Object)runtimeConfiguration.gameSessionActivationTimeoutSeconds(), GAMESESSIONACTIVATIONTIMEOUTSECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

