/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFleetCapacityRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateFleetCapacityRequest> {
    private final String fleetId;
    private final Integer desiredInstances;
    private final Integer minSize;
    private final Integer maxSize;

    private UpdateFleetCapacityRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.desiredInstances = builder.desiredInstances;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Integer desiredInstances() {
        return this.desiredInstances;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.desiredInstances() == null ? 0 : this.desiredInstances().hashCode());
        hashCode = 31 * hashCode + (this.minSize() == null ? 0 : this.minSize().hashCode());
        hashCode = 31 * hashCode + (this.maxSize() == null ? 0 : this.maxSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetCapacityRequest)) {
            return false;
        }
        UpdateFleetCapacityRequest other = (UpdateFleetCapacityRequest)((Object)obj);
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.desiredInstances() == null ^ this.desiredInstances() == null) {
            return false;
        }
        if (other.desiredInstances() != null && !other.desiredInstances().equals(this.desiredInstances())) {
            return false;
        }
        if (other.minSize() == null ^ this.minSize() == null) {
            return false;
        }
        if (other.minSize() != null && !other.minSize().equals(this.minSize())) {
            return false;
        }
        if (other.maxSize() == null ^ this.maxSize() == null) {
            return false;
        }
        return other.maxSize() == null || other.maxSize().equals(this.maxSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.desiredInstances() != null) {
            sb.append("DesiredInstances: ").append(this.desiredInstances()).append(",");
        }
        if (this.minSize() != null) {
            sb.append("MinSize: ").append(this.minSize()).append(",");
        }
        if (this.maxSize() != null) {
            sb.append("MaxSize: ").append(this.maxSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private Integer desiredInstances;
        private Integer minSize;
        private Integer maxSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetCapacityRequest model) {
            this.setFleetId(model.fleetId);
            this.setDesiredInstances(model.desiredInstances);
            this.setMinSize(model.minSize);
            this.setMaxSize(model.maxSize);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getDesiredInstances() {
            return this.desiredInstances;
        }

        @Override
        public final Builder desiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public final void setDesiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public UpdateFleetCapacityRequest build() {
            return new UpdateFleetCapacityRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateFleetCapacityRequest> {
        public Builder fleetId(String var1);

        public Builder desiredInstances(Integer var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);
    }
}

