/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus;
import software.amazon.awssdk.services.gamelift.transform.PlayerSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlayerSession
implements StructuredPojo,
ToCopyableBuilder<Builder, PlayerSession> {
    private final String playerSessionId;
    private final String playerId;
    private final String gameSessionId;
    private final String fleetId;
    private final Date creationTime;
    private final Date terminationTime;
    private final String status;
    private final String ipAddress;
    private final Integer port;
    private final String playerData;

    private PlayerSession(BuilderImpl builder) {
        this.playerSessionId = builder.playerSessionId;
        this.playerId = builder.playerId;
        this.gameSessionId = builder.gameSessionId;
        this.fleetId = builder.fleetId;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.playerData = builder.playerData;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public Date terminationTime() {
        return this.terminationTime;
    }

    public String status() {
        return this.status;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.playerSessionId() == null ? 0 : this.playerSessionId().hashCode());
        hashCode = 31 * hashCode + (this.playerId() == null ? 0 : this.playerId().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.terminationTime() == null ? 0 : this.terminationTime().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.playerData() == null ? 0 : this.playerData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerSession)) {
            return false;
        }
        PlayerSession other = (PlayerSession)obj;
        if (other.playerSessionId() == null ^ this.playerSessionId() == null) {
            return false;
        }
        if (other.playerSessionId() != null && !other.playerSessionId().equals(this.playerSessionId())) {
            return false;
        }
        if (other.playerId() == null ^ this.playerId() == null) {
            return false;
        }
        if (other.playerId() != null && !other.playerId().equals(this.playerId())) {
            return false;
        }
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.terminationTime() == null ^ this.terminationTime() == null) {
            return false;
        }
        if (other.terminationTime() != null && !other.terminationTime().equals(this.terminationTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.playerData() == null ^ this.playerData() == null) {
            return false;
        }
        return other.playerData() == null || other.playerData().equals(this.playerData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.playerSessionId() != null) {
            sb.append("PlayerSessionId: ").append(this.playerSessionId()).append(",");
        }
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.terminationTime() != null) {
            sb.append("TerminationTime: ").append(this.terminationTime()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.playerData() != null) {
            sb.append("PlayerData: ").append(this.playerData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String playerSessionId;
        private String playerId;
        private String gameSessionId;
        private String fleetId;
        private Date creationTime;
        private Date terminationTime;
        private String status;
        private String ipAddress;
        private Integer port;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerSession model) {
            this.setPlayerSessionId(model.playerSessionId);
            this.setPlayerId(model.playerId);
            this.setGameSessionId(model.gameSessionId);
            this.setFleetId(model.fleetId);
            this.setCreationTime(model.creationTime);
            this.setTerminationTime(model.terminationTime);
            this.setStatus(model.status);
            this.setIpAddress(model.ipAddress);
            this.setPort(model.port);
            this.setPlayerData(model.playerData);
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
        }

        public final Date getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Date terminationTime) {
            this.terminationTime = StandardMemberCopier.copy((Date)terminationTime);
            return this;
        }

        public final void setTerminationTime(Date terminationTime) {
            this.terminationTime = StandardMemberCopier.copy((Date)terminationTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PlayerSessionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(PlayerSessionStatus status) {
            this.status(status.toString());
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        public PlayerSession build() {
            return new PlayerSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlayerSession> {
        public Builder playerSessionId(String var1);

        public Builder playerId(String var1);

        public Builder gameSessionId(String var1);

        public Builder fleetId(String var1);

        public Builder creationTime(Date var1);

        public Builder terminationTime(Date var1);

        public Builder status(String var1);

        public Builder status(PlayerSessionStatus var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder playerData(String var1);
    }
}

