/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.gamelift.model.FleetStatus;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.services.gamelift.transform.FleetAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FleetAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, FleetAttributes> {
    private final String fleetId;
    private final String fleetArn;
    private final String description;
    private final String name;
    private final Date creationTime;
    private final Date terminationTime;
    private final String status;
    private final String buildId;
    private final String serverLaunchPath;
    private final String serverLaunchParameters;
    private final List<String> logPaths;
    private final String newGameSessionProtectionPolicy;
    private final String operatingSystem;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;

    private FleetAttributes(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.description = builder.description;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.buildId = builder.buildId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.operatingSystem = builder.operatingSystem;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String fleetArn() {
        return this.fleetArn;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public Date terminationTime() {
        return this.terminationTime;
    }

    public String status() {
        return this.status;
    }

    public String buildId() {
        return this.buildId;
    }

    public String serverLaunchPath() {
        return this.serverLaunchPath;
    }

    public String serverLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public List<String> logPaths() {
        return this.logPaths;
    }

    public String newGameSessionProtectionPolicy() {
        return this.newGameSessionProtectionPolicy;
    }

    public String operatingSystem() {
        return this.operatingSystem;
    }

    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public List<String> metricGroups() {
        return this.metricGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.fleetArn() == null ? 0 : this.fleetArn().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.terminationTime() == null ? 0 : this.terminationTime().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.buildId() == null ? 0 : this.buildId().hashCode());
        hashCode = 31 * hashCode + (this.serverLaunchPath() == null ? 0 : this.serverLaunchPath().hashCode());
        hashCode = 31 * hashCode + (this.serverLaunchParameters() == null ? 0 : this.serverLaunchParameters().hashCode());
        hashCode = 31 * hashCode + (this.logPaths() == null ? 0 : this.logPaths().hashCode());
        hashCode = 31 * hashCode + (this.newGameSessionProtectionPolicy() == null ? 0 : this.newGameSessionProtectionPolicy().hashCode());
        hashCode = 31 * hashCode + (this.operatingSystem() == null ? 0 : this.operatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.resourceCreationLimitPolicy() == null ? 0 : this.resourceCreationLimitPolicy().hashCode());
        hashCode = 31 * hashCode + (this.metricGroups() == null ? 0 : this.metricGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAttributes)) {
            return false;
        }
        FleetAttributes other = (FleetAttributes)obj;
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.fleetArn() == null ^ this.fleetArn() == null) {
            return false;
        }
        if (other.fleetArn() != null && !other.fleetArn().equals(this.fleetArn())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.terminationTime() == null ^ this.terminationTime() == null) {
            return false;
        }
        if (other.terminationTime() != null && !other.terminationTime().equals(this.terminationTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.buildId() == null ^ this.buildId() == null) {
            return false;
        }
        if (other.buildId() != null && !other.buildId().equals(this.buildId())) {
            return false;
        }
        if (other.serverLaunchPath() == null ^ this.serverLaunchPath() == null) {
            return false;
        }
        if (other.serverLaunchPath() != null && !other.serverLaunchPath().equals(this.serverLaunchPath())) {
            return false;
        }
        if (other.serverLaunchParameters() == null ^ this.serverLaunchParameters() == null) {
            return false;
        }
        if (other.serverLaunchParameters() != null && !other.serverLaunchParameters().equals(this.serverLaunchParameters())) {
            return false;
        }
        if (other.logPaths() == null ^ this.logPaths() == null) {
            return false;
        }
        if (other.logPaths() != null && !other.logPaths().equals(this.logPaths())) {
            return false;
        }
        if (other.newGameSessionProtectionPolicy() == null ^ this.newGameSessionProtectionPolicy() == null) {
            return false;
        }
        if (other.newGameSessionProtectionPolicy() != null && !other.newGameSessionProtectionPolicy().equals(this.newGameSessionProtectionPolicy())) {
            return false;
        }
        if (other.operatingSystem() == null ^ this.operatingSystem() == null) {
            return false;
        }
        if (other.operatingSystem() != null && !other.operatingSystem().equals(this.operatingSystem())) {
            return false;
        }
        if (other.resourceCreationLimitPolicy() == null ^ this.resourceCreationLimitPolicy() == null) {
            return false;
        }
        if (other.resourceCreationLimitPolicy() != null && !other.resourceCreationLimitPolicy().equals(this.resourceCreationLimitPolicy())) {
            return false;
        }
        if (other.metricGroups() == null ^ this.metricGroups() == null) {
            return false;
        }
        return other.metricGroups() == null || other.metricGroups().equals(this.metricGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.fleetArn() != null) {
            sb.append("FleetArn: ").append(this.fleetArn()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.terminationTime() != null) {
            sb.append("TerminationTime: ").append(this.terminationTime()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.buildId() != null) {
            sb.append("BuildId: ").append(this.buildId()).append(",");
        }
        if (this.serverLaunchPath() != null) {
            sb.append("ServerLaunchPath: ").append(this.serverLaunchPath()).append(",");
        }
        if (this.serverLaunchParameters() != null) {
            sb.append("ServerLaunchParameters: ").append(this.serverLaunchParameters()).append(",");
        }
        if (this.logPaths() != null) {
            sb.append("LogPaths: ").append(this.logPaths()).append(",");
        }
        if (this.newGameSessionProtectionPolicy() != null) {
            sb.append("NewGameSessionProtectionPolicy: ").append(this.newGameSessionProtectionPolicy()).append(",");
        }
        if (this.operatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystem()).append(",");
        }
        if (this.resourceCreationLimitPolicy() != null) {
            sb.append("ResourceCreationLimitPolicy: ").append(this.resourceCreationLimitPolicy()).append(",");
        }
        if (this.metricGroups() != null) {
            sb.append("MetricGroups: ").append(this.metricGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String description;
        private String name;
        private Date creationTime;
        private Date terminationTime;
        private String status;
        private String buildId;
        private String serverLaunchPath;
        private String serverLaunchParameters;
        private List<String> logPaths;
        private String newGameSessionProtectionPolicy;
        private String operatingSystem;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAttributes model) {
            this.setFleetId(model.fleetId);
            this.setFleetArn(model.fleetArn);
            this.setDescription(model.description);
            this.setName(model.name);
            this.setCreationTime(model.creationTime);
            this.setTerminationTime(model.terminationTime);
            this.setStatus(model.status);
            this.setBuildId(model.buildId);
            this.setServerLaunchPath(model.serverLaunchPath);
            this.setServerLaunchParameters(model.serverLaunchParameters);
            this.setLogPaths(model.logPaths);
            this.setNewGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.setOperatingSystem(model.operatingSystem);
            this.setResourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.setMetricGroups(model.metricGroups);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
        }

        public final Date getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Date terminationTime) {
            this.terminationTime = StandardMemberCopier.copy((Date)terminationTime);
            return this;
        }

        public final void setTerminationTime(Date terminationTime) {
            this.terminationTime = StandardMemberCopier.copy((Date)terminationTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(FleetStatus status) {
            this.status(status.toString());
        }

        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getServerLaunchPath() {
            return this.serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        public final String getServerLaunchParameters() {
            return this.serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        public final Collection<String> getLogPaths() {
            return this.logPaths;
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String ... logPaths) {
            if (this.logPaths == null) {
                this.logPaths = new ArrayList<String>(logPaths.length);
            }
            for (String e : logPaths) {
                this.logPaths.add(e);
            }
            return this;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        @SafeVarargs
        public final void setLogPaths(String ... logPaths) {
            if (this.logPaths == null) {
                this.logPaths = new ArrayList<String>(logPaths.length);
            }
            for (String e : logPaths) {
                this.logPaths.add(e);
            }
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy.toString());
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final void setOperatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
        }

        public final ResourceCreationLimitPolicy getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
        }

        public final Collection<String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            if (this.metricGroups == null) {
                this.metricGroups = new ArrayList<String>(metricGroups.length);
            }
            for (String e : metricGroups) {
                this.metricGroups.add(e);
            }
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @SafeVarargs
        public final void setMetricGroups(String ... metricGroups) {
            if (this.metricGroups == null) {
                this.metricGroups = new ArrayList<String>(metricGroups.length);
            }
            for (String e : metricGroups) {
                this.metricGroups.add(e);
            }
        }

        public FleetAttributes build() {
            return new FleetAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetAttributes> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder creationTime(Date var1);

        public Builder terminationTime(Date var1);

        public Builder status(String var1);

        public Builder status(FleetStatus var1);

        public Builder buildId(String var1);

        public Builder serverLaunchPath(String var1);

        public Builder serverLaunchParameters(String var1);

        public Builder logPaths(Collection<String> var1);

        public Builder logPaths(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);
    }
}

