/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The File Server Resource Manager (FSRM) configuration that Amazon FSx for Windows File Server uses for the file
 * system. When FSRM is enabled, you can manage and monitor storage quotas, file screening, storage reports, and file
 * classification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WindowsFsrmConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WindowsFsrmConfiguration.Builder, WindowsFsrmConfiguration> {
    private static final SdkField<Boolean> FSRM_SERVICE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FsrmServiceEnabled").getter(getter(WindowsFsrmConfiguration::fsrmServiceEnabled))
            .setter(setter(Builder::fsrmServiceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsrmServiceEnabled").build())
            .build();

    private static final SdkField<String> EVENT_LOG_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventLogDestination").getter(getter(WindowsFsrmConfiguration::eventLogDestination))
            .setter(setter(Builder::eventLogDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLogDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FSRM_SERVICE_ENABLED_FIELD,
            EVENT_LOG_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean fsrmServiceEnabled;

    private final String eventLogDestination;

    private WindowsFsrmConfiguration(BuilderImpl builder) {
        this.fsrmServiceEnabled = builder.fsrmServiceEnabled;
        this.eventLogDestination = builder.eventLogDestination;
    }

    /**
     * <p>
     * Specifies whether FSRM is enabled or disabled on the file system. When <code>TRUE</code>, the FSRM service is
     * enabled and monitor file operations according to configured policies. When <code>FALSE</code> or omitted, FSRM is
     * disabled. The default value is <code>FALSE</code>.
     * </p>
     * 
     * @return Specifies whether FSRM is enabled or disabled on the file system. When <code>TRUE</code>, the FSRM
     *         service is enabled and monitor file operations according to configured policies. When <code>FALSE</code>
     *         or omitted, FSRM is disabled. The default value is <code>FALSE</code>.
     */
    public final Boolean fsrmServiceEnabled() {
        return fsrmServiceEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the destination of the FSRM event logs. The destination can be any Amazon
     * CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
     * </p>
     * <p>
     * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name of
     * the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
     * </p>
     * <p>
     * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the
     * same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon
     * FSx file system.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the destination of the FSRM event logs. The destination can be any
     *         Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.</p>
     *         <p>
     *         The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The
     *         name of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
     *         </p>
     *         <p>
     *         The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be
     *         in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as
     *         your Amazon FSx file system.
     */
    public final String eventLogDestination() {
        return eventLogDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fsrmServiceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(eventLogDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsFsrmConfiguration)) {
            return false;
        }
        WindowsFsrmConfiguration other = (WindowsFsrmConfiguration) obj;
        return Objects.equals(fsrmServiceEnabled(), other.fsrmServiceEnabled())
                && Objects.equals(eventLogDestination(), other.eventLogDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WindowsFsrmConfiguration").add("FsrmServiceEnabled", fsrmServiceEnabled())
                .add("EventLogDestination", eventLogDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FsrmServiceEnabled":
            return Optional.ofNullable(clazz.cast(fsrmServiceEnabled()));
        case "EventLogDestination":
            return Optional.ofNullable(clazz.cast(eventLogDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FsrmServiceEnabled", FSRM_SERVICE_ENABLED_FIELD);
        map.put("EventLogDestination", EVENT_LOG_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WindowsFsrmConfiguration, T> g) {
        return obj -> g.apply((WindowsFsrmConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WindowsFsrmConfiguration> {
        /**
         * <p>
         * Specifies whether FSRM is enabled or disabled on the file system. When <code>TRUE</code>, the FSRM service is
         * enabled and monitor file operations according to configured policies. When <code>FALSE</code> or omitted,
         * FSRM is disabled. The default value is <code>FALSE</code>.
         * </p>
         * 
         * @param fsrmServiceEnabled
         *        Specifies whether FSRM is enabled or disabled on the file system. When <code>TRUE</code>, the FSRM
         *        service is enabled and monitor file operations according to configured policies. When
         *        <code>FALSE</code> or omitted, FSRM is disabled. The default value is <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsrmServiceEnabled(Boolean fsrmServiceEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the destination of the FSRM event logs. The destination can be any Amazon
         * CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
         * </p>
         * <p>
         * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name
         * of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
         * </p>
         * <p>
         * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in
         * the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your
         * Amazon FSx file system.
         * </p>
         * 
         * @param eventLogDestination
         *        The Amazon Resource Name (ARN) for the destination of the FSRM event logs. The destination can be any
         *        Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.</p>
         *        <p>
         *        The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The
         *        name of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code>
         *        prefix.
         *        </p>
         *        <p>
         *        The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must
         *        be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services
         *        account as your Amazon FSx file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventLogDestination(String eventLogDestination);
    }

    static final class BuilderImpl implements Builder {
        private Boolean fsrmServiceEnabled;

        private String eventLogDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsFsrmConfiguration model) {
            fsrmServiceEnabled(model.fsrmServiceEnabled);
            eventLogDestination(model.eventLogDestination);
        }

        public final Boolean getFsrmServiceEnabled() {
            return fsrmServiceEnabled;
        }

        public final void setFsrmServiceEnabled(Boolean fsrmServiceEnabled) {
            this.fsrmServiceEnabled = fsrmServiceEnabled;
        }

        @Override
        public final Builder fsrmServiceEnabled(Boolean fsrmServiceEnabled) {
            this.fsrmServiceEnabled = fsrmServiceEnabled;
            return this;
        }

        public final String getEventLogDestination() {
            return eventLogDestination;
        }

        public final void setEventLogDestination(String eventLogDestination) {
            this.eventLogDestination = eventLogDestination;
        }

        @Override
        public final Builder eventLogDestination(String eventLogDestination) {
            this.eventLogDestination = eventLogDestination;
            return this;
        }

        @Override
        public WindowsFsrmConfiguration build() {
            return new WindowsFsrmConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
