/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify changes to the OpenZFS configuration for the volume that you are updating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOpenZFSVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateOpenZFSVolumeConfiguration.Builder, UpdateOpenZFSVolumeConfiguration> {
    private static final SdkField<Integer> STORAGE_CAPACITY_RESERVATION_GIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacityReservationGiB")
            .getter(getter(UpdateOpenZFSVolumeConfiguration::storageCapacityReservationGiB))
            .setter(setter(Builder::storageCapacityReservationGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityReservationGiB")
                    .build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_QUOTA_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacityQuotaGiB").getter(getter(UpdateOpenZFSVolumeConfiguration::storageCapacityQuotaGiB))
            .setter(setter(Builder::storageCapacityQuotaGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityQuotaGiB").build())
            .build();

    private static final SdkField<Integer> RECORD_SIZE_KIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecordSizeKiB").getter(getter(UpdateOpenZFSVolumeConfiguration::recordSizeKiB))
            .setter(setter(Builder::recordSizeKiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordSizeKiB").build()).build();

    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataCompressionType").getter(getter(UpdateOpenZFSVolumeConfiguration::dataCompressionTypeAsString))
            .setter(setter(Builder::dataCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build())
            .build();

    private static final SdkField<List<OpenZFSNfsExport>> NFS_EXPORTS_FIELD = SdkField
            .<List<OpenZFSNfsExport>> builder(MarshallingType.LIST)
            .memberName("NfsExports")
            .getter(getter(UpdateOpenZFSVolumeConfiguration::nfsExports))
            .setter(setter(Builder::nfsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NfsExports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpenZFSNfsExport> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpenZFSNfsExport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OpenZFSUserOrGroupQuota>> USER_AND_GROUP_QUOTAS_FIELD = SdkField
            .<List<OpenZFSUserOrGroupQuota>> builder(MarshallingType.LIST)
            .memberName("UserAndGroupQuotas")
            .getter(getter(UpdateOpenZFSVolumeConfiguration::userAndGroupQuotas))
            .setter(setter(Builder::userAndGroupQuotas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAndGroupQuotas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpenZFSUserOrGroupQuota> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpenZFSUserOrGroupQuota::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadOnly").getter(getter(UpdateOpenZFSVolumeConfiguration::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_CAPACITY_RESERVATION_GIB_FIELD, STORAGE_CAPACITY_QUOTA_GIB_FIELD, RECORD_SIZE_KIB_FIELD,
            DATA_COMPRESSION_TYPE_FIELD, NFS_EXPORTS_FIELD, USER_AND_GROUP_QUOTAS_FIELD, READ_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer storageCapacityReservationGiB;

    private final Integer storageCapacityQuotaGiB;

    private final Integer recordSizeKiB;

    private final String dataCompressionType;

    private final List<OpenZFSNfsExport> nfsExports;

    private final List<OpenZFSUserOrGroupQuota> userAndGroupQuotas;

    private final Boolean readOnly;

    private UpdateOpenZFSVolumeConfiguration(BuilderImpl builder) {
        this.storageCapacityReservationGiB = builder.storageCapacityReservationGiB;
        this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
        this.recordSizeKiB = builder.recordSizeKiB;
        this.dataCompressionType = builder.dataCompressionType;
        this.nfsExports = builder.nfsExports;
        this.userAndGroupQuotas = builder.userAndGroupQuotas;
        this.readOnly = builder.readOnly;
    }

    /**
     * <p>
     * The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more storage than
     * the parent volume has reserved. You can specify a value of <code>-1</code> to unset a volume's storage capacity
     * reservation.
     * </p>
     * 
     * @return The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more
     *         storage than the parent volume has reserved. You can specify a value of <code>-1</code> to unset a
     *         volume's storage capacity reservation.
     */
    public final Integer storageCapacityReservationGiB() {
        return storageCapacityReservationGiB;
    }

    /**
     * <p>
     * The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can specify a quota
     * larger than the storage on the parent volume. You can specify a value of <code>-1</code> to unset a volume's
     * storage capacity quota.
     * </p>
     * 
     * @return The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can specify
     *         a quota larger than the storage on the parent volume. You can specify a value of <code>-1</code> to unset
     *         a volume's storage capacity quota.
     */
    public final Integer storageCapacityQuotaGiB() {
        return storageCapacityQuotaGiB;
    }

    /**
     * <p>
     * Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256,
     * 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows
     * can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For
     * additional guidance on when to set a custom record size, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips for
     * maximizing performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     * </p>
     * 
     * @return Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64,
     *         128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size.
     *         Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a
     *         larger record size. For additional guidance on when to set a custom record size, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips
     *         for maximizing performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
     */
    public final Integer recordSizeKiB() {
        return recordSizeKiB;
    }

    /**
     * <p>
     * Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by
     * default.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared
     * to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard,
     * LZ4 is less compute-intensive and delivers higher write throughput speeds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCompressionType} will return {@link OpenZFSDataCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCompressionTypeAsString}.
     * </p>
     * 
     * @return Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code>
     *         by default.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm.
     *         Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to
     *         Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
     *         </p>
     *         </li>
     * @see OpenZFSDataCompressionType
     */
    public final OpenZFSDataCompressionType dataCompressionType() {
        return OpenZFSDataCompressionType.fromValue(dataCompressionType);
    }

    /**
     * <p>
     * Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by
     * default.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared
     * to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard,
     * LZ4 is less compute-intensive and delivers higher write throughput speeds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCompressionType} will return {@link OpenZFSDataCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCompressionTypeAsString}.
     * </p>
     * 
     * @return Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code>
     *         by default.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm.
     *         Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to
     *         Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
     *         </p>
     *         </li>
     * @see OpenZFSDataCompressionType
     */
    public final String dataCompressionTypeAsString() {
        return dataCompressionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the NfsExports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNfsExports() {
        return nfsExports != null && !(nfsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration object for mounting a Network File System (NFS) file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNfsExports} method.
     * </p>
     * 
     * @return The configuration object for mounting a Network File System (NFS) file system.
     */
    public final List<OpenZFSNfsExport> nfsExports() {
        return nfsExports;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAndGroupQuotas property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAndGroupQuotas() {
        return userAndGroupQuotas != null && !(userAndGroupQuotas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object specifying how much storage users or groups can use on the volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAndGroupQuotas} method.
     * </p>
     * 
     * @return An object specifying how much storage users or groups can use on the volume.
     */
    public final List<OpenZFSUserOrGroupQuota> userAndGroupQuotas() {
        return userAndGroupQuotas;
    }

    /**
     * <p>
     * A Boolean value indicating whether the volume is read-only.
     * </p>
     * 
     * @return A Boolean value indicating whether the volume is read-only.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacityReservationGiB());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacityQuotaGiB());
        hashCode = 31 * hashCode + Objects.hashCode(recordSizeKiB());
        hashCode = 31 * hashCode + Objects.hashCode(dataCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNfsExports() ? nfsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAndGroupQuotas() ? userAndGroupQuotas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenZFSVolumeConfiguration)) {
            return false;
        }
        UpdateOpenZFSVolumeConfiguration other = (UpdateOpenZFSVolumeConfiguration) obj;
        return Objects.equals(storageCapacityReservationGiB(), other.storageCapacityReservationGiB())
                && Objects.equals(storageCapacityQuotaGiB(), other.storageCapacityQuotaGiB())
                && Objects.equals(recordSizeKiB(), other.recordSizeKiB())
                && Objects.equals(dataCompressionTypeAsString(), other.dataCompressionTypeAsString())
                && hasNfsExports() == other.hasNfsExports() && Objects.equals(nfsExports(), other.nfsExports())
                && hasUserAndGroupQuotas() == other.hasUserAndGroupQuotas()
                && Objects.equals(userAndGroupQuotas(), other.userAndGroupQuotas())
                && Objects.equals(readOnly(), other.readOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOpenZFSVolumeConfiguration")
                .add("StorageCapacityReservationGiB", storageCapacityReservationGiB())
                .add("StorageCapacityQuotaGiB", storageCapacityQuotaGiB()).add("RecordSizeKiB", recordSizeKiB())
                .add("DataCompressionType", dataCompressionTypeAsString())
                .add("NfsExports", hasNfsExports() ? nfsExports() : null)
                .add("UserAndGroupQuotas", hasUserAndGroupQuotas() ? userAndGroupQuotas() : null).add("ReadOnly", readOnly())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageCapacityReservationGiB":
            return Optional.ofNullable(clazz.cast(storageCapacityReservationGiB()));
        case "StorageCapacityQuotaGiB":
            return Optional.ofNullable(clazz.cast(storageCapacityQuotaGiB()));
        case "RecordSizeKiB":
            return Optional.ofNullable(clazz.cast(recordSizeKiB()));
        case "DataCompressionType":
            return Optional.ofNullable(clazz.cast(dataCompressionTypeAsString()));
        case "NfsExports":
            return Optional.ofNullable(clazz.cast(nfsExports()));
        case "UserAndGroupQuotas":
            return Optional.ofNullable(clazz.cast(userAndGroupQuotas()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageCapacityReservationGiB", STORAGE_CAPACITY_RESERVATION_GIB_FIELD);
        map.put("StorageCapacityQuotaGiB", STORAGE_CAPACITY_QUOTA_GIB_FIELD);
        map.put("RecordSizeKiB", RECORD_SIZE_KIB_FIELD);
        map.put("DataCompressionType", DATA_COMPRESSION_TYPE_FIELD);
        map.put("NfsExports", NFS_EXPORTS_FIELD);
        map.put("UserAndGroupQuotas", USER_AND_GROUP_QUOTAS_FIELD);
        map.put("ReadOnly", READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenZFSVolumeConfiguration, T> g) {
        return obj -> g.apply((UpdateOpenZFSVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateOpenZFSVolumeConfiguration> {
        /**
         * <p>
         * The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more storage
         * than the parent volume has reserved. You can specify a value of <code>-1</code> to unset a volume's storage
         * capacity reservation.
         * </p>
         * 
         * @param storageCapacityReservationGiB
         *        The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more
         *        storage than the parent volume has reserved. You can specify a value of <code>-1</code> to unset a
         *        volume's storage capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacityReservationGiB(Integer storageCapacityReservationGiB);

        /**
         * <p>
         * The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can specify a
         * quota larger than the storage on the parent volume. You can specify a value of <code>-1</code> to unset a
         * volume's storage capacity quota.
         * </p>
         * 
         * @param storageCapacityQuotaGiB
         *        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can
         *        specify a quota larger than the storage on the parent volume. You can specify a value of
         *        <code>-1</code> to unset a volume's storage capacity quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB);

        /**
         * <p>
         * Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128,
         * 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database
         * workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record
         * size. For additional guidance on when to set a custom record size, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips for
         * maximizing performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * </p>
         * 
         * @param recordSizeKiB
         *        Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64,
         *        128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size.
         *        Database workflows can benefit from a smaller record size, while streaming workflows can benefit from
         *        a larger record size. For additional guidance on when to set a custom record size, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips
         *        for maximizing performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordSizeKiB(Integer recordSizeKiB);

        /**
         * <p>
         * Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by
         * default.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm.
         * Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to
         * Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataCompressionType
         *        Specifies the method used to compress the data on the volume. The compression type is
         *        <code>NONE</code> by default.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression
         *        algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage
         *        utilization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to
         *        Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         *        </p>
         *        </li>
         * @see OpenZFSDataCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSDataCompressionType
         */
        Builder dataCompressionType(String dataCompressionType);

        /**
         * <p>
         * Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by
         * default.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm.
         * Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to
         * Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataCompressionType
         *        Specifies the method used to compress the data on the volume. The compression type is
         *        <code>NONE</code> by default.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression
         *        algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage
         *        utilization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to
         *        Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         *        </p>
         *        </li>
         * @see OpenZFSDataCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSDataCompressionType
         */
        Builder dataCompressionType(OpenZFSDataCompressionType dataCompressionType);

        /**
         * <p>
         * The configuration object for mounting a Network File System (NFS) file system.
         * </p>
         * 
         * @param nfsExports
         *        The configuration object for mounting a Network File System (NFS) file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsExports(Collection<OpenZFSNfsExport> nfsExports);

        /**
         * <p>
         * The configuration object for mounting a Network File System (NFS) file system.
         * </p>
         * 
         * @param nfsExports
         *        The configuration object for mounting a Network File System (NFS) file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsExports(OpenZFSNfsExport... nfsExports);

        /**
         * <p>
         * The configuration object for mounting a Network File System (NFS) file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport.Builder#build()} is called immediately and
         * its result is passed to {@link #nfsExports(List<OpenZFSNfsExport>)}.
         * 
         * @param nfsExports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfsExports(java.util.Collection<OpenZFSNfsExport>)
         */
        Builder nfsExports(Consumer<OpenZFSNfsExport.Builder>... nfsExports);

        /**
         * <p>
         * An object specifying how much storage users or groups can use on the volume.
         * </p>
         * 
         * @param userAndGroupQuotas
         *        An object specifying how much storage users or groups can use on the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas);

        /**
         * <p>
         * An object specifying how much storage users or groups can use on the volume.
         * </p>
         * 
         * @param userAndGroupQuotas
         *        An object specifying how much storage users or groups can use on the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAndGroupQuotas(OpenZFSUserOrGroupQuota... userAndGroupQuotas);

        /**
         * <p>
         * An object specifying how much storage users or groups can use on the volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota.Builder#build()} is called
         * immediately and its result is passed to {@link #userAndGroupQuotas(List<OpenZFSUserOrGroupQuota>)}.
         * 
         * @param userAndGroupQuotas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAndGroupQuotas(java.util.Collection<OpenZFSUserOrGroupQuota>)
         */
        Builder userAndGroupQuotas(Consumer<OpenZFSUserOrGroupQuota.Builder>... userAndGroupQuotas);

        /**
         * <p>
         * A Boolean value indicating whether the volume is read-only.
         * </p>
         * 
         * @param readOnly
         *        A Boolean value indicating whether the volume is read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);
    }

    static final class BuilderImpl implements Builder {
        private Integer storageCapacityReservationGiB;

        private Integer storageCapacityQuotaGiB;

        private Integer recordSizeKiB;

        private String dataCompressionType;

        private List<OpenZFSNfsExport> nfsExports = DefaultSdkAutoConstructList.getInstance();

        private List<OpenZFSUserOrGroupQuota> userAndGroupQuotas = DefaultSdkAutoConstructList.getInstance();

        private Boolean readOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenZFSVolumeConfiguration model) {
            storageCapacityReservationGiB(model.storageCapacityReservationGiB);
            storageCapacityQuotaGiB(model.storageCapacityQuotaGiB);
            recordSizeKiB(model.recordSizeKiB);
            dataCompressionType(model.dataCompressionType);
            nfsExports(model.nfsExports);
            userAndGroupQuotas(model.userAndGroupQuotas);
            readOnly(model.readOnly);
        }

        public final Integer getStorageCapacityReservationGiB() {
            return storageCapacityReservationGiB;
        }

        public final void setStorageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
            this.storageCapacityReservationGiB = storageCapacityReservationGiB;
        }

        @Override
        public final Builder storageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
            this.storageCapacityReservationGiB = storageCapacityReservationGiB;
            return this;
        }

        public final Integer getStorageCapacityQuotaGiB() {
            return storageCapacityQuotaGiB;
        }

        public final void setStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
        }

        @Override
        public final Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
            return this;
        }

        public final Integer getRecordSizeKiB() {
            return recordSizeKiB;
        }

        public final void setRecordSizeKiB(Integer recordSizeKiB) {
            this.recordSizeKiB = recordSizeKiB;
        }

        @Override
        public final Builder recordSizeKiB(Integer recordSizeKiB) {
            this.recordSizeKiB = recordSizeKiB;
            return this;
        }

        public final String getDataCompressionType() {
            return dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        public final Builder dataCompressionType(OpenZFSDataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public final List<OpenZFSNfsExport.Builder> getNfsExports() {
            List<OpenZFSNfsExport.Builder> result = OpenZFSNfsExportsCopier.copyToBuilder(this.nfsExports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNfsExports(Collection<OpenZFSNfsExport.BuilderImpl> nfsExports) {
            this.nfsExports = OpenZFSNfsExportsCopier.copyFromBuilder(nfsExports);
        }

        @Override
        public final Builder nfsExports(Collection<OpenZFSNfsExport> nfsExports) {
            this.nfsExports = OpenZFSNfsExportsCopier.copy(nfsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsExports(OpenZFSNfsExport... nfsExports) {
            nfsExports(Arrays.asList(nfsExports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsExports(Consumer<OpenZFSNfsExport.Builder>... nfsExports) {
            nfsExports(Stream.of(nfsExports).map(c -> OpenZFSNfsExport.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OpenZFSUserOrGroupQuota.Builder> getUserAndGroupQuotas() {
            List<OpenZFSUserOrGroupQuota.Builder> result = OpenZFSUserAndGroupQuotasCopier.copyToBuilder(this.userAndGroupQuotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota.BuilderImpl> userAndGroupQuotas) {
            this.userAndGroupQuotas = OpenZFSUserAndGroupQuotasCopier.copyFromBuilder(userAndGroupQuotas);
        }

        @Override
        public final Builder userAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
            this.userAndGroupQuotas = OpenZFSUserAndGroupQuotasCopier.copy(userAndGroupQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAndGroupQuotas(OpenZFSUserOrGroupQuota... userAndGroupQuotas) {
            userAndGroupQuotas(Arrays.asList(userAndGroupQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAndGroupQuotas(Consumer<OpenZFSUserOrGroupQuota.Builder>... userAndGroupQuotas) {
            userAndGroupQuotas(Stream.of(userAndGroupQuotas).map(c -> OpenZFSUserOrGroupQuota.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        public UpdateOpenZFSVolumeConfiguration build() {
            return new UpdateOpenZFSVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
