/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the S3 access point configuration of the S3 access point attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessPoint implements SdkPojo, Serializable, ToCopyableBuilder<S3AccessPoint.Builder, S3AccessPoint> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(S3AccessPoint::resourceARN)).setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(S3AccessPoint::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<S3AccessPointVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<S3AccessPointVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(S3AccessPoint::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(S3AccessPointVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            ALIAS_FIELD, VPC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceARN;

    private final String alias;

    private final S3AccessPointVpcConfiguration vpcConfiguration;

    private S3AccessPoint(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.alias = builder.alias;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * he S3 access point's ARN.
     * </p>
     * 
     * @return he S3 access point's ARN.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * The S3 access point's alias.
     * </p>
     * 
     * @return The S3 access point's alias.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The S3 access point's virtual private cloud (VPC) configuration.
     * </p>
     * 
     * @return The S3 access point's virtual private cloud (VPC) configuration.
     */
    public final S3AccessPointVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPoint)) {
            return false;
        }
        S3AccessPoint other = (S3AccessPoint) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(alias(), other.alias())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3AccessPoint").add("ResourceARN", resourceARN()).add("Alias", alias())
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessPoint, T> g) {
        return obj -> g.apply((S3AccessPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessPoint> {
        /**
         * <p>
         * he S3 access point's ARN.
         * </p>
         * 
         * @param resourceARN
         *        he S3 access point's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * The S3 access point's alias.
         * </p>
         * 
         * @param alias
         *        The S3 access point's alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The S3 access point's virtual private cloud (VPC) configuration.
         * </p>
         * 
         * @param vpcConfiguration
         *        The S3 access point's virtual private cloud (VPC) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(S3AccessPointVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The S3 access point's virtual private cloud (VPC) configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3AccessPointVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3AccessPointVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessPointVpcConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfiguration(S3AccessPointVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link S3AccessPointVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(S3AccessPointVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<S3AccessPointVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(S3AccessPointVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String alias;

        private S3AccessPointVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessPoint model) {
            resourceARN(model.resourceARN);
            alias(model.alias);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final S3AccessPointVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(S3AccessPointVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(S3AccessPointVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public S3AccessPoint build() {
            return new S3AccessPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
