/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the retention period of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Files can't
 * be deleted or modified during the retention period.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html">Working
 * with the retention period in SnapLock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionPeriod implements SdkPojo, Serializable, ToCopyableBuilder<RetentionPeriod.Builder, RetentionPeriod> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RetentionPeriod::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Value")
            .getter(getter(RetentionPeriod::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer value;

    private RetentionPeriod(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid
     * types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set it to
     * <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetentionPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of
     *         the valid types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set it to
     *         <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
     * @see RetentionPeriodType
     */
    public final RetentionPeriodType type() {
        return RetentionPeriodType.fromValue(type);
    }

    /**
     * <p>
     * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid
     * types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set it to
     * <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetentionPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of
     *         the valid types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set it to
     *         <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
     * @see RetentionPeriodType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume. You can't set a value
     * for <code>INFINITE</code> or <code>UNSPECIFIED</code>. For all other options, the following ranges are valid:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Seconds</code>: 0 - 65,535
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Minutes</code>: 0 - 65,535
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Hours</code>: 0 - 24
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Days</code>: 0 - 365
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Months</code>: 0 - 12
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Years</code>: 0 - 100
     * </p>
     * </li>
     * </ul>
     * 
     * @return Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume. You can't set a
     *         value for <code>INFINITE</code> or <code>UNSPECIFIED</code>. For all other options, the following ranges
     *         are valid: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Seconds</code>: 0 - 65,535
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Minutes</code>: 0 - 65,535
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Hours</code>: 0 - 24
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Days</code>: 0 - 365
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Months</code>: 0 - 12
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Years</code>: 0 - 100
     *         </p>
     *         </li>
     */
    public final Integer value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionPeriod)) {
            return false;
        }
        RetentionPeriod other = (RetentionPeriod) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionPeriod").add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetentionPeriod, T> g) {
        return obj -> g.apply((RetentionPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionPeriod> {
        /**
         * <p>
         * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the
         * valid types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set it to
         * <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
         * </p>
         * 
         * @param type
         *        Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one
         *        of the valid types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set
         *        it to <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
         * @see RetentionPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionPeriodType
         */
        Builder type(String type);

        /**
         * <p>
         * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the
         * valid types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set it to
         * <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
         * </p>
         * 
         * @param type
         *        Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one
         *        of the valid types. If you set it to <code>INFINITE</code>, the files are retained forever. If you set
         *        it to <code>UNSPECIFIED</code>, the files are retained until you set an explicit retention period.
         * @see RetentionPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionPeriodType
         */
        Builder type(RetentionPeriodType type);

        /**
         * <p>
         * Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume. You can't set a
         * value for <code>INFINITE</code> or <code>UNSPECIFIED</code>. For all other options, the following ranges are
         * valid:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Seconds</code>: 0 - 65,535
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Minutes</code>: 0 - 65,535
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Hours</code>: 0 - 24
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Days</code>: 0 - 365
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Months</code>: 0 - 12
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Years</code>: 0 - 100
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume. You can't set
         *        a value for <code>INFINITE</code> or <code>UNSPECIFIED</code>. For all other options, the following
         *        ranges are valid: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Seconds</code>: 0 - 65,535
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Minutes</code>: 0 - 65,535
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Hours</code>: 0 - 24
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Days</code>: 0 - 365
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Months</code>: 0 - 12
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Years</code>: 0 - 100
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer value;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionPeriod model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetentionPeriodType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        @Override
        public RetentionPeriod build() {
            return new RetentionPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
