/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Network File System (NFS) configurations for mounting an Amazon FSx for OpenZFS file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenZFSNfsExport implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenZFSNfsExport.Builder, OpenZFSNfsExport> {
    private static final SdkField<List<OpenZFSClientConfiguration>> CLIENT_CONFIGURATIONS_FIELD = SdkField
            .<List<OpenZFSClientConfiguration>> builder(MarshallingType.LIST)
            .memberName("ClientConfigurations")
            .getter(getter(OpenZFSNfsExport::clientConfigurations))
            .setter(setter(Builder::clientConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpenZFSClientConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpenZFSClientConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<OpenZFSClientConfiguration> clientConfigurations;

    private OpenZFSNfsExport(BuilderImpl builder) {
        this.clientConfigurations = builder.clientConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientConfigurations() {
        return clientConfigurations != null && !(clientConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientConfigurations} method.
     * </p>
     * 
     * @return A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
     */
    public final List<OpenZFSClientConfiguration> clientConfigurations() {
        return clientConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClientConfigurations() ? clientConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSNfsExport)) {
            return false;
        }
        OpenZFSNfsExport other = (OpenZFSNfsExport) obj;
        return hasClientConfigurations() == other.hasClientConfigurations()
                && Objects.equals(clientConfigurations(), other.clientConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenZFSNfsExport")
                .add("ClientConfigurations", hasClientConfigurations() ? clientConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientConfigurations":
            return Optional.ofNullable(clazz.cast(clientConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientConfigurations", CLIENT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSNfsExport, T> g) {
        return obj -> g.apply((OpenZFSNfsExport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenZFSNfsExport> {
        /**
         * <p>
         * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
         * </p>
         * 
         * @param clientConfigurations
         *        A list of configuration objects that contain the client and options for mounting the OpenZFS file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConfigurations(Collection<OpenZFSClientConfiguration> clientConfigurations);

        /**
         * <p>
         * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
         * </p>
         * 
         * @param clientConfigurations
         *        A list of configuration objects that contain the client and options for mounting the OpenZFS file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConfigurations(OpenZFSClientConfiguration... clientConfigurations);

        /**
         * <p>
         * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #clientConfigurations(List<OpenZFSClientConfiguration>)}.
         * 
         * @param clientConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.OpenZFSClientConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientConfigurations(java.util.Collection<OpenZFSClientConfiguration>)
         */
        Builder clientConfigurations(Consumer<OpenZFSClientConfiguration.Builder>... clientConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<OpenZFSClientConfiguration> clientConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSNfsExport model) {
            clientConfigurations(model.clientConfigurations);
        }

        public final List<OpenZFSClientConfiguration.Builder> getClientConfigurations() {
            List<OpenZFSClientConfiguration.Builder> result = OpenZFSClientConfigurationsCopier
                    .copyToBuilder(this.clientConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientConfigurations(Collection<OpenZFSClientConfiguration.BuilderImpl> clientConfigurations) {
            this.clientConfigurations = OpenZFSClientConfigurationsCopier.copyFromBuilder(clientConfigurations);
        }

        @Override
        public final Builder clientConfigurations(Collection<OpenZFSClientConfiguration> clientConfigurations) {
            this.clientConfigurations = OpenZFSClientConfigurationsCopier.copy(clientConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientConfigurations(OpenZFSClientConfiguration... clientConfigurations) {
            clientConfigurations(Arrays.asList(clientConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientConfigurations(Consumer<OpenZFSClientConfiguration.Builder>... clientConfigurations) {
            clientConfigurations(Stream.of(clientConfigurations)
                    .map(c -> OpenZFSClientConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OpenZFSNfsExport build() {
            return new OpenZFSNfsExport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
