/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the optional provisioned SSD read cache on Amazon FSx for Lustre file systems that use the
 * Intelligent-Tiering storage class.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LustreReadCacheConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LustreReadCacheConfiguration.Builder, LustreReadCacheConfiguration> {
    private static final SdkField<String> SIZING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizingMode").getter(getter(LustreReadCacheConfiguration::sizingModeAsString))
            .setter(setter(Builder::sizingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingMode").build()).build();

    private static final SdkField<Integer> SIZE_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeGiB").getter(getter(LustreReadCacheConfiguration::sizeGiB)).setter(setter(Builder::sizeGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeGiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZING_MODE_FIELD,
            SIZE_GIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sizingMode;

    private final Integer sizeGiB;

    private LustreReadCacheConfiguration(BuilderImpl builder) {
        this.sizingMode = builder.sizingMode;
        this.sizeGiB = builder.sizeGiB;
    }

    /**
     * <p>
     * Specifies how the provisioned SSD read cache is sized, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering file
     * system.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized based on
     * your throughput capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sizingMode} will
     * return {@link LustreReadCacheSizingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sizingModeAsString}.
     * </p>
     * 
     * @return Specifies how the provisioned SSD read cache is sized, as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering
     *         file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized
     *         based on your throughput capacity.
     *         </p>
     *         </li>
     * @see LustreReadCacheSizingMode
     */
    public final LustreReadCacheSizingMode sizingMode() {
        return LustreReadCacheSizingMode.fromValue(sizingMode);
    }

    /**
     * <p>
     * Specifies how the provisioned SSD read cache is sized, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering file
     * system.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized based on
     * your throughput capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sizingMode} will
     * return {@link LustreReadCacheSizingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sizingModeAsString}.
     * </p>
     * 
     * @return Specifies how the provisioned SSD read cache is sized, as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering
     *         file system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized
     *         based on your throughput capacity.
     *         </p>
     *         </li>
     * @see LustreReadCacheSizingMode
     */
    public final String sizingModeAsString() {
        return sizingMode;
    }

    /**
     * <p>
     * Required if <code>SizingMode</code> is set to <code>USER_PROVISIONED</code>. Specifies the size of the file
     * system's SSD read cache, in gibibytes (GiB).
     * </p>
     * <p>
     * The SSD read cache size is distributed across provisioned file servers in your file system. Intelligent-Tiering
     * file systems support a minimum of 32 GiB and maximum of 131072 GiB for SSD read cache size for every 4,000 MB/s
     * of throughput capacity provisioned.
     * </p>
     * 
     * @return Required if <code>SizingMode</code> is set to <code>USER_PROVISIONED</code>. Specifies the size of the
     *         file system's SSD read cache, in gibibytes (GiB). </p>
     *         <p>
     *         The SSD read cache size is distributed across provisioned file servers in your file system.
     *         Intelligent-Tiering file systems support a minimum of 32 GiB and maximum of 131072 GiB for SSD read cache
     *         size for every 4,000 MB/s of throughput capacity provisioned.
     */
    public final Integer sizeGiB() {
        return sizeGiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeGiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreReadCacheConfiguration)) {
            return false;
        }
        LustreReadCacheConfiguration other = (LustreReadCacheConfiguration) obj;
        return Objects.equals(sizingModeAsString(), other.sizingModeAsString()) && Objects.equals(sizeGiB(), other.sizeGiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LustreReadCacheConfiguration").add("SizingMode", sizingModeAsString()).add("SizeGiB", sizeGiB())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizingMode":
            return Optional.ofNullable(clazz.cast(sizingModeAsString()));
        case "SizeGiB":
            return Optional.ofNullable(clazz.cast(sizeGiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SizingMode", SIZING_MODE_FIELD);
        map.put("SizeGiB", SIZE_GIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LustreReadCacheConfiguration, T> g) {
        return obj -> g.apply((LustreReadCacheConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LustreReadCacheConfiguration> {
        /**
         * <p>
         * Specifies how the provisioned SSD read cache is sized, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering file
         * system.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized based
         * on your throughput capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizingMode
         *        Specifies how the provisioned SSD read cache is sized, as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering
         *        file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically
         *        sized based on your throughput capacity.
         *        </p>
         *        </li>
         * @see LustreReadCacheSizingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreReadCacheSizingMode
         */
        Builder sizingMode(String sizingMode);

        /**
         * <p>
         * Specifies how the provisioned SSD read cache is sized, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering file
         * system.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically sized based
         * on your throughput capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizingMode
         *        Specifies how the provisioned SSD read cache is sized, as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set to <code>NO_CACHE</code> if you do not want to use an SSD read cache with your Intelligent-Tiering
         *        file system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>USER_PROVISIONED</code> to specify the exact size of your SSD read cache.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>PROPORTIONAL_TO_THROUGHPUT_CAPACITY</code> to have your SSD read cache automatically
         *        sized based on your throughput capacity.
         *        </p>
         *        </li>
         * @see LustreReadCacheSizingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreReadCacheSizingMode
         */
        Builder sizingMode(LustreReadCacheSizingMode sizingMode);

        /**
         * <p>
         * Required if <code>SizingMode</code> is set to <code>USER_PROVISIONED</code>. Specifies the size of the file
         * system's SSD read cache, in gibibytes (GiB).
         * </p>
         * <p>
         * The SSD read cache size is distributed across provisioned file servers in your file system.
         * Intelligent-Tiering file systems support a minimum of 32 GiB and maximum of 131072 GiB for SSD read cache
         * size for every 4,000 MB/s of throughput capacity provisioned.
         * </p>
         * 
         * @param sizeGiB
         *        Required if <code>SizingMode</code> is set to <code>USER_PROVISIONED</code>. Specifies the size of the
         *        file system's SSD read cache, in gibibytes (GiB). </p>
         *        <p>
         *        The SSD read cache size is distributed across provisioned file servers in your file system.
         *        Intelligent-Tiering file systems support a minimum of 32 GiB and maximum of 131072 GiB for SSD read
         *        cache size for every 4,000 MB/s of throughput capacity provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeGiB(Integer sizeGiB);
    }

    static final class BuilderImpl implements Builder {
        private String sizingMode;

        private Integer sizeGiB;

        private BuilderImpl() {
        }

        private BuilderImpl(LustreReadCacheConfiguration model) {
            sizingMode(model.sizingMode);
            sizeGiB(model.sizeGiB);
        }

        public final String getSizingMode() {
            return sizingMode;
        }

        public final void setSizingMode(String sizingMode) {
            this.sizingMode = sizingMode;
        }

        @Override
        public final Builder sizingMode(String sizingMode) {
            this.sizingMode = sizingMode;
            return this;
        }

        @Override
        public final Builder sizingMode(LustreReadCacheSizingMode sizingMode) {
            this.sizingMode(sizingMode == null ? null : sizingMode.toString());
            return this;
        }

        public final Integer getSizeGiB() {
            return sizeGiB;
        }

        public final void setSizeGiB(Integer sizeGiB) {
            this.sizeGiB = sizeGiB;
        }

        @Override
        public final Builder sizeGiB(Integer sizeGiB) {
            this.sizeGiB = sizeGiB;
            return this;
        }

        @Override
        public LustreReadCacheConfiguration build() {
            return new LustreReadCacheConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
