/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVolumeResponse extends FSxResponse implements
        ToCopyableBuilder<DeleteVolumeResponse.Builder, DeleteVolumeResponse> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(DeleteVolumeResponse::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(DeleteVolumeResponse::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<DeleteVolumeOntapResponse> ONTAP_RESPONSE_FIELD = SdkField
            .<DeleteVolumeOntapResponse> builder(MarshallingType.SDK_POJO).memberName("OntapResponse")
            .getter(getter(DeleteVolumeResponse::ontapResponse)).setter(setter(Builder::ontapResponse))
            .constructor(DeleteVolumeOntapResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            LIFECYCLE_FIELD, ONTAP_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String volumeId;

    private final String lifecycle;

    private final DeleteVolumeOntapResponse ontapResponse;

    private DeleteVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
        this.lifecycle = builder.lifecycle;
        this.ontapResponse = builder.ontapResponse;
    }

    /**
     * <p>
     * The ID of the volume that's being deleted.
     * </p>
     * 
     * @return The ID of the volume that's being deleted.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this
     * value is <code>DELETING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is
     *         successful, this value is <code>DELETING</code>.
     * @see VolumeLifecycle
     */
    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this
     * value is <code>DELETING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is
     *         successful, this value is <code>DELETING</code>.
     * @see VolumeLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * <p>
     * Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.
     * </p>
     * 
     * @return Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.
     */
    public final DeleteVolumeOntapResponse ontapResponse() {
        return ontapResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ontapResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVolumeResponse)) {
            return false;
        }
        DeleteVolumeResponse other = (DeleteVolumeResponse) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(ontapResponse(), other.ontapResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVolumeResponse").add("VolumeId", volumeId()).add("Lifecycle", lifecycleAsString())
                .add("OntapResponse", ontapResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "OntapResponse":
            return Optional.ofNullable(clazz.cast(ontapResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("OntapResponse", ONTAP_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVolumeResponse, T> g) {
        return obj -> g.apply((DeleteVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVolumeResponse> {
        /**
         * <p>
         * The ID of the volume that's being deleted.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that's being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful,
         * this value is <code>DELETING</code>.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is
         *        successful, this value is <code>DELETING</code>.
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful,
         * this value is <code>DELETING</code>.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is
         *        successful, this value is <code>DELETING</code>.
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(VolumeLifecycle lifecycle);

        /**
         * <p>
         * Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.
         * </p>
         * 
         * @param ontapResponse
         *        Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ontapResponse(DeleteVolumeOntapResponse ontapResponse);

        /**
         * <p>
         * Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteVolumeOntapResponse.Builder}
         * avoiding the need to create one manually via {@link DeleteVolumeOntapResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteVolumeOntapResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #ontapResponse(DeleteVolumeOntapResponse)}.
         * 
         * @param ontapResponse
         *        a consumer that will call methods on {@link DeleteVolumeOntapResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ontapResponse(DeleteVolumeOntapResponse)
         */
        default Builder ontapResponse(Consumer<DeleteVolumeOntapResponse.Builder> ontapResponse) {
            return ontapResponse(DeleteVolumeOntapResponse.builder().applyMutation(ontapResponse).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String volumeId;

        private String lifecycle;

        private DeleteVolumeOntapResponse ontapResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVolumeResponse model) {
            super(model);
            volumeId(model.volumeId);
            lifecycle(model.lifecycle);
            ontapResponse(model.ontapResponse);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final DeleteVolumeOntapResponse.Builder getOntapResponse() {
            return ontapResponse != null ? ontapResponse.toBuilder() : null;
        }

        public final void setOntapResponse(DeleteVolumeOntapResponse.BuilderImpl ontapResponse) {
            this.ontapResponse = ontapResponse != null ? ontapResponse.build() : null;
        }

        @Override
        public final Builder ontapResponse(DeleteVolumeOntapResponse ontapResponse) {
            this.ontapResponse = ontapResponse;
            return this;
        }

        @Override
        public DeleteVolumeResponse build() {
            return new DeleteVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
