/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStorageVirtualMachineResponse extends FSxResponse implements
        ToCopyableBuilder<CreateStorageVirtualMachineResponse.Builder, CreateStorageVirtualMachineResponse> {
    private static final SdkField<StorageVirtualMachine> STORAGE_VIRTUAL_MACHINE_FIELD = SdkField
            .<StorageVirtualMachine> builder(MarshallingType.SDK_POJO).memberName("StorageVirtualMachine")
            .getter(getter(CreateStorageVirtualMachineResponse::storageVirtualMachine))
            .setter(setter(Builder::storageVirtualMachine)).constructor(StorageVirtualMachine::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachine").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STORAGE_VIRTUAL_MACHINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StorageVirtualMachine storageVirtualMachine;

    private CreateStorageVirtualMachineResponse(BuilderImpl builder) {
        super(builder);
        this.storageVirtualMachine = builder.storageVirtualMachine;
    }

    /**
     * <p>
     * Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.
     * </p>
     * 
     * @return Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just
     *         created.
     */
    public final StorageVirtualMachine storageVirtualMachine() {
        return storageVirtualMachine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachine());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageVirtualMachineResponse)) {
            return false;
        }
        CreateStorageVirtualMachineResponse other = (CreateStorageVirtualMachineResponse) obj;
        return Objects.equals(storageVirtualMachine(), other.storageVirtualMachine());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStorageVirtualMachineResponse").add("StorageVirtualMachine", storageVirtualMachine())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageVirtualMachine":
            return Optional.ofNullable(clazz.cast(storageVirtualMachine()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageVirtualMachine", STORAGE_VIRTUAL_MACHINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStorageVirtualMachineResponse, T> g) {
        return obj -> g.apply((CreateStorageVirtualMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStorageVirtualMachineResponse> {
        /**
         * <p>
         * Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just
         * created.
         * </p>
         * 
         * @param storageVirtualMachine
         *        Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachine(StorageVirtualMachine storageVirtualMachine);

        /**
         * <p>
         * Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just
         * created.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageVirtualMachine.Builder} avoiding
         * the need to create one manually via {@link StorageVirtualMachine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageVirtualMachine.Builder#build()} is called immediately and
         * its result is passed to {@link #storageVirtualMachine(StorageVirtualMachine)}.
         * 
         * @param storageVirtualMachine
         *        a consumer that will call methods on {@link StorageVirtualMachine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageVirtualMachine(StorageVirtualMachine)
         */
        default Builder storageVirtualMachine(Consumer<StorageVirtualMachine.Builder> storageVirtualMachine) {
            return storageVirtualMachine(StorageVirtualMachine.builder().applyMutation(storageVirtualMachine).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private StorageVirtualMachine storageVirtualMachine;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorageVirtualMachineResponse model) {
            super(model);
            storageVirtualMachine(model.storageVirtualMachine);
        }

        public final StorageVirtualMachine.Builder getStorageVirtualMachine() {
            return storageVirtualMachine != null ? storageVirtualMachine.toBuilder() : null;
        }

        public final void setStorageVirtualMachine(StorageVirtualMachine.BuilderImpl storageVirtualMachine) {
            this.storageVirtualMachine = storageVirtualMachine != null ? storageVirtualMachine.build() : null;
        }

        @Override
        public final Builder storageVirtualMachine(StorageVirtualMachine storageVirtualMachine) {
            this.storageVirtualMachine = storageVirtualMachine;
            return this;
        }

        @Override
        public CreateStorageVirtualMachineResponse build() {
            return new CreateStorageVirtualMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
