/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAndAttachS3AccessPointRequest extends FSxRequest implements
        ToCopyableBuilder<CreateAndAttachS3AccessPointRequest.Builder, CreateAndAttachS3AccessPointRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateAndAttachS3AccessPointRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAndAttachS3AccessPointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateAndAttachS3AccessPointRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<CreateAndAttachS3AccessPointOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<CreateAndAttachS3AccessPointOpenZFSConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("OpenZFSConfiguration").getter(getter(CreateAndAttachS3AccessPointRequest::openZFSConfiguration))
            .setter(setter(Builder::openZFSConfiguration)).constructor(CreateAndAttachS3AccessPointOpenZFSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final SdkField<CreateAndAttachS3AccessPointOntapConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField
            .<CreateAndAttachS3AccessPointOntapConfiguration> builder(MarshallingType.SDK_POJO).memberName("OntapConfiguration")
            .getter(getter(CreateAndAttachS3AccessPointRequest::ontapConfiguration)).setter(setter(Builder::ontapConfiguration))
            .constructor(CreateAndAttachS3AccessPointOntapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build())
            .build();

    private static final SdkField<CreateAndAttachS3AccessPointS3Configuration> S3_ACCESS_POINT_FIELD = SdkField
            .<CreateAndAttachS3AccessPointS3Configuration> builder(MarshallingType.SDK_POJO).memberName("S3AccessPoint")
            .getter(getter(CreateAndAttachS3AccessPointRequest::s3AccessPoint)).setter(setter(Builder::s3AccessPoint))
            .constructor(CreateAndAttachS3AccessPointS3Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            NAME_FIELD, TYPE_FIELD, OPEN_ZFS_CONFIGURATION_FIELD, ONTAP_CONFIGURATION_FIELD, S3_ACCESS_POINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String name;

    private final String type;

    private final CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration;

    private final CreateAndAttachS3AccessPointOntapConfiguration ontapConfiguration;

    private final CreateAndAttachS3AccessPointS3Configuration s3AccessPoint;

    private CreateAndAttachS3AccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.type = builder.type;
        this.openZFSConfiguration = builder.openZFSConfiguration;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.s3AccessPoint = builder.s3AccessPoint;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The name you want to assign to this S3 access point.
     * </p>
     * 
     * @return The name you want to assign to this S3 access point.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link S3AccessPointAttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
     * @see S3AccessPointAttachmentType
     */
    public final S3AccessPointAttachmentType type() {
        return S3AccessPointAttachmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link S3AccessPointAttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
     * @see S3AccessPointAttachmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS volume.
     * </p>
     * 
     * @return Specifies the configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS
     *         volume.
     */
    public final CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    /**
     * Returns the value of the OntapConfiguration property for this object.
     * 
     * @return The value of the OntapConfiguration property for this object.
     */
    public final CreateAndAttachS3AccessPointOntapConfiguration ontapConfiguration() {
        return ontapConfiguration;
    }

    /**
     * <p>
     * Specifies the virtual private cloud (VPC) configuration if you're creating an access point that is restricted to
     * a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/access-points-vpc.html">Creating access points
     * restricted to a virtual private cloud</a>.
     * </p>
     * 
     * @return Specifies the virtual private cloud (VPC) configuration if you're creating an access point that is
     *         restricted to a VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/access-points-vpc.html">Creating access points
     *         restricted to a virtual private cloud</a>.
     */
    public final CreateAndAttachS3AccessPointS3Configuration s3AccessPoint() {
        return s3AccessPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAndAttachS3AccessPointRequest)) {
            return false;
        }
        CreateAndAttachS3AccessPointRequest other = (CreateAndAttachS3AccessPointRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration())
                && Objects.equals(ontapConfiguration(), other.ontapConfiguration())
                && Objects.equals(s3AccessPoint(), other.s3AccessPoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAndAttachS3AccessPointRequest").add("ClientRequestToken", clientRequestToken())
                .add("Name", name()).add("Type", typeAsString()).add("OpenZFSConfiguration", openZFSConfiguration())
                .add("OntapConfiguration", ontapConfiguration()).add("S3AccessPoint", s3AccessPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        case "OntapConfiguration":
            return Optional.ofNullable(clazz.cast(ontapConfiguration()));
        case "S3AccessPoint":
            return Optional.ofNullable(clazz.cast(s3AccessPoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        map.put("OntapConfiguration", ONTAP_CONFIGURATION_FIELD);
        map.put("S3AccessPoint", S3_ACCESS_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAndAttachS3AccessPointRequest, T> g) {
        return obj -> g.apply((CreateAndAttachS3AccessPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAndAttachS3AccessPointRequest> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The name you want to assign to this S3 access point.
         * </p>
         * 
         * @param name
         *        The name you want to assign to this S3 access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
         * </p>
         * 
         * @param type
         *        The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
         * @see S3AccessPointAttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AccessPointAttachmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
         * </p>
         * 
         * @param type
         *        The type of S3 access point you want to create. Only <code>OpenZFS</code> is supported.
         * @see S3AccessPointAttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AccessPointAttachmentType
         */
        Builder type(S3AccessPointAttachmentType type);

        /**
         * <p>
         * Specifies the configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS
         * volume.
         * </p>
         * 
         * @param openZFSConfiguration
         *        Specifies the configuration to use when creating and attaching an S3 access point to an FSx for
         *        OpenZFS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration);

        /**
         * <p>
         * Specifies the configuration to use when creating and attaching an S3 access point to an FSx for OpenZFS
         * volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateAndAttachS3AccessPointOpenZFSConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration)
         */
        default Builder openZFSConfiguration(
                Consumer<CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration.builder()
                    .applyMutation(openZFSConfiguration).build());
        }

        /**
         * Sets the value of the OntapConfiguration property for this object.
         *
         * @param ontapConfiguration
         *        The new value for the OntapConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ontapConfiguration(CreateAndAttachS3AccessPointOntapConfiguration ontapConfiguration);

        /**
         * Sets the value of the OntapConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CreateAndAttachS3AccessPointOntapConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateAndAttachS3AccessPointOntapConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateAndAttachS3AccessPointOntapConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #ontapConfiguration(CreateAndAttachS3AccessPointOntapConfiguration)}.
         * 
         * @param ontapConfiguration
         *        a consumer that will call methods on {@link CreateAndAttachS3AccessPointOntapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ontapConfiguration(CreateAndAttachS3AccessPointOntapConfiguration)
         */
        default Builder ontapConfiguration(Consumer<CreateAndAttachS3AccessPointOntapConfiguration.Builder> ontapConfiguration) {
            return ontapConfiguration(CreateAndAttachS3AccessPointOntapConfiguration.builder().applyMutation(ontapConfiguration)
                    .build());
        }

        /**
         * <p>
         * Specifies the virtual private cloud (VPC) configuration if you're creating an access point that is restricted
         * to a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/access-points-vpc.html">Creating access points
         * restricted to a virtual private cloud</a>.
         * </p>
         * 
         * @param s3AccessPoint
         *        Specifies the virtual private cloud (VPC) configuration if you're creating an access point that is
         *        restricted to a VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/access-points-vpc.html">Creating access
         *        points restricted to a virtual private cloud</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration s3AccessPoint);

        /**
         * <p>
         * Specifies the virtual private cloud (VPC) configuration if you're creating an access point that is restricted
         * to a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/access-points-vpc.html">Creating access points
         * restricted to a virtual private cloud</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateAndAttachS3AccessPointS3Configuration.Builder} avoiding the need to create one manually via
         * {@link CreateAndAttachS3AccessPointS3Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateAndAttachS3AccessPointS3Configuration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration)}.
         * 
         * @param s3AccessPoint
         *        a consumer that will call methods on {@link CreateAndAttachS3AccessPointS3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration)
         */
        default Builder s3AccessPoint(Consumer<CreateAndAttachS3AccessPointS3Configuration.Builder> s3AccessPoint) {
            return s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration.builder().applyMutation(s3AccessPoint).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String name;

        private String type;

        private CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration;

        private CreateAndAttachS3AccessPointOntapConfiguration ontapConfiguration;

        private CreateAndAttachS3AccessPointS3Configuration s3AccessPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAndAttachS3AccessPointRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            name(model.name);
            type(model.type);
            openZFSConfiguration(model.openZFSConfiguration);
            ontapConfiguration(model.ontapConfiguration);
            s3AccessPoint(model.s3AccessPoint);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(S3AccessPointAttachmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CreateAndAttachS3AccessPointOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(
                CreateAndAttachS3AccessPointOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(CreateAndAttachS3AccessPointOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public final CreateAndAttachS3AccessPointOntapConfiguration.Builder getOntapConfiguration() {
            return ontapConfiguration != null ? ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(CreateAndAttachS3AccessPointOntapConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(CreateAndAttachS3AccessPointOntapConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final CreateAndAttachS3AccessPointS3Configuration.Builder getS3AccessPoint() {
            return s3AccessPoint != null ? s3AccessPoint.toBuilder() : null;
        }

        public final void setS3AccessPoint(CreateAndAttachS3AccessPointS3Configuration.BuilderImpl s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint != null ? s3AccessPoint.build() : null;
        }

        @Override
        public final Builder s3AccessPoint(CreateAndAttachS3AccessPointS3Configuration s3AccessPoint) {
            this.s3AccessPoint = s3AccessPoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAndAttachS3AccessPointRequest build() {
            return new CreateAndAttachS3AccessPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
