/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySnapshotAndUpdateVolumeRequest extends FSxRequest implements
        ToCopyableBuilder<CopySnapshotAndUpdateVolumeRequest.Builder, CopySnapshotAndUpdateVolumeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CopySnapshotAndUpdateVolumeRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(CopySnapshotAndUpdateVolumeRequest::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> SOURCE_SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceSnapshotARN").getter(getter(CopySnapshotAndUpdateVolumeRequest::sourceSnapshotARN))
            .setter(setter(Builder::sourceSnapshotARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotARN").build()).build();

    private static final SdkField<String> COPY_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyStrategy").getter(getter(CopySnapshotAndUpdateVolumeRequest::copyStrategyAsString))
            .setter(setter(Builder::copyStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStrategy").build()).build();

    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(CopySnapshotAndUpdateVolumeRequest::optionsAsStrings))
            .setter(setter(Builder::optionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            VOLUME_ID_FIELD, SOURCE_SNAPSHOT_ARN_FIELD, COPY_STRATEGY_FIELD, OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String volumeId;

    private final String sourceSnapshotARN;

    private final String copyStrategy;

    private final List<String> options;

    private CopySnapshotAndUpdateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.sourceSnapshotARN = builder.sourceSnapshotARN;
        this.copyStrategy = builder.copyStrategy;
        this.options = builder.options;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Specifies the ID of the volume that you are copying the snapshot to.
     * </p>
     * 
     * @return Specifies the ID of the volume that you are copying the snapshot to.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * Returns the value of the SourceSnapshotARN property for this object.
     * 
     * @return The value of the SourceSnapshotARN property for this object.
     */
    public final String sourceSnapshotARN() {
        return sourceSnapshotARN;
    }

    /**
     * <p>
     * Specifies the strategy to use when copying data from a snapshot to the volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous replication.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code> operation.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyStrategy} will
     * return {@link OpenZFSCopyStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #copyStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use when copying data from a snapshot to the volume. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous
     *         replication.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code>
     *         operation.
     *         </p>
     * @see OpenZFSCopyStrategy
     */
    public final OpenZFSCopyStrategy copyStrategy() {
        return OpenZFSCopyStrategy.fromValue(copyStrategy);
    }

    /**
     * <p>
     * Specifies the strategy to use when copying data from a snapshot to the volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous replication.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code> operation.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyStrategy} will
     * return {@link OpenZFSCopyStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #copyStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use when copying data from a snapshot to the volume. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous
     *         replication.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code>
     *         operation.
     *         </p>
     * @see OpenZFSCopyStrategy
     */
    public final String copyStrategyAsString() {
        return copyStrategy;
    }

    /**
     * <p>
     * Confirms that you want to delete data on the destination volume that wasn’t there during the previous snapshot
     * replication.
     * </p>
     * <p>
     * Your replication will fail if you don’t include an option for a specific type of data and that data is on your
     * destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there are
     * intermediate snapshots on the destination, you can’t copy the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on the
     * source volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the source
     * volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match the
     * source snapshot that you’re copying.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Confirms that you want to delete data on the destination volume that wasn’t there during the previous
     *         snapshot replication.</p>
     *         <p>
     *         Your replication will fail if you don’t include an option for a specific type of data and that data is on
     *         your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there
     *         are intermediate snapshots on the destination, you can’t copy the snapshot.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on
     *         the source volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the
     *         source volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match
     *         the source snapshot that you’re copying.
     *         </p>
     *         </li>
     */
    public final List<UpdateOpenZFSVolumeOption> options() {
        return UpdateOpenZFSVolumeOptionsCopier.copyStringToEnum(options);
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Confirms that you want to delete data on the destination volume that wasn’t there during the previous snapshot
     * replication.
     * </p>
     * <p>
     * Your replication will fail if you don’t include an option for a specific type of data and that data is on your
     * destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there are
     * intermediate snapshots on the destination, you can’t copy the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on the
     * source volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the source
     * volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match the
     * source snapshot that you’re copying.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Confirms that you want to delete data on the destination volume that wasn’t there during the previous
     *         snapshot replication.</p>
     *         <p>
     *         Your replication will fail if you don’t include an option for a specific type of data and that data is on
     *         your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there
     *         are intermediate snapshots on the destination, you can’t copy the snapshot.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on
     *         the source volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the
     *         source volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match
     *         the source snapshot that you’re copying.
     *         </p>
     *         </li>
     */
    public final List<String> optionsAsStrings() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotARN());
        hashCode = 31 * hashCode + Objects.hashCode(copyStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? optionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotAndUpdateVolumeRequest)) {
            return false;
        }
        CopySnapshotAndUpdateVolumeRequest other = (CopySnapshotAndUpdateVolumeRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(sourceSnapshotARN(), other.sourceSnapshotARN())
                && Objects.equals(copyStrategyAsString(), other.copyStrategyAsString()) && hasOptions() == other.hasOptions()
                && Objects.equals(optionsAsStrings(), other.optionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopySnapshotAndUpdateVolumeRequest").add("ClientRequestToken", clientRequestToken())
                .add("VolumeId", volumeId()).add("SourceSnapshotARN", sourceSnapshotARN())
                .add("CopyStrategy", copyStrategyAsString()).add("Options", hasOptions() ? optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "SourceSnapshotARN":
            return Optional.ofNullable(clazz.cast(sourceSnapshotARN()));
        case "CopyStrategy":
            return Optional.ofNullable(clazz.cast(copyStrategyAsString()));
        case "Options":
            return Optional.ofNullable(clazz.cast(optionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("SourceSnapshotARN", SOURCE_SNAPSHOT_ARN_FIELD);
        map.put("CopyStrategy", COPY_STRATEGY_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotAndUpdateVolumeRequest, T> g) {
        return obj -> g.apply((CopySnapshotAndUpdateVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopySnapshotAndUpdateVolumeRequest> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Specifies the ID of the volume that you are copying the snapshot to.
         * </p>
         * 
         * @param volumeId
         *        Specifies the ID of the volume that you are copying the snapshot to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * Sets the value of the SourceSnapshotARN property for this object.
         *
         * @param sourceSnapshotARN
         *        The new value for the SourceSnapshotARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotARN(String sourceSnapshotARN);

        /**
         * <p>
         * Specifies the strategy to use when copying data from a snapshot to the volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous replication.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code>
         * operation.
         * </p>
         * </note>
         * 
         * @param copyStrategy
         *        Specifies the strategy to use when copying data from a snapshot to the volume. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous
         *        replication.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code>
         *        operation.
         *        </p>
         * @see OpenZFSCopyStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSCopyStrategy
         */
        Builder copyStrategy(String copyStrategy);

        /**
         * <p>
         * Specifies the strategy to use when copying data from a snapshot to the volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous replication.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code>
         * operation.
         * </p>
         * </note>
         * 
         * @param copyStrategy
         *        Specifies the strategy to use when copying data from a snapshot to the volume. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_COPY</code> - Copies all data from the snapshot to the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCREMENTAL_COPY</code> - Copies only the snapshot data that's changed since the previous
         *        replication.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        <code>CLONE</code> isn't a valid copy strategy option for the <code>CopySnapshotAndUpdateVolume</code>
         *        operation.
         *        </p>
         * @see OpenZFSCopyStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSCopyStrategy
         */
        Builder copyStrategy(OpenZFSCopyStrategy copyStrategy);

        /**
         * <p>
         * Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         * snapshot replication.
         * </p>
         * <p>
         * Your replication will fail if you don’t include an option for a specific type of data and that data is on
         * your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there are
         * intermediate snapshots on the destination, you can’t copy the snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match the
         * source snapshot that you’re copying.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         *        snapshot replication.</p>
         *        <p>
         *        Your replication will fail if you don’t include an option for a specific type of data and that data is
         *        on your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and
         *        there are intermediate snapshots on the destination, you can’t copy the snapshot.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t
         *        on the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on
         *        the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t
         *        match the source snapshot that you’re copying.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(Collection<String> options);

        /**
         * <p>
         * Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         * snapshot replication.
         * </p>
         * <p>
         * Your replication will fail if you don’t include an option for a specific type of data and that data is on
         * your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there are
         * intermediate snapshots on the destination, you can’t copy the snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match the
         * source snapshot that you’re copying.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         *        snapshot replication.</p>
         *        <p>
         *        Your replication will fail if you don’t include an option for a specific type of data and that data is
         *        on your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and
         *        there are intermediate snapshots on the destination, you can’t copy the snapshot.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t
         *        on the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on
         *        the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t
         *        match the source snapshot that you’re copying.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(String... options);

        /**
         * <p>
         * Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         * snapshot replication.
         * </p>
         * <p>
         * Your replication will fail if you don’t include an option for a specific type of data and that data is on
         * your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there are
         * intermediate snapshots on the destination, you can’t copy the snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match the
         * source snapshot that you’re copying.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         *        snapshot replication.</p>
         *        <p>
         *        Your replication will fail if you don’t include an option for a specific type of data and that data is
         *        on your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and
         *        there are intermediate snapshots on the destination, you can’t copy the snapshot.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t
         *        on the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on
         *        the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t
         *        match the source snapshot that you’re copying.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<UpdateOpenZFSVolumeOption> options);

        /**
         * <p>
         * Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         * snapshot replication.
         * </p>
         * <p>
         * Your replication will fail if you don’t include an option for a specific type of data and that data is on
         * your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and there are
         * intermediate snapshots on the destination, you can’t copy the snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on the
         * source volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t match the
         * source snapshot that you’re copying.
         * </p>
         * </li>
         * </ul>
         * 
         * @param options
         *        Confirms that you want to delete data on the destination volume that wasn’t there during the previous
         *        snapshot replication.</p>
         *        <p>
         *        Your replication will fail if you don’t include an option for a specific type of data and that data is
         *        on your destination. For example, if you don’t include <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> and
         *        there are intermediate snapshots on the destination, you can’t copy the snapshot.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots on the destination volume that aren’t
         *        on the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_CLONED_VOLUMES</code> - Deletes snapshot clones on the destination volume that aren't on
         *        the source volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_INTERMEDIATE_DATA</code> - Overwrites snapshots on the destination volume that don’t
         *        match the source snapshot that you’re copying.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(UpdateOpenZFSVolumeOption... options);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String volumeId;

        private String sourceSnapshotARN;

        private String copyStrategy;

        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotAndUpdateVolumeRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            volumeId(model.volumeId);
            sourceSnapshotARN(model.sourceSnapshotARN);
            copyStrategy(model.copyStrategy);
            optionsWithStrings(model.options);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getSourceSnapshotARN() {
            return sourceSnapshotARN;
        }

        public final void setSourceSnapshotARN(String sourceSnapshotARN) {
            this.sourceSnapshotARN = sourceSnapshotARN;
        }

        @Override
        public final Builder sourceSnapshotARN(String sourceSnapshotARN) {
            this.sourceSnapshotARN = sourceSnapshotARN;
            return this;
        }

        public final String getCopyStrategy() {
            return copyStrategy;
        }

        public final void setCopyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
        }

        @Override
        public final Builder copyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
            return this;
        }

        @Override
        public final Builder copyStrategy(OpenZFSCopyStrategy copyStrategy) {
            this.copyStrategy(copyStrategy == null ? null : copyStrategy.toString());
            return this;
        }

        public final Collection<String> getOptions() {
            if (options instanceof SdkAutoConstructList) {
                return null;
            }
            return options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = UpdateOpenZFSVolumeOptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = UpdateOpenZFSVolumeOptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String... options) {
            optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<UpdateOpenZFSVolumeOption> options) {
            this.options = UpdateOpenZFSVolumeOptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(UpdateOpenZFSVolumeOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotAndUpdateVolumeRequest build() {
            return new CopySnapshotAndUpdateVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
