/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.FSxServiceClientConfiguration;
import software.amazon.awssdk.services.fsx.internal.FSxServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.fsx.model.AccessPointAlreadyOwnedByYouException;
import software.amazon.awssdk.services.fsx.model.ActiveDirectoryErrorException;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.BackupBeingCopiedException;
import software.amazon.awssdk.services.fsx.model.BackupInProgressException;
import software.amazon.awssdk.services.fsx.model.BackupNotFoundException;
import software.amazon.awssdk.services.fsx.model.BackupRestoringException;
import software.amazon.awssdk.services.fsx.model.BadRequestException;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CopyBackupRequest;
import software.amazon.awssdk.services.fsx.model.CopyBackupResponse;
import software.amazon.awssdk.services.fsx.model.CopySnapshotAndUpdateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.CopySnapshotAndUpdateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.CreateAndAttachS3AccessPointRequest;
import software.amazon.awssdk.services.fsx.model.CreateAndAttachS3AccessPointResponse;
import software.amazon.awssdk.services.fsx.model.CreateBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.CreateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociationNotFoundException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskEndedException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskExecutingException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskNotFoundException;
import software.amazon.awssdk.services.fsx.model.DeleteBackupRequest;
import software.amazon.awssdk.services.fsx.model.DeleteBackupResponse;
import software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest;
import software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeS3AccessPointAttachmentsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeSharedVpcConfigurationRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSharedVpcConfigurationResponse;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.fsx.model.DetachAndDeleteS3AccessPointRequest;
import software.amazon.awssdk.services.fsx.model.DetachAndDeleteS3AccessPointResponse;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.FSxException;
import software.amazon.awssdk.services.fsx.model.FileCacheNotFoundException;
import software.amazon.awssdk.services.fsx.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.fsx.model.IncompatibleParameterErrorException;
import software.amazon.awssdk.services.fsx.model.IncompatibleRegionForMultiAzException;
import software.amazon.awssdk.services.fsx.model.InternalServerErrorException;
import software.amazon.awssdk.services.fsx.model.InvalidAccessPointException;
import software.amazon.awssdk.services.fsx.model.InvalidDataRepositoryTypeException;
import software.amazon.awssdk.services.fsx.model.InvalidDestinationKmsKeyException;
import software.amazon.awssdk.services.fsx.model.InvalidExportPathException;
import software.amazon.awssdk.services.fsx.model.InvalidImportPathException;
import software.amazon.awssdk.services.fsx.model.InvalidNetworkSettingsException;
import software.amazon.awssdk.services.fsx.model.InvalidPerUnitStorageThroughputException;
import software.amazon.awssdk.services.fsx.model.InvalidRegionException;
import software.amazon.awssdk.services.fsx.model.InvalidRequestException;
import software.amazon.awssdk.services.fsx.model.InvalidSourceKmsKeyException;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fsx.model.MissingFileCacheConfigurationException;
import software.amazon.awssdk.services.fsx.model.MissingFileSystemConfigurationException;
import software.amazon.awssdk.services.fsx.model.MissingVolumeConfigurationException;
import software.amazon.awssdk.services.fsx.model.NotServiceResourceErrorException;
import software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest;
import software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse;
import software.amazon.awssdk.services.fsx.model.ResourceDoesNotSupportTaggingException;
import software.amazon.awssdk.services.fsx.model.ResourceNotFoundException;
import software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachmentNotFoundException;
import software.amazon.awssdk.services.fsx.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.fsx.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.fsx.model.SourceBackupUnavailableException;
import software.amazon.awssdk.services.fsx.model.StartMisconfiguredStateRecoveryRequest;
import software.amazon.awssdk.services.fsx.model.StartMisconfiguredStateRecoveryResponse;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineNotFoundException;
import software.amazon.awssdk.services.fsx.model.TagResourceRequest;
import software.amazon.awssdk.services.fsx.model.TagResourceResponse;
import software.amazon.awssdk.services.fsx.model.TooManyAccessPointsException;
import software.amazon.awssdk.services.fsx.model.UnsupportedOperationException;
import software.amazon.awssdk.services.fsx.model.UntagResourceRequest;
import software.amazon.awssdk.services.fsx.model.UntagResourceResponse;
import software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.UpdateSharedVpcConfigurationRequest;
import software.amazon.awssdk.services.fsx.model.UpdateSharedVpcConfigurationResponse;
import software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.VolumeNotFoundException;
import software.amazon.awssdk.services.fsx.transform.AssociateFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CancelDataRepositoryTaskRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CopyBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CopySnapshotAndUpdateVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateAndAttachS3AccessPointRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateDataRepositoryTaskRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileCacheRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileSystemFromBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateVolumeFromBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteFileCacheRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeDataRepositoryAssociationsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeDataRepositoryTasksRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileCachesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileSystemsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeS3AccessPointAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeSharedVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeStorageVirtualMachinesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DetachAndDeleteS3AccessPointRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DisassociateFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.ReleaseFileSystemNfsV3LocksRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.RestoreVolumeFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.StartMisconfiguredStateRecoveryRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateFileCacheRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateSharedVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateVolumeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultFSxAsyncClient
implements FSxAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultFSxAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFSxAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"FSx#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateFileSystemAliasesResponse> associateFileSystemAliases(AssociateFileSystemAliasesRequest associateFileSystemAliasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateFileSystemAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, associateFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFileSystemAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFileSystemAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFileSystemAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateFileSystemAliasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$associateFileSystemAliases$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$associateFileSystemAliases$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelDataRepositoryTaskResponse> cancelDataRepositoryTask(CancelDataRepositoryTaskRequest cancelDataRepositoryTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelDataRepositoryTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, cancelDataRepositoryTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDataRepositoryTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDataRepositoryTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDataRepositoryTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelDataRepositoryTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelDataRepositoryTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$cancelDataRepositoryTask$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$cancelDataRepositoryTask$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyBackupResponse> copyBackup(CopyBackupRequest copyBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copyBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, copyBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CopyBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copyBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$copyBackup$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$copyBackup$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopySnapshotAndUpdateVolumeResponse> copySnapshotAndUpdateVolume(CopySnapshotAndUpdateVolumeRequest copySnapshotAndUpdateVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copySnapshotAndUpdateVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, copySnapshotAndUpdateVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshotAndUpdateVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotAndUpdateVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshotAndUpdateVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CopySnapshotAndUpdateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copySnapshotAndUpdateVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$copySnapshotAndUpdateVolume$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$copySnapshotAndUpdateVolume$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAndAttachS3AccessPointResponse> createAndAttachS3AccessPoint(CreateAndAttachS3AccessPointRequest createAndAttachS3AccessPointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAndAttachS3AccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createAndAttachS3AccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAndAttachS3AccessPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAndAttachS3AccessPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAndAttachS3AccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAndAttachS3AccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAndAttachS3AccessPointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createAndAttachS3AccessPoint$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createAndAttachS3AccessPoint$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBackupResponse> createBackup(CreateBackupRequest createBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createBackup$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createBackup$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataRepositoryAssociationResponse> createDataRepositoryAssociation(CreateDataRepositoryAssociationRequest createDataRepositoryAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRepositoryAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRepositoryAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRepositoryAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRepositoryAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataRepositoryAssociationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createDataRepositoryAssociation$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createDataRepositoryAssociation$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataRepositoryTaskResponse> createDataRepositoryTask(CreateDataRepositoryTaskRequest createDataRepositoryTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataRepositoryTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createDataRepositoryTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRepositoryTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRepositoryTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRepositoryTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataRepositoryTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataRepositoryTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createDataRepositoryTask$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createDataRepositoryTask$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFileCacheResponse> createFileCache(CreateFileCacheRequest createFileCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createFileCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFileCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFileCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createFileCache$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createFileCache$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFileSystemResponse> createFileSystem(CreateFileSystemRequest createFileSystemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFileSystemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createFileSystem$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createFileSystem$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFileSystemFromBackupResponse> createFileSystemFromBackup(CreateFileSystemFromBackupRequest createFileSystemFromBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileSystemFromBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createFileSystemFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystemFromBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemFromBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystemFromBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFileSystemFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFileSystemFromBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createFileSystemFromBackup$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createFileSystemFromBackup$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createSnapshot$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createSnapshot$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStorageVirtualMachineResponse> createStorageVirtualMachine(CreateStorageVirtualMachineRequest createStorageVirtualMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStorageVirtualMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStorageVirtualMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStorageVirtualMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStorageVirtualMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStorageVirtualMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createStorageVirtualMachine$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createStorageVirtualMachine$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVolumeResponse> createVolume(CreateVolumeRequest createVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createVolume$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createVolume$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVolumeFromBackupResponse> createVolumeFromBackup(CreateVolumeFromBackupRequest createVolumeFromBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVolumeFromBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, createVolumeFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVolumeFromBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVolumeFromBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVolumeFromBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateVolumeFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createVolumeFromBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$createVolumeFromBackup$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$createVolumeFromBackup$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBackupResponse> deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteBackup$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteBackup$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataRepositoryAssociationResponse> deleteDataRepositoryAssociation(DeleteDataRepositoryAssociationRequest deleteDataRepositoryAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataRepositoryAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataRepositoryAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataRepositoryAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataRepositoryAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDataRepositoryAssociationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteDataRepositoryAssociation$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteDataRepositoryAssociation$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFileCacheResponse> deleteFileCache(DeleteFileCacheRequest deleteFileCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFileCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFileCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFileCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteFileCache$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteFileCache$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFileSystemResponse> deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFileSystemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteFileSystem$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteFileSystem$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteSnapshot$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteSnapshot$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStorageVirtualMachineResponse> deleteStorageVirtualMachine(DeleteStorageVirtualMachineRequest deleteStorageVirtualMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStorageVirtualMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageVirtualMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStorageVirtualMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageVirtualMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStorageVirtualMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteStorageVirtualMachine$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteStorageVirtualMachine$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$deleteVolume$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$deleteVolume$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBackupsResponse> describeBackups(DescribeBackupsRequest describeBackupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeBackupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeBackups$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeBackups$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataRepositoryAssociationsResponse> describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsRequest describeDataRepositoryAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataRepositoryAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataRepositoryAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataRepositoryAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataRepositoryAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataRepositoryAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataRepositoryAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataRepositoryAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeDataRepositoryAssociations$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeDataRepositoryAssociations$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataRepositoryTasksResponse> describeDataRepositoryTasks(DescribeDataRepositoryTasksRequest describeDataRepositoryTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataRepositoryTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataRepositoryTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataRepositoryTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataRepositoryTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataRepositoryTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataRepositoryTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataRepositoryTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeDataRepositoryTasks$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeDataRepositoryTasks$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFileCachesResponse> describeFileCaches(DescribeFileCachesRequest describeFileCachesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileCachesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeFileCachesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileCaches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileCachesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileCaches").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFileCachesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFileCachesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeFileCaches$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeFileCaches$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFileSystemAliasesResponse> describeFileSystemAliases(DescribeFileSystemAliasesRequest describeFileSystemAliasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystemAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystemAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFileSystemAliasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeFileSystemAliases$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeFileSystemAliases$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFileSystemsResponse> describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeFileSystemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFileSystemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFileSystemsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeFileSystems$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeFileSystems$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeS3AccessPointAttachmentsResponse> describeS3AccessPointAttachments(DescribeS3AccessPointAttachmentsRequest describeS3AccessPointAttachmentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeS3AccessPointAttachmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeS3AccessPointAttachmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeS3AccessPointAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeS3AccessPointAttachmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeS3AccessPointAttachments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeS3AccessPointAttachmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeS3AccessPointAttachmentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeS3AccessPointAttachments$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeS3AccessPointAttachments$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSharedVpcConfigurationResponse> describeSharedVpcConfiguration(DescribeSharedVpcConfigurationRequest describeSharedVpcConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSharedVpcConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeSharedVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSharedVpcConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSharedVpcConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSharedVpcConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSharedVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSharedVpcConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeSharedVpcConfiguration$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeSharedVpcConfiguration$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeSnapshots$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeSnapshots$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStorageVirtualMachinesResponse> describeStorageVirtualMachines(DescribeStorageVirtualMachinesRequest describeStorageVirtualMachinesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStorageVirtualMachinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeStorageVirtualMachinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStorageVirtualMachines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStorageVirtualMachinesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorageVirtualMachines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStorageVirtualMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStorageVirtualMachinesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeStorageVirtualMachines$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeStorageVirtualMachines$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeVolumesResponse> describeVolumes(DescribeVolumesRequest describeVolumesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVolumesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, describeVolumesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVolumesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVolumes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeVolumesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeVolumesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$describeVolumes$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$describeVolumes$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachAndDeleteS3AccessPointResponse> detachAndDeleteS3AccessPoint(DetachAndDeleteS3AccessPointRequest detachAndDeleteS3AccessPointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachAndDeleteS3AccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, detachAndDeleteS3AccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachAndDeleteS3AccessPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachAndDeleteS3AccessPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachAndDeleteS3AccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachAndDeleteS3AccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachAndDeleteS3AccessPointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$detachAndDeleteS3AccessPoint$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$detachAndDeleteS3AccessPoint$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateFileSystemAliasesResponse> disassociateFileSystemAliases(DisassociateFileSystemAliasesRequest disassociateFileSystemAliasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateFileSystemAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFileSystemAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFileSystemAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFileSystemAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateFileSystemAliasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$disassociateFileSystemAliases$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$disassociateFileSystemAliases$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$listTagsForResource$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$listTagsForResource$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReleaseFileSystemNfsV3LocksResponse> releaseFileSystemNfsV3Locks(ReleaseFileSystemNfsV3LocksRequest releaseFileSystemNfsV3LocksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)releaseFileSystemNfsV3LocksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, releaseFileSystemNfsV3LocksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReleaseFileSystemNfsV3Locks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReleaseFileSystemNfsV3LocksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReleaseFileSystemNfsV3Locks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReleaseFileSystemNfsV3LocksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)releaseFileSystemNfsV3LocksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$releaseFileSystemNfsV3Locks$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$releaseFileSystemNfsV3Locks$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreVolumeFromSnapshotResponse> restoreVolumeFromSnapshot(RestoreVolumeFromSnapshotRequest restoreVolumeFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreVolumeFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, restoreVolumeFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreVolumeFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreVolumeFromSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreVolumeFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreVolumeFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restoreVolumeFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$restoreVolumeFromSnapshot$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$restoreVolumeFromSnapshot$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartMisconfiguredStateRecoveryResponse> startMisconfiguredStateRecovery(StartMisconfiguredStateRecoveryRequest startMisconfiguredStateRecoveryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMisconfiguredStateRecoveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, startMisconfiguredStateRecoveryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMisconfiguredStateRecovery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMisconfiguredStateRecoveryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMisconfiguredStateRecovery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartMisconfiguredStateRecoveryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startMisconfiguredStateRecoveryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$startMisconfiguredStateRecovery$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$startMisconfiguredStateRecovery$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$tagResource$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$tagResource$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$untagResource$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$untagResource$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataRepositoryAssociationResponse> updateDataRepositoryAssociation(UpdateDataRepositoryAssociationRequest updateDataRepositoryAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataRepositoryAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataRepositoryAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRepositoryAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRepositoryAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDataRepositoryAssociationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateDataRepositoryAssociation$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateDataRepositoryAssociation$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFileCacheResponse> updateFileCache(UpdateFileCacheRequest updateFileCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateFileCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFileCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFileCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateFileCache$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateFileCache$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFileSystemResponse> updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFileSystemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateFileSystem$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateFileSystem$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSharedVpcConfigurationResponse> updateSharedVpcConfiguration(UpdateSharedVpcConfigurationRequest updateSharedVpcConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSharedVpcConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateSharedVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSharedVpcConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSharedVpcConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSharedVpcConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSharedVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSharedVpcConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateSharedVpcConfiguration$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateSharedVpcConfiguration$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateSnapshot$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateSnapshot$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStorageVirtualMachineResponse> updateStorageVirtualMachine(UpdateStorageVirtualMachineRequest updateStorageVirtualMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStorageVirtualMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStorageVirtualMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStorageVirtualMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStorageVirtualMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStorageVirtualMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateStorageVirtualMachine$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateStorageVirtualMachine$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateVolumeResponse> updateVolume(UpdateVolumeRequest updateVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultFSxAsyncClient.resolveMetricPublishers(clientConfiguration, updateVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "S3AccessPointAttachmentNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessPointAttachmentNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessPointAttachmentNotFoundException::builder).build());
                    }
                    case "InvalidImportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportPathException::builder).build());
                    }
                    case "InvalidNetworkSettings": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build());
                    }
                    case "InvalidAccessPoint": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAccessPoint").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAccessPointException::builder).build());
                    }
                    case "FileSystemNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                    }
                    case "DataRepositoryAssociationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build());
                    }
                    case "ResourceDoesNotSupportTagging": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build());
                    }
                    case "DataRepositoryTaskNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build());
                    }
                    case "SourceBackupUnavailable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "StorageVirtualMachineNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build());
                    }
                    case "BackupRestoring": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupRestoring").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupRestoringException::builder).build());
                    }
                    case "BackupInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInProgressException::builder).build());
                    }
                    case "InvalidExportPath": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportPath").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportPathException::builder).build());
                    }
                    case "InvalidRegion": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegion").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "MissingVolumeConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build());
                    }
                    case "InvalidSourceKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build());
                    }
                    case "DataRepositoryTaskExecuting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build());
                    }
                    case "IncompatibleRegionForMultiAZ": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build());
                    }
                    case "MissingFileCacheConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileCacheConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileCacheConfigurationException::builder).build());
                    }
                    case "BackupNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "FileCacheNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FileCacheNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FileCacheNotFoundException::builder).build());
                    }
                    case "InvalidDestinationKmsKey": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build());
                    }
                    case "VolumeNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VolumeNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VolumeNotFoundException::builder).build());
                    }
                    case "ServiceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                    }
                    case "NotServiceResourceError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotServiceResourceError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build());
                    }
                    case "AccessPointAlreadyOwnedByYou": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyOwnedByYou").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessPointAlreadyOwnedByYouException::builder).build());
                    }
                    case "MissingFileSystemConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build());
                    }
                    case "BackupBeingCopied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupBeingCopied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupBeingCopiedException::builder).build());
                    }
                    case "IncompatibleParameterError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build());
                    }
                    case "DataRepositoryTaskEnded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build());
                    }
                    case "InvalidDataRepositoryType": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build());
                    }
                    case "SnapshotNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "TooManyAccessPoints": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyAccessPoints").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyAccessPointsException::builder).build());
                    }
                    case "InvalidPerUnitStorageThroughput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build());
                    }
                    case "ActiveDirectoryError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build());
                    }
                    case "BadRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultFSxAsyncClient.lambda$updateVolume$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultFSxAsyncClient.lambda$updateVolume$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final FSxServiceClientConfiguration serviceClientConfiguration() {
        return new FSxServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "fsx";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(FSxException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        FSxServiceClientConfigurationBuilder serviceConfigBuilder = new FSxServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateVolume$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVolume$190(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateStorageVirtualMachine$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStorageVirtualMachine$186(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateStorageVirtualMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSnapshot$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSnapshot$182(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSharedVpcConfiguration$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSharedVpcConfiguration$178(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSharedVpcConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFileSystem$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileSystem$174(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFileSystemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFileCache$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileCache$170(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFileCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDataRepositoryAssociation$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataRepositoryAssociation$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDataRepositoryAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$162(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$158(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startMisconfiguredStateRecovery$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMisconfiguredStateRecovery$154(List metricPublishers, MetricCollector apiCallMetricCollector, StartMisconfiguredStateRecoveryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreVolumeFromSnapshot$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreVolumeFromSnapshot$150(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreVolumeFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$releaseFileSystemNfsV3Locks$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$releaseFileSystemNfsV3Locks$146(List metricPublishers, MetricCollector apiCallMetricCollector, ReleaseFileSystemNfsV3LocksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateFileSystemAliases$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateFileSystemAliases$138(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateFileSystemAliasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachAndDeleteS3AccessPoint$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachAndDeleteS3AccessPoint$134(List metricPublishers, MetricCollector apiCallMetricCollector, DetachAndDeleteS3AccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeVolumes$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVolumes$130(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeVolumesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStorageVirtualMachines$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStorageVirtualMachines$126(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStorageVirtualMachinesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSnapshots$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshots$122(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSharedVpcConfiguration$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSharedVpcConfiguration$118(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSharedVpcConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeS3AccessPointAttachments$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeS3AccessPointAttachments$114(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeS3AccessPointAttachmentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFileSystems$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystems$110(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFileSystemsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFileSystemAliases$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystemAliases$106(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFileSystemAliasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFileCaches$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileCaches$102(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFileCachesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataRepositoryTasks$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataRepositoryTasks$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataRepositoryTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataRepositoryAssociations$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataRepositoryAssociations$94(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataRepositoryAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBackups$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackups$90(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVolume$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVolume$86(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStorageVirtualMachine$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageVirtualMachine$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStorageVirtualMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSnapshot$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$78(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFileSystem$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystem$74(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFileSystemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFileCache$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileCache$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFileCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDataRepositoryAssociation$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataRepositoryAssociation$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDataRepositoryAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBackup$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createVolumeFromBackup$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVolumeFromBackup$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateVolumeFromBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createVolume$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVolume$54(List metricPublishers, MetricCollector apiCallMetricCollector, CreateVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStorageVirtualMachine$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStorageVirtualMachine$50(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStorageVirtualMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSnapshot$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFileSystemFromBackup$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystemFromBackup$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFileSystemFromBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFileSystem$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystem$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFileSystemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFileCache$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileCache$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFileCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataRepositoryTask$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRepositoryTask$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataRepositoryTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataRepositoryAssociation$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRepositoryAssociation$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataRepositoryAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBackup$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAndAttachS3AccessPoint$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAndAttachS3AccessPoint$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAndAttachS3AccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copySnapshotAndUpdateVolume$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshotAndUpdateVolume$14(List metricPublishers, MetricCollector apiCallMetricCollector, CopySnapshotAndUpdateVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copyBackup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyBackup$10(List metricPublishers, MetricCollector apiCallMetricCollector, CopyBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelDataRepositoryTask$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDataRepositoryTask$6(List metricPublishers, MetricCollector apiCallMetricCollector, CancelDataRepositoryTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateFileSystemAliases$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFileSystemAliases$2(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateFileSystemAliasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

