/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDataRepositoryAssociationResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DeleteDataRepositoryAssociationResponse> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(DeleteDataRepositoryAssociationResponse.getter(DeleteDataRepositoryAssociationResponse::associationId)).setter(DeleteDataRepositoryAssociationResponse.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DeleteDataRepositoryAssociationResponse.getter(DeleteDataRepositoryAssociationResponse::lifecycleAsString)).setter(DeleteDataRepositoryAssociationResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<Boolean> DELETE_DATA_IN_FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteDataInFileSystem").getter(DeleteDataRepositoryAssociationResponse.getter(DeleteDataRepositoryAssociationResponse::deleteDataInFileSystem)).setter(DeleteDataRepositoryAssociationResponse.setter(Builder::deleteDataInFileSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDataInFileSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, LIFECYCLE_FIELD, DELETE_DATA_IN_FILE_SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDataRepositoryAssociationResponse.memberNameToFieldInitializer();
    private final String associationId;
    private final String lifecycle;
    private final Boolean deleteDataInFileSystem;

    private DeleteDataRepositoryAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.lifecycle = builder.lifecycle;
        this.deleteDataInFileSystem = builder.deleteDataInFileSystem;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final DataRepositoryLifecycle lifecycle() {
        return DataRepositoryLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final Boolean deleteDataInFileSystem() {
        return this.deleteDataInFileSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDataInFileSystem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataRepositoryAssociationResponse)) {
            return false;
        }
        DeleteDataRepositoryAssociationResponse other = (DeleteDataRepositoryAssociationResponse)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.deleteDataInFileSystem(), other.deleteDataInFileSystem());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDataRepositoryAssociationResponse").add("AssociationId", (Object)this.associationId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("DeleteDataInFileSystem", (Object)this.deleteDataInFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "DeleteDataInFileSystem": {
                return Optional.ofNullable(clazz.cast(this.deleteDataInFileSystem()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("DeleteDataInFileSystem", DELETE_DATA_IN_FILE_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataRepositoryAssociationResponse, T> g) {
        return obj -> g.apply((DeleteDataRepositoryAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String associationId;
        private String lifecycle;
        private Boolean deleteDataInFileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataRepositoryAssociationResponse model) {
            super(model);
            this.associationId(model.associationId);
            this.lifecycle(model.lifecycle);
            this.deleteDataInFileSystem(model.deleteDataInFileSystem);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(DataRepositoryLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final Boolean getDeleteDataInFileSystem() {
            return this.deleteDataInFileSystem;
        }

        public final void setDeleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
        }

        @Override
        public final Builder deleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
            return this;
        }

        @Override
        public DeleteDataRepositoryAssociationResponse build() {
            return new DeleteDataRepositoryAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDataRepositoryAssociationResponse> {
        public Builder associationId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(DataRepositoryLifecycle var1);

        public Builder deleteDataInFileSystem(Boolean var1);
    }
}

