/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DnsIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfManagedActiveDirectoryConfigurationUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfManagedActiveDirectoryConfigurationUpdates> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(SelfManagedActiveDirectoryConfigurationUpdates.getter(SelfManagedActiveDirectoryConfigurationUpdates::userName)).setter(SelfManagedActiveDirectoryConfigurationUpdates.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(SelfManagedActiveDirectoryConfigurationUpdates.getter(SelfManagedActiveDirectoryConfigurationUpdates::password)).setter(SelfManagedActiveDirectoryConfigurationUpdates.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIps").getter(SelfManagedActiveDirectoryConfigurationUpdates.getter(SelfManagedActiveDirectoryConfigurationUpdates::dnsIps)).setter(SelfManagedActiveDirectoryConfigurationUpdates.setter(Builder::dnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(SelfManagedActiveDirectoryConfigurationUpdates.getter(SelfManagedActiveDirectoryConfigurationUpdates::domainName)).setter(SelfManagedActiveDirectoryConfigurationUpdates.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitDistinguishedName").getter(SelfManagedActiveDirectoryConfigurationUpdates.getter(SelfManagedActiveDirectoryConfigurationUpdates::organizationalUnitDistinguishedName)).setter(SelfManagedActiveDirectoryConfigurationUpdates.setter(Builder::organizationalUnitDistinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitDistinguishedName").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAdministratorsGroup").getter(SelfManagedActiveDirectoryConfigurationUpdates.getter(SelfManagedActiveDirectoryConfigurationUpdates::fileSystemAdministratorsGroup)).setter(SelfManagedActiveDirectoryConfigurationUpdates.setter(Builder::fileSystemAdministratorsGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAdministratorsGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, PASSWORD_FIELD, DNS_IPS_FIELD, DOMAIN_NAME_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD, FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SelfManagedActiveDirectoryConfigurationUpdates.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String password;
    private final List<String> dnsIps;
    private final String domainName;
    private final String organizationalUnitDistinguishedName;
    private final String fileSystemAdministratorsGroup;

    private SelfManagedActiveDirectoryConfigurationUpdates(BuilderImpl builder) {
        this.userName = builder.userName;
        this.password = builder.password;
        this.dnsIps = builder.dnsIps;
        this.domainName = builder.domainName;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.fileSystemAdministratorsGroup = builder.fileSystemAdministratorsGroup;
    }

    public final String userName() {
        return this.userName;
    }

    public final String password() {
        return this.password;
    }

    public final boolean hasDnsIps() {
        return this.dnsIps != null && !(this.dnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIps() {
        return this.dnsIps;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String organizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public final String fileSystemAdministratorsGroup() {
        return this.fileSystemAdministratorsGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIps() ? this.dnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAdministratorsGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedActiveDirectoryConfigurationUpdates)) {
            return false;
        }
        SelfManagedActiveDirectoryConfigurationUpdates other = (SelfManagedActiveDirectoryConfigurationUpdates)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.password(), other.password()) && this.hasDnsIps() == other.hasDnsIps() && Objects.equals(this.dnsIps(), other.dnsIps()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName()) && Objects.equals(this.fileSystemAdministratorsGroup(), other.fileSystemAdministratorsGroup());
    }

    public final String toString() {
        return ToString.builder((String)"SelfManagedActiveDirectoryConfigurationUpdates").add("UserName", (Object)this.userName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("DnsIps", this.hasDnsIps() ? this.dnsIps() : null).add("DomainName", (Object)this.domainName()).add("OrganizationalUnitDistinguishedName", (Object)this.organizationalUnitDistinguishedName()).add("FileSystemAdministratorsGroup", (Object)this.fileSystemAdministratorsGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "DnsIps": {
                return Optional.ofNullable(clazz.cast(this.dnsIps()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "OrganizationalUnitDistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedName()));
            }
            case "FileSystemAdministratorsGroup": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAdministratorsGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("DnsIps", DNS_IPS_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("OrganizationalUnitDistinguishedName", ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD);
        map.put("FileSystemAdministratorsGroup", FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedActiveDirectoryConfigurationUpdates, T> g) {
        return obj -> g.apply((SelfManagedActiveDirectoryConfigurationUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String password;
        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();
        private String domainName;
        private String organizationalUnitDistinguishedName;
        private String fileSystemAdministratorsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedActiveDirectoryConfigurationUpdates model) {
            this.userName(model.userName);
            this.password(model.password);
            this.dnsIps(model.dnsIps);
            this.domainName(model.domainName);
            this.organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            this.fileSystemAdministratorsGroup(model.fileSystemAdministratorsGroup);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (this.dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = DnsIpsCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = DnsIpsCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String ... dnsIps) {
            this.dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return this.organizationalUnitDistinguishedName;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final String getFileSystemAdministratorsGroup() {
            return this.fileSystemAdministratorsGroup;
        }

        public final void setFileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
            this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
        }

        @Override
        public final Builder fileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
            this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
            return this;
        }

        public SelfManagedActiveDirectoryConfigurationUpdates build() {
            return new SelfManagedActiveDirectoryConfigurationUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfManagedActiveDirectoryConfigurationUpdates> {
        public Builder userName(String var1);

        public Builder password(String var1);

        public Builder dnsIps(Collection<String> var1);

        public Builder dnsIps(String ... var1);

        public Builder domainName(String var1);

        public Builder organizationalUnitDistinguishedName(String var1);

        public Builder fileSystemAdministratorsGroup(String var1);
    }
}

