/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSCreateRootVolumeConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType;
import software.amazon.awssdk.services.fsx.model.OpenZFSReadCacheConfiguration;
import software.amazon.awssdk.services.fsx.model.RouteTableIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileSystemOpenZFSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFileSystemOpenZFSConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::automaticBackupRetentionDays)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::copyTagsToBackups)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToVolumes").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::copyTagsToVolumes)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::copyTagsToVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToVolumes").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::dailyAutomaticBackupStartTime)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::deploymentTypeAsString)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::throughputCapacity)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::weeklyMaintenanceStartTime)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::diskIopsConfiguration)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build()}).build();
    private static final SdkField<OpenZFSCreateRootVolumeConfiguration> ROOT_VOLUME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootVolumeConfiguration").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::rootVolumeConfiguration)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::rootVolumeConfiguration)).constructor(OpenZFSCreateRootVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeConfiguration").build()}).build();
    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredSubnetId").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::preferredSubnetId)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::preferredSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()}).build();
    private static final SdkField<String> ENDPOINT_IP_ADDRESS_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointIpAddressRange").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::endpointIpAddressRange)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::endpointIpAddressRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpAddressRange").build()}).build();
    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteTableIds").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::routeTableIds)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::routeTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OpenZFSReadCacheConfiguration> READ_CACHE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReadCacheConfiguration").getter(CreateFileSystemOpenZFSConfiguration.getter(CreateFileSystemOpenZFSConfiguration::readCacheConfiguration)).setter(CreateFileSystemOpenZFSConfiguration.setter(Builder::readCacheConfiguration)).constructor(OpenZFSReadCacheConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCacheConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, COPY_TAGS_TO_VOLUMES_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, DEPLOYMENT_TYPE_FIELD, THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, ROOT_VOLUME_CONFIGURATION_FIELD, PREFERRED_SUBNET_ID_FIELD, ENDPOINT_IP_ADDRESS_RANGE_FIELD, ROUTE_TABLE_IDS_FIELD, READ_CACHE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFileSystemOpenZFSConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final Boolean copyTagsToVolumes;
    private final String dailyAutomaticBackupStartTime;
    private final String deploymentType;
    private final Integer throughputCapacity;
    private final String weeklyMaintenanceStartTime;
    private final DiskIopsConfiguration diskIopsConfiguration;
    private final OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration;
    private final String preferredSubnetId;
    private final String endpointIpAddressRange;
    private final List<String> routeTableIds;
    private final OpenZFSReadCacheConfiguration readCacheConfiguration;

    private CreateFileSystemOpenZFSConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.copyTagsToVolumes = builder.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.deploymentType = builder.deploymentType;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.rootVolumeConfiguration = builder.rootVolumeConfiguration;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.endpointIpAddressRange = builder.endpointIpAddressRange;
        this.routeTableIds = builder.routeTableIds;
        this.readCacheConfiguration = builder.readCacheConfiguration;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final Boolean copyTagsToVolumes() {
        return this.copyTagsToVolumes;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final OpenZFSDeploymentType deploymentType() {
        return OpenZFSDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final DiskIopsConfiguration diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public final OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration() {
        return this.rootVolumeConfiguration;
    }

    public final String preferredSubnetId() {
        return this.preferredSubnetId;
    }

    public final String endpointIpAddressRange() {
        return this.endpointIpAddressRange;
    }

    public final boolean hasRouteTableIds() {
        return this.routeTableIds != null && !(this.routeTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public final OpenZFSReadCacheConfiguration readCacheConfiguration() {
        return this.readCacheConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIpAddressRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteTableIds() ? this.routeTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readCacheConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemOpenZFSConfiguration)) {
            return false;
        }
        CreateFileSystemOpenZFSConfiguration other = (CreateFileSystemOpenZFSConfiguration)obj;
        return Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && Objects.equals(this.copyTagsToVolumes(), other.copyTagsToVolumes()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.diskIopsConfiguration(), other.diskIopsConfiguration()) && Objects.equals(this.rootVolumeConfiguration(), other.rootVolumeConfiguration()) && Objects.equals(this.preferredSubnetId(), other.preferredSubnetId()) && Objects.equals(this.endpointIpAddressRange(), other.endpointIpAddressRange()) && this.hasRouteTableIds() == other.hasRouteTableIds() && Objects.equals(this.routeTableIds(), other.routeTableIds()) && Objects.equals(this.readCacheConfiguration(), other.readCacheConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFileSystemOpenZFSConfiguration").add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("CopyTagsToVolumes", (Object)this.copyTagsToVolumes()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DiskIopsConfiguration", (Object)this.diskIopsConfiguration()).add("RootVolumeConfiguration", (Object)this.rootVolumeConfiguration()).add("PreferredSubnetId", (Object)this.preferredSubnetId()).add("EndpointIpAddressRange", (Object)this.endpointIpAddressRange()).add("RouteTableIds", this.hasRouteTableIds() ? this.routeTableIds() : null).add("ReadCacheConfiguration", (Object)this.readCacheConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "CopyTagsToVolumes": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToVolumes()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DiskIopsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.diskIopsConfiguration()));
            }
            case "RootVolumeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeConfiguration()));
            }
            case "PreferredSubnetId": {
                return Optional.ofNullable(clazz.cast(this.preferredSubnetId()));
            }
            case "EndpointIpAddressRange": {
                return Optional.ofNullable(clazz.cast(this.endpointIpAddressRange()));
            }
            case "RouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.routeTableIds()));
            }
            case "ReadCacheConfiguration": {
                return Optional.ofNullable(clazz.cast(this.readCacheConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("CopyTagsToBackups", COPY_TAGS_TO_BACKUPS_FIELD);
        map.put("CopyTagsToVolumes", COPY_TAGS_TO_VOLUMES_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("ThroughputCapacity", THROUGHPUT_CAPACITY_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("DiskIopsConfiguration", DISK_IOPS_CONFIGURATION_FIELD);
        map.put("RootVolumeConfiguration", ROOT_VOLUME_CONFIGURATION_FIELD);
        map.put("PreferredSubnetId", PREFERRED_SUBNET_ID_FIELD);
        map.put("EndpointIpAddressRange", ENDPOINT_IP_ADDRESS_RANGE_FIELD);
        map.put("RouteTableIds", ROUTE_TABLE_IDS_FIELD);
        map.put("ReadCacheConfiguration", READ_CACHE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemOpenZFSConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemOpenZFSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private Boolean copyTagsToVolumes;
        private String dailyAutomaticBackupStartTime;
        private String deploymentType;
        private Integer throughputCapacity;
        private String weeklyMaintenanceStartTime;
        private DiskIopsConfiguration diskIopsConfiguration;
        private OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration;
        private String preferredSubnetId;
        private String endpointIpAddressRange;
        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();
        private OpenZFSReadCacheConfiguration readCacheConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemOpenZFSConfiguration model) {
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.copyTagsToVolumes(model.copyTagsToVolumes);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.deploymentType(model.deploymentType);
            this.throughputCapacity(model.throughputCapacity);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.diskIopsConfiguration(model.diskIopsConfiguration);
            this.rootVolumeConfiguration(model.rootVolumeConfiguration);
            this.preferredSubnetId(model.preferredSubnetId);
            this.endpointIpAddressRange(model.endpointIpAddressRange);
            this.routeTableIds(model.routeTableIds);
            this.readCacheConfiguration(model.readCacheConfiguration);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final Boolean getCopyTagsToVolumes() {
            return this.copyTagsToVolumes;
        }

        public final void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
        }

        @Override
        public final Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(OpenZFSDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return this.diskIopsConfiguration != null ? this.diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final OpenZFSCreateRootVolumeConfiguration.Builder getRootVolumeConfiguration() {
            return this.rootVolumeConfiguration != null ? this.rootVolumeConfiguration.toBuilder() : null;
        }

        public final void setRootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration.BuilderImpl rootVolumeConfiguration) {
            this.rootVolumeConfiguration = rootVolumeConfiguration != null ? rootVolumeConfiguration.build() : null;
        }

        @Override
        public final Builder rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration rootVolumeConfiguration) {
            this.rootVolumeConfiguration = rootVolumeConfiguration;
            return this;
        }

        public final String getPreferredSubnetId() {
            return this.preferredSubnetId;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final String getEndpointIpAddressRange() {
            return this.endpointIpAddressRange;
        }

        public final void setEndpointIpAddressRange(String endpointIpAddressRange) {
            this.endpointIpAddressRange = endpointIpAddressRange;
        }

        @Override
        public final Builder endpointIpAddressRange(String endpointIpAddressRange) {
            this.endpointIpAddressRange = endpointIpAddressRange;
            return this;
        }

        public final Collection<String> getRouteTableIds() {
            if (this.routeTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routeTableIds;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = RouteTableIdsCopier.copy(routeTableIds);
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = RouteTableIdsCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final OpenZFSReadCacheConfiguration.Builder getReadCacheConfiguration() {
            return this.readCacheConfiguration != null ? this.readCacheConfiguration.toBuilder() : null;
        }

        public final void setReadCacheConfiguration(OpenZFSReadCacheConfiguration.BuilderImpl readCacheConfiguration) {
            this.readCacheConfiguration = readCacheConfiguration != null ? readCacheConfiguration.build() : null;
        }

        @Override
        public final Builder readCacheConfiguration(OpenZFSReadCacheConfiguration readCacheConfiguration) {
            this.readCacheConfiguration = readCacheConfiguration;
            return this;
        }

        public CreateFileSystemOpenZFSConfiguration build() {
            return new CreateFileSystemOpenZFSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFileSystemOpenZFSConfiguration> {
        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder copyTagsToVolumes(Boolean var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(OpenZFSDeploymentType var1);

        public Builder throughputCapacity(Integer var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder diskIopsConfiguration(DiskIopsConfiguration var1);

        default public Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return this.diskIopsConfiguration((DiskIopsConfiguration)((DiskIopsConfiguration.Builder)DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration)).build());
        }

        public Builder rootVolumeConfiguration(OpenZFSCreateRootVolumeConfiguration var1);

        default public Builder rootVolumeConfiguration(Consumer<OpenZFSCreateRootVolumeConfiguration.Builder> rootVolumeConfiguration) {
            return this.rootVolumeConfiguration((OpenZFSCreateRootVolumeConfiguration)((OpenZFSCreateRootVolumeConfiguration.Builder)OpenZFSCreateRootVolumeConfiguration.builder().applyMutation(rootVolumeConfiguration)).build());
        }

        public Builder preferredSubnetId(String var1);

        public Builder endpointIpAddressRange(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder readCacheConfiguration(OpenZFSReadCacheConfiguration var1);

        default public Builder readCacheConfiguration(Consumer<OpenZFSReadCacheConfiguration.Builder> readCacheConfiguration) {
            return this.readCacheConfiguration((OpenZFSReadCacheConfiguration)((OpenZFSReadCacheConfiguration.Builder)OpenZFSReadCacheConfiguration.builder().applyMutation(readCacheConfiguration)).build());
        }
    }
}

