/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AdministrativeAction;
import software.amazon.awssdk.services.fsx.model.AdministrativeActionsCopier;
import software.amazon.awssdk.services.fsx.model.FileSystemFailureDetails;
import software.amazon.awssdk.services.fsx.model.FileSystemLifecycle;
import software.amazon.awssdk.services.fsx.model.FileSystemType;
import software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration;
import software.amazon.awssdk.services.fsx.model.NetworkInterfaceIdsCopier;
import software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSFileSystemConfiguration;
import software.amazon.awssdk.services.fsx.model.StorageType;
import software.amazon.awssdk.services.fsx.model.SubnetIdsCopier;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.services.fsx.model.WindowsFileSystemConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystem> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(FileSystem.getter(FileSystem::ownerId)).setter(FileSystem.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FileSystem.getter(FileSystem::creationTime)).setter(FileSystem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(FileSystem.getter(FileSystem::fileSystemId)).setter(FileSystem.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemType").getter(FileSystem.getter(FileSystem::fileSystemTypeAsString)).setter(FileSystem.setter(Builder::fileSystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemType").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(FileSystem.getter(FileSystem::lifecycleAsString)).setter(FileSystem.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<FileSystemFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(FileSystem.getter(FileSystem::failureDetails)).setter(FileSystem.setter(Builder::failureDetails)).constructor(FileSystemFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacity").getter(FileSystem.getter(FileSystem::storageCapacity)).setter(FileSystem.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(FileSystem.getter(FileSystem::storageTypeAsString)).setter(FileSystem.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(FileSystem.getter(FileSystem::vpcId)).setter(FileSystem.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(FileSystem.getter(FileSystem::subnetIds)).setter(FileSystem.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceIds").getter(FileSystem.getter(FileSystem::networkInterfaceIds)).setter(FileSystem.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(FileSystem.getter(FileSystem::dnsName)).setter(FileSystem.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(FileSystem.getter(FileSystem::kmsKeyId)).setter(FileSystem.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(FileSystem.getter(FileSystem::resourceARN)).setter(FileSystem.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(FileSystem.getter(FileSystem::tags)).setter(FileSystem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WindowsFileSystemConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WindowsConfiguration").getter(FileSystem.getter(FileSystem::windowsConfiguration)).setter(FileSystem.setter(Builder::windowsConfiguration)).constructor(WindowsFileSystemConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build()}).build();
    private static final SdkField<LustreFileSystemConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LustreConfiguration").getter(FileSystem.getter(FileSystem::lustreConfiguration)).setter(FileSystem.setter(Builder::lustreConfiguration)).constructor(LustreFileSystemConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdministrativeActions").getter(FileSystem.getter(FileSystem::administrativeActions)).setter(FileSystem.setter(Builder::administrativeActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdministrativeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OntapFileSystemConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OntapConfiguration").getter(FileSystem.getter(FileSystem::ontapConfiguration)).setter(FileSystem.setter(Builder::ontapConfiguration)).constructor(OntapFileSystemConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemTypeVersion").getter(FileSystem.getter(FileSystem::fileSystemTypeVersion)).setter(FileSystem.setter(Builder::fileSystemTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemTypeVersion").build()}).build();
    private static final SdkField<OpenZFSFileSystemConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration").getter(FileSystem.getter(FileSystem::openZFSConfiguration)).setter(FileSystem.setter(Builder::openZFSConfiguration)).constructor(OpenZFSFileSystemConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, CREATION_TIME_FIELD, FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_TYPE_FIELD, LIFECYCLE_FIELD, FAILURE_DETAILS_FIELD, STORAGE_CAPACITY_FIELD, STORAGE_TYPE_FIELD, VPC_ID_FIELD, SUBNET_IDS_FIELD, NETWORK_INTERFACE_IDS_FIELD, DNS_NAME_FIELD, KMS_KEY_ID_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD, ADMINISTRATIVE_ACTIONS_FIELD, ONTAP_CONFIGURATION_FIELD, FILE_SYSTEM_TYPE_VERSION_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileSystem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final Instant creationTime;
    private final String fileSystemId;
    private final String fileSystemType;
    private final String lifecycle;
    private final FileSystemFailureDetails failureDetails;
    private final Integer storageCapacity;
    private final String storageType;
    private final String vpcId;
    private final List<String> subnetIds;
    private final List<String> networkInterfaceIds;
    private final String dnsName;
    private final String kmsKeyId;
    private final String resourceARN;
    private final List<Tag> tags;
    private final WindowsFileSystemConfiguration windowsConfiguration;
    private final LustreFileSystemConfiguration lustreConfiguration;
    private final List<AdministrativeAction> administrativeActions;
    private final OntapFileSystemConfiguration ontapConfiguration;
    private final String fileSystemTypeVersion;
    private final OpenZFSFileSystemConfiguration openZFSConfiguration;

    private FileSystem(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.creationTime = builder.creationTime;
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemType = builder.fileSystemType;
        this.lifecycle = builder.lifecycle;
        this.failureDetails = builder.failureDetails;
        this.storageCapacity = builder.storageCapacity;
        this.storageType = builder.storageType;
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.dnsName = builder.dnsName;
        this.kmsKeyId = builder.kmsKeyId;
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.administrativeActions = builder.administrativeActions;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.fileSystemTypeVersion = builder.fileSystemTypeVersion;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final FileSystemType fileSystemType() {
        return FileSystemType.fromValue(this.fileSystemType);
    }

    public final String fileSystemTypeAsString() {
        return this.fileSystemType;
    }

    public final FileSystemLifecycle lifecycle() {
        return FileSystemLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final FileSystemFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final WindowsFileSystemConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public final LustreFileSystemConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    public final boolean hasAdministrativeActions() {
        return this.administrativeActions != null && !(this.administrativeActions instanceof SdkAutoConstructList);
    }

    public final List<AdministrativeAction> administrativeActions() {
        return this.administrativeActions;
    }

    public final OntapFileSystemConfiguration ontapConfiguration() {
        return this.ontapConfiguration;
    }

    public final String fileSystemTypeVersion() {
        return this.fileSystemTypeVersion;
    }

    public final OpenZFSFileSystemConfiguration openZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdministrativeActions() ? this.administrativeActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.openZFSConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystem)) {
            return false;
        }
        FileSystem other = (FileSystem)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.fileSystemTypeAsString(), other.fileSystemTypeAsString()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds() && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.resourceARN(), other.resourceARN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.windowsConfiguration(), other.windowsConfiguration()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration()) && this.hasAdministrativeActions() == other.hasAdministrativeActions() && Objects.equals(this.administrativeActions(), other.administrativeActions()) && Objects.equals(this.ontapConfiguration(), other.ontapConfiguration()) && Objects.equals(this.fileSystemTypeVersion(), other.fileSystemTypeVersion()) && Objects.equals(this.openZFSConfiguration(), other.openZFSConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"FileSystem").add("OwnerId", (Object)this.ownerId()).add("CreationTime", (Object)this.creationTime()).add("FileSystemId", (Object)this.fileSystemId()).add("FileSystemType", (Object)this.fileSystemTypeAsString()).add("Lifecycle", (Object)this.lifecycleAsString()).add("FailureDetails", (Object)this.failureDetails()).add("StorageCapacity", (Object)this.storageCapacity()).add("StorageType", (Object)this.storageTypeAsString()).add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("NetworkInterfaceIds", this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null).add("DNSName", (Object)this.dnsName()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ResourceARN", (Object)this.resourceARN()).add("Tags", this.hasTags() ? this.tags() : null).add("WindowsConfiguration", (Object)this.windowsConfiguration()).add("LustreConfiguration", (Object)this.lustreConfiguration()).add("AdministrativeActions", this.hasAdministrativeActions() ? this.administrativeActions() : null).add("OntapConfiguration", (Object)this.ontapConfiguration()).add("FileSystemTypeVersion", (Object)this.fileSystemTypeVersion()).add("OpenZFSConfiguration", (Object)this.openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "FileSystemType": {
                return Optional.ofNullable(clazz.cast(this.fileSystemTypeAsString()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "StorageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WindowsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.windowsConfiguration()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
            case "AdministrativeActions": {
                return Optional.ofNullable(clazz.cast(this.administrativeActions()));
            }
            case "OntapConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ontapConfiguration()));
            }
            case "FileSystemTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.fileSystemTypeVersion()));
            }
            case "OpenZFSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openZFSConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("FileSystemType", FILE_SYSTEM_TYPE_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("FailureDetails", FAILURE_DETAILS_FIELD);
        map.put("StorageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("NetworkInterfaceIds", NETWORK_INTERFACE_IDS_FIELD);
        map.put("DNSName", DNS_NAME_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WindowsConfiguration", WINDOWS_CONFIGURATION_FIELD);
        map.put("LustreConfiguration", LUSTRE_CONFIGURATION_FIELD);
        map.put("AdministrativeActions", ADMINISTRATIVE_ACTIONS_FIELD);
        map.put("OntapConfiguration", ONTAP_CONFIGURATION_FIELD);
        map.put("FileSystemTypeVersion", FILE_SYSTEM_TYPE_VERSION_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileSystem, T> g) {
        return obj -> g.apply((FileSystem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private Instant creationTime;
        private String fileSystemId;
        private String fileSystemType;
        private String lifecycle;
        private FileSystemFailureDetails failureDetails;
        private Integer storageCapacity;
        private String storageType;
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String dnsName;
        private String kmsKeyId;
        private String resourceARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private WindowsFileSystemConfiguration windowsConfiguration;
        private LustreFileSystemConfiguration lustreConfiguration;
        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();
        private OntapFileSystemConfiguration ontapConfiguration;
        private String fileSystemTypeVersion;
        private OpenZFSFileSystemConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystem model) {
            this.ownerId(model.ownerId);
            this.creationTime(model.creationTime);
            this.fileSystemId(model.fileSystemId);
            this.fileSystemType(model.fileSystemType);
            this.lifecycle(model.lifecycle);
            this.failureDetails(model.failureDetails);
            this.storageCapacity(model.storageCapacity);
            this.storageType(model.storageType);
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.dnsName(model.dnsName);
            this.kmsKeyId(model.kmsKeyId);
            this.resourceARN(model.resourceARN);
            this.tags(model.tags);
            this.windowsConfiguration(model.windowsConfiguration);
            this.lustreConfiguration(model.lustreConfiguration);
            this.administrativeActions(model.administrativeActions);
            this.ontapConfiguration(model.ontapConfiguration);
            this.fileSystemTypeVersion(model.fileSystemTypeVersion);
            this.openZFSConfiguration(model.openZFSConfiguration);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemType() {
            return this.fileSystemType;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        @Override
        public final Builder fileSystemType(FileSystemType fileSystemType) {
            this.fileSystemType(fileSystemType == null ? null : fileSystemType.toString());
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(FileSystemLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final FileSystemFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FileSystemFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(FileSystemFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (this.networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdsCopier.copy(networkInterfaceIds);
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdsCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WindowsFileSystemConfiguration.Builder getWindowsConfiguration() {
            return this.windowsConfiguration != null ? this.windowsConfiguration.toBuilder() : null;
        }

        public final void setWindowsConfiguration(WindowsFileSystemConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        @Override
        public final Builder windowsConfiguration(WindowsFileSystemConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final LustreFileSystemConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(LustreFileSystemConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(LustreFileSystemConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction ... administrativeActions) {
            this.administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... administrativeActions) {
            this.administrativeActions(Stream.of(administrativeActions).map(c -> (AdministrativeAction)((AdministrativeAction.Builder)AdministrativeAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OntapFileSystemConfiguration.Builder getOntapConfiguration() {
            return this.ontapConfiguration != null ? this.ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(OntapFileSystemConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(OntapFileSystemConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final String getFileSystemTypeVersion() {
            return this.fileSystemTypeVersion;
        }

        public final void setFileSystemTypeVersion(String fileSystemTypeVersion) {
            this.fileSystemTypeVersion = fileSystemTypeVersion;
        }

        @Override
        public final Builder fileSystemTypeVersion(String fileSystemTypeVersion) {
            this.fileSystemTypeVersion = fileSystemTypeVersion;
            return this;
        }

        public final OpenZFSFileSystemConfiguration.Builder getOpenZFSConfiguration() {
            return this.openZFSConfiguration != null ? this.openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(OpenZFSFileSystemConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(OpenZFSFileSystemConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public FileSystem build() {
            return new FileSystem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystem> {
        public Builder ownerId(String var1);

        public Builder creationTime(Instant var1);

        public Builder fileSystemId(String var1);

        public Builder fileSystemType(String var1);

        public Builder fileSystemType(FileSystemType var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(FileSystemLifecycle var1);

        public Builder failureDetails(FileSystemFailureDetails var1);

        default public Builder failureDetails(Consumer<FileSystemFailureDetails.Builder> failureDetails) {
            return this.failureDetails((FileSystemFailureDetails)((FileSystemFailureDetails.Builder)FileSystemFailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder storageCapacity(Integer var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder dnsName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder resourceARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder windowsConfiguration(WindowsFileSystemConfiguration var1);

        default public Builder windowsConfiguration(Consumer<WindowsFileSystemConfiguration.Builder> windowsConfiguration) {
            return this.windowsConfiguration((WindowsFileSystemConfiguration)((WindowsFileSystemConfiguration.Builder)WindowsFileSystemConfiguration.builder().applyMutation(windowsConfiguration)).build());
        }

        public Builder lustreConfiguration(LustreFileSystemConfiguration var1);

        default public Builder lustreConfiguration(Consumer<LustreFileSystemConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((LustreFileSystemConfiguration)((LustreFileSystemConfiguration.Builder)LustreFileSystemConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder administrativeActions(Collection<AdministrativeAction> var1);

        public Builder administrativeActions(AdministrativeAction ... var1);

        public Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... var1);

        public Builder ontapConfiguration(OntapFileSystemConfiguration var1);

        default public Builder ontapConfiguration(Consumer<OntapFileSystemConfiguration.Builder> ontapConfiguration) {
            return this.ontapConfiguration((OntapFileSystemConfiguration)((OntapFileSystemConfiguration.Builder)OntapFileSystemConfiguration.builder().applyMutation(ontapConfiguration)).build());
        }

        public Builder fileSystemTypeVersion(String var1);

        public Builder openZFSConfiguration(OpenZFSFileSystemConfiguration var1);

        default public Builder openZFSConfiguration(Consumer<OpenZFSFileSystemConfiguration.Builder> openZFSConfiguration) {
            return this.openZFSConfiguration((OpenZFSFileSystemConfiguration)((OpenZFSFileSystemConfiguration.Builder)OpenZFSFileSystemConfiguration.builder().applyMutation(openZFSConfiguration)).build());
        }
    }
}

