/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails;
import software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle;
import software.amazon.awssdk.services.fsx.model.NFSDataRepositoryConfiguration;
import software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration;
import software.amazon.awssdk.services.fsx.model.SubDirectoriesPathsCopier;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataRepositoryAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataRepositoryAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::associationId)).setter(DataRepositoryAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::resourceARN)).setter(DataRepositoryAssociation.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::fileSystemId)).setter(DataRepositoryAssociation.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::lifecycleAsString)).setter(DataRepositoryAssociation.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<DataRepositoryFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::failureDetails)).setter(DataRepositoryAssociation.setter(Builder::failureDetails)).constructor(DataRepositoryFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemPath").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::fileSystemPath)).setter(DataRepositoryAssociation.setter(Builder::fileSystemPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemPath").build()}).build();
    private static final SdkField<String> DATA_REPOSITORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRepositoryPath").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::dataRepositoryPath)).setter(DataRepositoryAssociation.setter(Builder::dataRepositoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryPath").build()}).build();
    private static final SdkField<Boolean> BATCH_IMPORT_META_DATA_ON_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BatchImportMetaDataOnCreate").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::batchImportMetaDataOnCreate)).setter(DataRepositoryAssociation.setter(Builder::batchImportMetaDataOnCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchImportMetaDataOnCreate").build()}).build();
    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ImportedFileChunkSize").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::importedFileChunkSize)).setter(DataRepositoryAssociation.setter(Builder::importedFileChunkSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build()}).build();
    private static final SdkField<S3DataRepositoryConfiguration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::s3)).setter(DataRepositoryAssociation.setter(Builder::s3)).constructor(S3DataRepositoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::tags)).setter(DataRepositoryAssociation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::creationTime)).setter(DataRepositoryAssociation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FILE_CACHE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheId").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::fileCacheId)).setter(DataRepositoryAssociation.setter(Builder::fileCacheId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheId").build()}).build();
    private static final SdkField<String> FILE_CACHE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCachePath").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::fileCachePath)).setter(DataRepositoryAssociation.setter(Builder::fileCachePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCachePath").build()}).build();
    private static final SdkField<List<String>> DATA_REPOSITORY_SUBDIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataRepositorySubdirectories").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::dataRepositorySubdirectories)).setter(DataRepositoryAssociation.setter(Builder::dataRepositorySubdirectories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositorySubdirectories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NFSDataRepositoryConfiguration> NFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NFS").getter(DataRepositoryAssociation.getter(DataRepositoryAssociation::nfs)).setter(DataRepositoryAssociation.setter(Builder::nfs)).constructor(NFSDataRepositoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFS").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, RESOURCE_ARN_FIELD, FILE_SYSTEM_ID_FIELD, LIFECYCLE_FIELD, FAILURE_DETAILS_FIELD, FILE_SYSTEM_PATH_FIELD, DATA_REPOSITORY_PATH_FIELD, BATCH_IMPORT_META_DATA_ON_CREATE_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD, S3_FIELD, TAGS_FIELD, CREATION_TIME_FIELD, FILE_CACHE_ID_FIELD, FILE_CACHE_PATH_FIELD, DATA_REPOSITORY_SUBDIRECTORIES_FIELD, NFS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataRepositoryAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String resourceARN;
    private final String fileSystemId;
    private final String lifecycle;
    private final DataRepositoryFailureDetails failureDetails;
    private final String fileSystemPath;
    private final String dataRepositoryPath;
    private final Boolean batchImportMetaDataOnCreate;
    private final Integer importedFileChunkSize;
    private final S3DataRepositoryConfiguration s3;
    private final List<Tag> tags;
    private final Instant creationTime;
    private final String fileCacheId;
    private final String fileCachePath;
    private final List<String> dataRepositorySubdirectories;
    private final NFSDataRepositoryConfiguration nfs;

    private DataRepositoryAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.resourceARN = builder.resourceARN;
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.failureDetails = builder.failureDetails;
        this.fileSystemPath = builder.fileSystemPath;
        this.dataRepositoryPath = builder.dataRepositoryPath;
        this.batchImportMetaDataOnCreate = builder.batchImportMetaDataOnCreate;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.s3 = builder.s3;
        this.tags = builder.tags;
        this.creationTime = builder.creationTime;
        this.fileCacheId = builder.fileCacheId;
        this.fileCachePath = builder.fileCachePath;
        this.dataRepositorySubdirectories = builder.dataRepositorySubdirectories;
        this.nfs = builder.nfs;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final DataRepositoryLifecycle lifecycle() {
        return DataRepositoryLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final DataRepositoryFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final String fileSystemPath() {
        return this.fileSystemPath;
    }

    public final String dataRepositoryPath() {
        return this.dataRepositoryPath;
    }

    public final Boolean batchImportMetaDataOnCreate() {
        return this.batchImportMetaDataOnCreate;
    }

    public final Integer importedFileChunkSize() {
        return this.importedFileChunkSize;
    }

    public final S3DataRepositoryConfiguration s3() {
        return this.s3;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String fileCacheId() {
        return this.fileCacheId;
    }

    public final String fileCachePath() {
        return this.fileCachePath;
    }

    public final boolean hasDataRepositorySubdirectories() {
        return this.dataRepositorySubdirectories != null && !(this.dataRepositorySubdirectories instanceof SdkAutoConstructList);
    }

    public final List<String> dataRepositorySubdirectories() {
        return this.dataRepositorySubdirectories;
    }

    public final NFSDataRepositoryConfiguration nfs() {
        return this.nfs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRepositoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchImportMetaDataOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCachePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataRepositorySubdirectories() ? this.dataRepositorySubdirectories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nfs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryAssociation)) {
            return false;
        }
        DataRepositoryAssociation other = (DataRepositoryAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.fileSystemPath(), other.fileSystemPath()) && Objects.equals(this.dataRepositoryPath(), other.dataRepositoryPath()) && Objects.equals(this.batchImportMetaDataOnCreate(), other.batchImportMetaDataOnCreate()) && Objects.equals(this.importedFileChunkSize(), other.importedFileChunkSize()) && Objects.equals(this.s3(), other.s3()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fileCacheId(), other.fileCacheId()) && Objects.equals(this.fileCachePath(), other.fileCachePath()) && this.hasDataRepositorySubdirectories() == other.hasDataRepositorySubdirectories() && Objects.equals(this.dataRepositorySubdirectories(), other.dataRepositorySubdirectories()) && Objects.equals(this.nfs(), other.nfs());
    }

    public final String toString() {
        return ToString.builder((String)"DataRepositoryAssociation").add("AssociationId", (Object)this.associationId()).add("ResourceARN", (Object)this.resourceARN()).add("FileSystemId", (Object)this.fileSystemId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("FailureDetails", (Object)this.failureDetails()).add("FileSystemPath", (Object)this.fileSystemPath()).add("DataRepositoryPath", (Object)this.dataRepositoryPath()).add("BatchImportMetaDataOnCreate", (Object)this.batchImportMetaDataOnCreate()).add("ImportedFileChunkSize", (Object)this.importedFileChunkSize()).add("S3", (Object)this.s3()).add("Tags", this.hasTags() ? this.tags() : null).add("CreationTime", (Object)this.creationTime()).add("FileCacheId", (Object)this.fileCacheId()).add("FileCachePath", (Object)this.fileCachePath()).add("DataRepositorySubdirectories", this.hasDataRepositorySubdirectories() ? this.dataRepositorySubdirectories() : null).add("NFS", (Object)this.nfs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "FileSystemPath": {
                return Optional.ofNullable(clazz.cast(this.fileSystemPath()));
            }
            case "DataRepositoryPath": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryPath()));
            }
            case "BatchImportMetaDataOnCreate": {
                return Optional.ofNullable(clazz.cast(this.batchImportMetaDataOnCreate()));
            }
            case "ImportedFileChunkSize": {
                return Optional.ofNullable(clazz.cast(this.importedFileChunkSize()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FileCacheId": {
                return Optional.ofNullable(clazz.cast(this.fileCacheId()));
            }
            case "FileCachePath": {
                return Optional.ofNullable(clazz.cast(this.fileCachePath()));
            }
            case "DataRepositorySubdirectories": {
                return Optional.ofNullable(clazz.cast(this.dataRepositorySubdirectories()));
            }
            case "NFS": {
                return Optional.ofNullable(clazz.cast(this.nfs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("FailureDetails", FAILURE_DETAILS_FIELD);
        map.put("FileSystemPath", FILE_SYSTEM_PATH_FIELD);
        map.put("DataRepositoryPath", DATA_REPOSITORY_PATH_FIELD);
        map.put("BatchImportMetaDataOnCreate", BATCH_IMPORT_META_DATA_ON_CREATE_FIELD);
        map.put("ImportedFileChunkSize", IMPORTED_FILE_CHUNK_SIZE_FIELD);
        map.put("S3", S3_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FileCacheId", FILE_CACHE_ID_FIELD);
        map.put("FileCachePath", FILE_CACHE_PATH_FIELD);
        map.put("DataRepositorySubdirectories", DATA_REPOSITORY_SUBDIRECTORIES_FIELD);
        map.put("NFS", NFS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataRepositoryAssociation, T> g) {
        return obj -> g.apply((DataRepositoryAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String resourceARN;
        private String fileSystemId;
        private String lifecycle;
        private DataRepositoryFailureDetails failureDetails;
        private String fileSystemPath;
        private String dataRepositoryPath;
        private Boolean batchImportMetaDataOnCreate;
        private Integer importedFileChunkSize;
        private S3DataRepositoryConfiguration s3;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private String fileCacheId;
        private String fileCachePath;
        private List<String> dataRepositorySubdirectories = DefaultSdkAutoConstructList.getInstance();
        private NFSDataRepositoryConfiguration nfs;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRepositoryAssociation model) {
            this.associationId(model.associationId);
            this.resourceARN(model.resourceARN);
            this.fileSystemId(model.fileSystemId);
            this.lifecycle(model.lifecycle);
            this.failureDetails(model.failureDetails);
            this.fileSystemPath(model.fileSystemPath);
            this.dataRepositoryPath(model.dataRepositoryPath);
            this.batchImportMetaDataOnCreate(model.batchImportMetaDataOnCreate);
            this.importedFileChunkSize(model.importedFileChunkSize);
            this.s3(model.s3);
            this.tags(model.tags);
            this.creationTime(model.creationTime);
            this.fileCacheId(model.fileCacheId);
            this.fileCachePath(model.fileCachePath);
            this.dataRepositorySubdirectories(model.dataRepositorySubdirectories);
            this.nfs(model.nfs);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(DataRepositoryLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final DataRepositoryFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(DataRepositoryFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(DataRepositoryFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final String getFileSystemPath() {
            return this.fileSystemPath;
        }

        public final void setFileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
        }

        @Override
        public final Builder fileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
            return this;
        }

        public final String getDataRepositoryPath() {
            return this.dataRepositoryPath;
        }

        public final void setDataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
        }

        @Override
        public final Builder dataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
            return this;
        }

        public final Boolean getBatchImportMetaDataOnCreate() {
            return this.batchImportMetaDataOnCreate;
        }

        public final void setBatchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
        }

        @Override
        public final Builder batchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
            return this;
        }

        public final Integer getImportedFileChunkSize() {
            return this.importedFileChunkSize;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        @Override
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final S3DataRepositoryConfiguration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3DataRepositoryConfiguration.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3DataRepositoryConfiguration s3) {
            this.s3 = s3;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileCacheId() {
            return this.fileCacheId;
        }

        public final void setFileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
        }

        @Override
        public final Builder fileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
            return this;
        }

        public final String getFileCachePath() {
            return this.fileCachePath;
        }

        public final void setFileCachePath(String fileCachePath) {
            this.fileCachePath = fileCachePath;
        }

        @Override
        public final Builder fileCachePath(String fileCachePath) {
            this.fileCachePath = fileCachePath;
            return this;
        }

        public final Collection<String> getDataRepositorySubdirectories() {
            if (this.dataRepositorySubdirectories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataRepositorySubdirectories;
        }

        public final void setDataRepositorySubdirectories(Collection<String> dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories = SubDirectoriesPathsCopier.copy(dataRepositorySubdirectories);
        }

        @Override
        public final Builder dataRepositorySubdirectories(Collection<String> dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories = SubDirectoriesPathsCopier.copy(dataRepositorySubdirectories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositorySubdirectories(String ... dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories(Arrays.asList(dataRepositorySubdirectories));
            return this;
        }

        public final NFSDataRepositoryConfiguration.Builder getNfs() {
            return this.nfs != null ? this.nfs.toBuilder() : null;
        }

        public final void setNfs(NFSDataRepositoryConfiguration.BuilderImpl nfs) {
            this.nfs = nfs != null ? nfs.build() : null;
        }

        @Override
        public final Builder nfs(NFSDataRepositoryConfiguration nfs) {
            this.nfs = nfs;
            return this;
        }

        public DataRepositoryAssociation build() {
            return new DataRepositoryAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataRepositoryAssociation> {
        public Builder associationId(String var1);

        public Builder resourceARN(String var1);

        public Builder fileSystemId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(DataRepositoryLifecycle var1);

        public Builder failureDetails(DataRepositoryFailureDetails var1);

        default public Builder failureDetails(Consumer<DataRepositoryFailureDetails.Builder> failureDetails) {
            return this.failureDetails((DataRepositoryFailureDetails)((DataRepositoryFailureDetails.Builder)DataRepositoryFailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder fileSystemPath(String var1);

        public Builder dataRepositoryPath(String var1);

        public Builder batchImportMetaDataOnCreate(Boolean var1);

        public Builder importedFileChunkSize(Integer var1);

        public Builder s3(S3DataRepositoryConfiguration var1);

        default public Builder s3(Consumer<S3DataRepositoryConfiguration.Builder> s3) {
            return this.s3((S3DataRepositoryConfiguration)((S3DataRepositoryConfiguration.Builder)S3DataRepositoryConfiguration.builder().applyMutation(s3)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder fileCacheId(String var1);

        public Builder fileCachePath(String var1);

        public Builder dataRepositorySubdirectories(Collection<String> var1);

        public Builder dataRepositorySubdirectories(String ... var1);

        public Builder nfs(NFSDataRepositoryConfiguration var1);

        default public Builder nfs(Consumer<NFSDataRepositoryConfiguration.Builder> nfs) {
            return this.nfs((NFSDataRepositoryConfiguration)((NFSDataRepositoryConfiguration.Builder)NFSDataRepositoryConfiguration.builder().applyMutation(nfs)).build());
        }
    }
}

