/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpenZFSDeploymentType {
    SINGLE_AZ_1("SINGLE_AZ_1"),
    SINGLE_AZ_2("SINGLE_AZ_2"),
    SINGLE_AZ_HA_1("SINGLE_AZ_HA_1"),
    SINGLE_AZ_HA_2("SINGLE_AZ_HA_2"),
    MULTI_AZ_1("MULTI_AZ_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpenZFSDeploymentType> VALUE_MAP;
    private final String value;

    private OpenZFSDeploymentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpenZFSDeploymentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpenZFSDeploymentType> knownValues() {
        EnumSet<OpenZFSDeploymentType> knownValues = EnumSet.allOf(OpenZFSDeploymentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpenZFSDeploymentType.class, OpenZFSDeploymentType::toString);
    }
}

