/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.SnapshotLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSnapshotResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DeleteSnapshotResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(DeleteSnapshotResponse.getter(DeleteSnapshotResponse::snapshotId)).setter(DeleteSnapshotResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DeleteSnapshotResponse.getter(DeleteSnapshotResponse::lifecycleAsString)).setter(DeleteSnapshotResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, LIFECYCLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSnapshotResponse.memberNameToFieldInitializer();
    private final String snapshotId;
    private final String lifecycle;

    private DeleteSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.lifecycle = builder.lifecycle;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final SnapshotLifecycle lifecycle() {
        return SnapshotLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSnapshotResponse)) {
            return false;
        }
        DeleteSnapshotResponse other = (DeleteSnapshotResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSnapshotResponse").add("SnapshotId", (Object)this.snapshotId()).add("Lifecycle", (Object)this.lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSnapshotResponse, T> g) {
        return obj -> g.apply((DeleteSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSnapshotResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.lifecycle(model.lifecycle);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(SnapshotLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        @Override
        public DeleteSnapshotResponse build() {
            return new DeleteSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSnapshotResponse> {
        public Builder snapshotId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(SnapshotLifecycle var1);
    }
}

