/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachine;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachinesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageVirtualMachinesResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DescribeStorageVirtualMachinesResponse> {
    private static final SdkField<List<StorageVirtualMachine>> STORAGE_VIRTUAL_MACHINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageVirtualMachines").getter(DescribeStorageVirtualMachinesResponse.getter(DescribeStorageVirtualMachinesResponse::storageVirtualMachines)).setter(DescribeStorageVirtualMachinesResponse.setter(Builder::storageVirtualMachines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageVirtualMachine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStorageVirtualMachinesResponse.getter(DescribeStorageVirtualMachinesResponse::nextToken)).setter(DescribeStorageVirtualMachinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_VIRTUAL_MACHINES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStorageVirtualMachinesResponse.memberNameToFieldInitializer();
    private final List<StorageVirtualMachine> storageVirtualMachines;
    private final String nextToken;

    private DescribeStorageVirtualMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.storageVirtualMachines = builder.storageVirtualMachines;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStorageVirtualMachines() {
        return this.storageVirtualMachines != null && !(this.storageVirtualMachines instanceof SdkAutoConstructList);
    }

    public final List<StorageVirtualMachine> storageVirtualMachines() {
        return this.storageVirtualMachines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageVirtualMachines() ? this.storageVirtualMachines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageVirtualMachinesResponse)) {
            return false;
        }
        DescribeStorageVirtualMachinesResponse other = (DescribeStorageVirtualMachinesResponse)((Object)obj);
        return this.hasStorageVirtualMachines() == other.hasStorageVirtualMachines() && Objects.equals(this.storageVirtualMachines(), other.storageVirtualMachines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageVirtualMachinesResponse").add("StorageVirtualMachines", this.hasStorageVirtualMachines() ? this.storageVirtualMachines() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageVirtualMachines": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachines()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StorageVirtualMachines", STORAGE_VIRTUAL_MACHINES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageVirtualMachinesResponse, T> g) {
        return obj -> g.apply((DescribeStorageVirtualMachinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private List<StorageVirtualMachine> storageVirtualMachines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageVirtualMachinesResponse model) {
            super(model);
            this.storageVirtualMachines(model.storageVirtualMachines);
            this.nextToken(model.nextToken);
        }

        public final List<StorageVirtualMachine.Builder> getStorageVirtualMachines() {
            List<StorageVirtualMachine.Builder> result = StorageVirtualMachinesCopier.copyToBuilder(this.storageVirtualMachines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageVirtualMachines(Collection<StorageVirtualMachine.BuilderImpl> storageVirtualMachines) {
            this.storageVirtualMachines = StorageVirtualMachinesCopier.copyFromBuilder(storageVirtualMachines);
        }

        @Override
        public final Builder storageVirtualMachines(Collection<StorageVirtualMachine> storageVirtualMachines) {
            this.storageVirtualMachines = StorageVirtualMachinesCopier.copy(storageVirtualMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageVirtualMachines(StorageVirtualMachine ... storageVirtualMachines) {
            this.storageVirtualMachines(Arrays.asList(storageVirtualMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageVirtualMachines(Consumer<StorageVirtualMachine.Builder> ... storageVirtualMachines) {
            this.storageVirtualMachines(Stream.of(storageVirtualMachines).map(c -> (StorageVirtualMachine)((StorageVirtualMachine.Builder)StorageVirtualMachine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStorageVirtualMachinesResponse build() {
            return new DescribeStorageVirtualMachinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageVirtualMachinesResponse> {
        public Builder storageVirtualMachines(Collection<StorageVirtualMachine> var1);

        public Builder storageVirtualMachines(StorageVirtualMachine ... var1);

        public Builder storageVirtualMachines(Consumer<StorageVirtualMachine.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

