/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.AutocommitPeriod;
import software.amazon.awssdk.services.fsx.model.PrivilegedDelete;
import software.amazon.awssdk.services.fsx.model.SnaplockRetentionPeriod;
import software.amazon.awssdk.services.fsx.model.SnaplockType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnaplockConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateSnaplockConfiguration> {
    private static final SdkField<Boolean> AUDIT_LOG_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AuditLogVolume").getter(CreateSnaplockConfiguration.getter(CreateSnaplockConfiguration::auditLogVolume)).setter(CreateSnaplockConfiguration.setter(Builder::auditLogVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogVolume").build()}).build();
    private static final SdkField<AutocommitPeriod> AUTOCOMMIT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutocommitPeriod").getter(CreateSnaplockConfiguration.getter(CreateSnaplockConfiguration::autocommitPeriod)).setter(CreateSnaplockConfiguration.setter(Builder::autocommitPeriod)).constructor(AutocommitPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutocommitPeriod").build()}).build();
    private static final SdkField<String> PRIVILEGED_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivilegedDelete").getter(CreateSnaplockConfiguration.getter(CreateSnaplockConfiguration::privilegedDeleteAsString)).setter(CreateSnaplockConfiguration.setter(Builder::privilegedDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivilegedDelete").build()}).build();
    private static final SdkField<SnaplockRetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionPeriod").getter(CreateSnaplockConfiguration.getter(CreateSnaplockConfiguration::retentionPeriod)).setter(CreateSnaplockConfiguration.setter(Builder::retentionPeriod)).constructor(SnaplockRetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<String> SNAPLOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnaplockType").getter(CreateSnaplockConfiguration.getter(CreateSnaplockConfiguration::snaplockTypeAsString)).setter(CreateSnaplockConfiguration.setter(Builder::snaplockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnaplockType").build()}).build();
    private static final SdkField<Boolean> VOLUME_APPEND_MODE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VolumeAppendModeEnabled").getter(CreateSnaplockConfiguration.getter(CreateSnaplockConfiguration::volumeAppendModeEnabled)).setter(CreateSnaplockConfiguration.setter(Builder::volumeAppendModeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeAppendModeEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_LOG_VOLUME_FIELD, AUTOCOMMIT_PERIOD_FIELD, PRIVILEGED_DELETE_FIELD, RETENTION_PERIOD_FIELD, SNAPLOCK_TYPE_FIELD, VOLUME_APPEND_MODE_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSnaplockConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean auditLogVolume;
    private final AutocommitPeriod autocommitPeriod;
    private final String privilegedDelete;
    private final SnaplockRetentionPeriod retentionPeriod;
    private final String snaplockType;
    private final Boolean volumeAppendModeEnabled;

    private CreateSnaplockConfiguration(BuilderImpl builder) {
        this.auditLogVolume = builder.auditLogVolume;
        this.autocommitPeriod = builder.autocommitPeriod;
        this.privilegedDelete = builder.privilegedDelete;
        this.retentionPeriod = builder.retentionPeriod;
        this.snaplockType = builder.snaplockType;
        this.volumeAppendModeEnabled = builder.volumeAppendModeEnabled;
    }

    public final Boolean auditLogVolume() {
        return this.auditLogVolume;
    }

    public final AutocommitPeriod autocommitPeriod() {
        return this.autocommitPeriod;
    }

    public final PrivilegedDelete privilegedDelete() {
        return PrivilegedDelete.fromValue(this.privilegedDelete);
    }

    public final String privilegedDeleteAsString() {
        return this.privilegedDelete;
    }

    public final SnaplockRetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final SnaplockType snaplockType() {
        return SnaplockType.fromValue(this.snaplockType);
    }

    public final String snaplockTypeAsString() {
        return this.snaplockType;
    }

    public final Boolean volumeAppendModeEnabled() {
        return this.volumeAppendModeEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.autocommitPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedDeleteAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snaplockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeAppendModeEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnaplockConfiguration)) {
            return false;
        }
        CreateSnaplockConfiguration other = (CreateSnaplockConfiguration)obj;
        return Objects.equals(this.auditLogVolume(), other.auditLogVolume()) && Objects.equals(this.autocommitPeriod(), other.autocommitPeriod()) && Objects.equals(this.privilegedDeleteAsString(), other.privilegedDeleteAsString()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.snaplockTypeAsString(), other.snaplockTypeAsString()) && Objects.equals(this.volumeAppendModeEnabled(), other.volumeAppendModeEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnaplockConfiguration").add("AuditLogVolume", (Object)this.auditLogVolume()).add("AutocommitPeriod", (Object)this.autocommitPeriod()).add("PrivilegedDelete", (Object)this.privilegedDeleteAsString()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("SnaplockType", (Object)this.snaplockTypeAsString()).add("VolumeAppendModeEnabled", (Object)this.volumeAppendModeEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuditLogVolume": {
                return Optional.ofNullable(clazz.cast(this.auditLogVolume()));
            }
            case "AutocommitPeriod": {
                return Optional.ofNullable(clazz.cast(this.autocommitPeriod()));
            }
            case "PrivilegedDelete": {
                return Optional.ofNullable(clazz.cast(this.privilegedDeleteAsString()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "SnaplockType": {
                return Optional.ofNullable(clazz.cast(this.snaplockTypeAsString()));
            }
            case "VolumeAppendModeEnabled": {
                return Optional.ofNullable(clazz.cast(this.volumeAppendModeEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuditLogVolume", AUDIT_LOG_VOLUME_FIELD);
        map.put("AutocommitPeriod", AUTOCOMMIT_PERIOD_FIELD);
        map.put("PrivilegedDelete", PRIVILEGED_DELETE_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("SnaplockType", SNAPLOCK_TYPE_FIELD);
        map.put("VolumeAppendModeEnabled", VOLUME_APPEND_MODE_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnaplockConfiguration, T> g) {
        return obj -> g.apply((CreateSnaplockConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean auditLogVolume;
        private AutocommitPeriod autocommitPeriod;
        private String privilegedDelete;
        private SnaplockRetentionPeriod retentionPeriod;
        private String snaplockType;
        private Boolean volumeAppendModeEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnaplockConfiguration model) {
            this.auditLogVolume(model.auditLogVolume);
            this.autocommitPeriod(model.autocommitPeriod);
            this.privilegedDelete(model.privilegedDelete);
            this.retentionPeriod(model.retentionPeriod);
            this.snaplockType(model.snaplockType);
            this.volumeAppendModeEnabled(model.volumeAppendModeEnabled);
        }

        public final Boolean getAuditLogVolume() {
            return this.auditLogVolume;
        }

        public final void setAuditLogVolume(Boolean auditLogVolume) {
            this.auditLogVolume = auditLogVolume;
        }

        @Override
        public final Builder auditLogVolume(Boolean auditLogVolume) {
            this.auditLogVolume = auditLogVolume;
            return this;
        }

        public final AutocommitPeriod.Builder getAutocommitPeriod() {
            return this.autocommitPeriod != null ? this.autocommitPeriod.toBuilder() : null;
        }

        public final void setAutocommitPeriod(AutocommitPeriod.BuilderImpl autocommitPeriod) {
            this.autocommitPeriod = autocommitPeriod != null ? autocommitPeriod.build() : null;
        }

        @Override
        public final Builder autocommitPeriod(AutocommitPeriod autocommitPeriod) {
            this.autocommitPeriod = autocommitPeriod;
            return this;
        }

        public final String getPrivilegedDelete() {
            return this.privilegedDelete;
        }

        public final void setPrivilegedDelete(String privilegedDelete) {
            this.privilegedDelete = privilegedDelete;
        }

        @Override
        public final Builder privilegedDelete(String privilegedDelete) {
            this.privilegedDelete = privilegedDelete;
            return this;
        }

        @Override
        public final Builder privilegedDelete(PrivilegedDelete privilegedDelete) {
            this.privilegedDelete(privilegedDelete == null ? null : privilegedDelete.toString());
            return this;
        }

        public final SnaplockRetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(SnaplockRetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(SnaplockRetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnaplockType() {
            return this.snaplockType;
        }

        public final void setSnaplockType(String snaplockType) {
            this.snaplockType = snaplockType;
        }

        @Override
        public final Builder snaplockType(String snaplockType) {
            this.snaplockType = snaplockType;
            return this;
        }

        @Override
        public final Builder snaplockType(SnaplockType snaplockType) {
            this.snaplockType(snaplockType == null ? null : snaplockType.toString());
            return this;
        }

        public final Boolean getVolumeAppendModeEnabled() {
            return this.volumeAppendModeEnabled;
        }

        public final void setVolumeAppendModeEnabled(Boolean volumeAppendModeEnabled) {
            this.volumeAppendModeEnabled = volumeAppendModeEnabled;
        }

        @Override
        public final Builder volumeAppendModeEnabled(Boolean volumeAppendModeEnabled) {
            this.volumeAppendModeEnabled = volumeAppendModeEnabled;
            return this;
        }

        public CreateSnaplockConfiguration build() {
            return new CreateSnaplockConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateSnaplockConfiguration> {
        public Builder auditLogVolume(Boolean var1);

        public Builder autocommitPeriod(AutocommitPeriod var1);

        default public Builder autocommitPeriod(Consumer<AutocommitPeriod.Builder> autocommitPeriod) {
            return this.autocommitPeriod((AutocommitPeriod)((AutocommitPeriod.Builder)AutocommitPeriod.builder().applyMutation(autocommitPeriod)).build());
        }

        public Builder privilegedDelete(String var1);

        public Builder privilegedDelete(PrivilegedDelete var1);

        public Builder retentionPeriod(SnaplockRetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<SnaplockRetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((SnaplockRetentionPeriod)((SnaplockRetentionPeriod.Builder)SnaplockRetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder snaplockType(String var1);

        public Builder snaplockType(SnaplockType var1);

        public Builder volumeAppendModeEnabled(Boolean var1);
    }
}

