/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociationsCopier;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataRepositoryAssociationsResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DescribeDataRepositoryAssociationsResponse> {
    private static final SdkField<List<DataRepositoryAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(DescribeDataRepositoryAssociationsResponse.getter(DescribeDataRepositoryAssociationsResponse::associations)).setter(DescribeDataRepositoryAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataRepositoryAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDataRepositoryAssociationsResponse.getter(DescribeDataRepositoryAssociationsResponse::nextToken)).setter(DescribeDataRepositoryAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Associations", ASSOCIATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DataRepositoryAssociation> associations;
    private final String nextToken;

    private DescribeDataRepositoryAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<DataRepositoryAssociation> associations() {
        return this.associations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataRepositoryAssociationsResponse)) {
            return false;
        }
        DescribeDataRepositoryAssociationsResponse other = (DescribeDataRepositoryAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataRepositoryAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataRepositoryAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeDataRepositoryAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private List<DataRepositoryAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataRepositoryAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final List<DataRepositoryAssociation.Builder> getAssociations() {
            List<DataRepositoryAssociation.Builder> result = DataRepositoryAssociationsCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<DataRepositoryAssociation.BuilderImpl> associations) {
            this.associations = DataRepositoryAssociationsCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<DataRepositoryAssociation> associations) {
            this.associations = DataRepositoryAssociationsCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(DataRepositoryAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<DataRepositoryAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (DataRepositoryAssociation)((DataRepositoryAssociation.Builder)DataRepositoryAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDataRepositoryAssociationsResponse build() {
            return new DescribeDataRepositoryAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataRepositoryAssociationsResponse> {
        public Builder associations(Collection<DataRepositoryAssociation> var1);

        public Builder associations(DataRepositoryAssociation ... var1);

        public Builder associations(Consumer<DataRepositoryAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

