/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy;
import software.amazon.awssdk.services.fsx.model.OpenZFSDataCompressionType;
import software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport;
import software.amazon.awssdk.services.fsx.model.OpenZFSNfsExportsCopier;
import software.amazon.awssdk.services.fsx.model.OpenZFSOriginSnapshotConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSUserAndGroupQuotasCopier;
import software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenZFSVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenZFSVolumeConfiguration> {
    private static final SdkField<String> PARENT_VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentVolumeId").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::parentVolumeId)).setter(OpenZFSVolumeConfiguration.setter(Builder::parentVolumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentVolumeId").build()}).build();
    private static final SdkField<String> VOLUME_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumePath").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::volumePath)).setter(OpenZFSVolumeConfiguration.setter(Builder::volumePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumePath").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_RESERVATION_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacityReservationGiB").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::storageCapacityReservationGiB)).setter(OpenZFSVolumeConfiguration.setter(Builder::storageCapacityReservationGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityReservationGiB").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_QUOTA_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacityQuotaGiB").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::storageCapacityQuotaGiB)).setter(OpenZFSVolumeConfiguration.setter(Builder::storageCapacityQuotaGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityQuotaGiB").build()}).build();
    private static final SdkField<Integer> RECORD_SIZE_KIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecordSizeKiB").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::recordSizeKiB)).setter(OpenZFSVolumeConfiguration.setter(Builder::recordSizeKiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordSizeKiB").build()}).build();
    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCompressionType").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::dataCompressionTypeAsString)).setter(OpenZFSVolumeConfiguration.setter(Builder::dataCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshots").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::copyTagsToSnapshots)).setter(OpenZFSVolumeConfiguration.setter(Builder::copyTagsToSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshots").build()}).build();
    private static final SdkField<OpenZFSOriginSnapshotConfiguration> ORIGIN_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginSnapshot").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::originSnapshot)).setter(OpenZFSVolumeConfiguration.setter(Builder::originSnapshot)).constructor(OpenZFSOriginSnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSnapshot").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadOnly").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::readOnly)).setter(OpenZFSVolumeConfiguration.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<List<OpenZFSNfsExport>> NFS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NfsExports").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::nfsExports)).setter(OpenZFSVolumeConfiguration.setter(Builder::nfsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NfsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenZFSNfsExport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OpenZFSUserOrGroupQuota>> USER_AND_GROUP_QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAndGroupQuotas").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::userAndGroupQuotas)).setter(OpenZFSVolumeConfiguration.setter(Builder::userAndGroupQuotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAndGroupQuotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenZFSUserOrGroupQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESTORE_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreToSnapshot").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::restoreToSnapshot)).setter(OpenZFSVolumeConfiguration.setter(Builder::restoreToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreToSnapshot").build()}).build();
    private static final SdkField<Boolean> DELETE_INTERMEDIATE_SNAPHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteIntermediateSnaphots").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::deleteIntermediateSnaphots)).setter(OpenZFSVolumeConfiguration.setter(Builder::deleteIntermediateSnaphots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteIntermediateSnaphots").build()}).build();
    private static final SdkField<Boolean> DELETE_CLONED_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteClonedVolumes").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::deleteClonedVolumes)).setter(OpenZFSVolumeConfiguration.setter(Builder::deleteClonedVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteClonedVolumes").build()}).build();
    private static final SdkField<Boolean> DELETE_INTERMEDIATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteIntermediateData").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::deleteIntermediateData)).setter(OpenZFSVolumeConfiguration.setter(Builder::deleteIntermediateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteIntermediateData").build()}).build();
    private static final SdkField<String> SOURCE_SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceSnapshotARN").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::sourceSnapshotARN)).setter(OpenZFSVolumeConfiguration.setter(Builder::sourceSnapshotARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotARN").build()}).build();
    private static final SdkField<String> DESTINATION_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationSnapshot").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::destinationSnapshot)).setter(OpenZFSVolumeConfiguration.setter(Builder::destinationSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSnapshot").build()}).build();
    private static final SdkField<String> COPY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyStrategy").getter(OpenZFSVolumeConfiguration.getter(OpenZFSVolumeConfiguration::copyStrategyAsString)).setter(OpenZFSVolumeConfiguration.setter(Builder::copyStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_VOLUME_ID_FIELD, VOLUME_PATH_FIELD, STORAGE_CAPACITY_RESERVATION_GIB_FIELD, STORAGE_CAPACITY_QUOTA_GIB_FIELD, RECORD_SIZE_KIB_FIELD, DATA_COMPRESSION_TYPE_FIELD, COPY_TAGS_TO_SNAPSHOTS_FIELD, ORIGIN_SNAPSHOT_FIELD, READ_ONLY_FIELD, NFS_EXPORTS_FIELD, USER_AND_GROUP_QUOTAS_FIELD, RESTORE_TO_SNAPSHOT_FIELD, DELETE_INTERMEDIATE_SNAPHOTS_FIELD, DELETE_CLONED_VOLUMES_FIELD, DELETE_INTERMEDIATE_DATA_FIELD, SOURCE_SNAPSHOT_ARN_FIELD, DESTINATION_SNAPSHOT_FIELD, COPY_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parentVolumeId;
    private final String volumePath;
    private final Integer storageCapacityReservationGiB;
    private final Integer storageCapacityQuotaGiB;
    private final Integer recordSizeKiB;
    private final String dataCompressionType;
    private final Boolean copyTagsToSnapshots;
    private final OpenZFSOriginSnapshotConfiguration originSnapshot;
    private final Boolean readOnly;
    private final List<OpenZFSNfsExport> nfsExports;
    private final List<OpenZFSUserOrGroupQuota> userAndGroupQuotas;
    private final String restoreToSnapshot;
    private final Boolean deleteIntermediateSnaphots;
    private final Boolean deleteClonedVolumes;
    private final Boolean deleteIntermediateData;
    private final String sourceSnapshotARN;
    private final String destinationSnapshot;
    private final String copyStrategy;

    private OpenZFSVolumeConfiguration(BuilderImpl builder) {
        this.parentVolumeId = builder.parentVolumeId;
        this.volumePath = builder.volumePath;
        this.storageCapacityReservationGiB = builder.storageCapacityReservationGiB;
        this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
        this.recordSizeKiB = builder.recordSizeKiB;
        this.dataCompressionType = builder.dataCompressionType;
        this.copyTagsToSnapshots = builder.copyTagsToSnapshots;
        this.originSnapshot = builder.originSnapshot;
        this.readOnly = builder.readOnly;
        this.nfsExports = builder.nfsExports;
        this.userAndGroupQuotas = builder.userAndGroupQuotas;
        this.restoreToSnapshot = builder.restoreToSnapshot;
        this.deleteIntermediateSnaphots = builder.deleteIntermediateSnaphots;
        this.deleteClonedVolumes = builder.deleteClonedVolumes;
        this.deleteIntermediateData = builder.deleteIntermediateData;
        this.sourceSnapshotARN = builder.sourceSnapshotARN;
        this.destinationSnapshot = builder.destinationSnapshot;
        this.copyStrategy = builder.copyStrategy;
    }

    public final String parentVolumeId() {
        return this.parentVolumeId;
    }

    public final String volumePath() {
        return this.volumePath;
    }

    public final Integer storageCapacityReservationGiB() {
        return this.storageCapacityReservationGiB;
    }

    public final Integer storageCapacityQuotaGiB() {
        return this.storageCapacityQuotaGiB;
    }

    public final Integer recordSizeKiB() {
        return this.recordSizeKiB;
    }

    public final OpenZFSDataCompressionType dataCompressionType() {
        return OpenZFSDataCompressionType.fromValue(this.dataCompressionType);
    }

    public final String dataCompressionTypeAsString() {
        return this.dataCompressionType;
    }

    public final Boolean copyTagsToSnapshots() {
        return this.copyTagsToSnapshots;
    }

    public final OpenZFSOriginSnapshotConfiguration originSnapshot() {
        return this.originSnapshot;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public final boolean hasNfsExports() {
        return this.nfsExports != null && !(this.nfsExports instanceof SdkAutoConstructList);
    }

    public final List<OpenZFSNfsExport> nfsExports() {
        return this.nfsExports;
    }

    public final boolean hasUserAndGroupQuotas() {
        return this.userAndGroupQuotas != null && !(this.userAndGroupQuotas instanceof SdkAutoConstructList);
    }

    public final List<OpenZFSUserOrGroupQuota> userAndGroupQuotas() {
        return this.userAndGroupQuotas;
    }

    public final String restoreToSnapshot() {
        return this.restoreToSnapshot;
    }

    public final Boolean deleteIntermediateSnaphots() {
        return this.deleteIntermediateSnaphots;
    }

    public final Boolean deleteClonedVolumes() {
        return this.deleteClonedVolumes;
    }

    public final Boolean deleteIntermediateData() {
        return this.deleteIntermediateData;
    }

    public final String sourceSnapshotARN() {
        return this.sourceSnapshotARN;
    }

    public final String destinationSnapshot() {
        return this.destinationSnapshot;
    }

    public final OpenZFSCopyStrategy copyStrategy() {
        return OpenZFSCopyStrategy.fromValue(this.copyStrategy);
    }

    public final String copyStrategyAsString() {
        return this.copyStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacityReservationGiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacityQuotaGiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordSizeKiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshots());
        hashCode = 31 * hashCode + Objects.hashCode(this.originSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNfsExports() ? this.nfsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAndGroupQuotas() ? this.userAndGroupQuotas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteIntermediateSnaphots());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteClonedVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteIntermediateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSVolumeConfiguration)) {
            return false;
        }
        OpenZFSVolumeConfiguration other = (OpenZFSVolumeConfiguration)obj;
        return Objects.equals(this.parentVolumeId(), other.parentVolumeId()) && Objects.equals(this.volumePath(), other.volumePath()) && Objects.equals(this.storageCapacityReservationGiB(), other.storageCapacityReservationGiB()) && Objects.equals(this.storageCapacityQuotaGiB(), other.storageCapacityQuotaGiB()) && Objects.equals(this.recordSizeKiB(), other.recordSizeKiB()) && Objects.equals(this.dataCompressionTypeAsString(), other.dataCompressionTypeAsString()) && Objects.equals(this.copyTagsToSnapshots(), other.copyTagsToSnapshots()) && Objects.equals(this.originSnapshot(), other.originSnapshot()) && Objects.equals(this.readOnly(), other.readOnly()) && this.hasNfsExports() == other.hasNfsExports() && Objects.equals(this.nfsExports(), other.nfsExports()) && this.hasUserAndGroupQuotas() == other.hasUserAndGroupQuotas() && Objects.equals(this.userAndGroupQuotas(), other.userAndGroupQuotas()) && Objects.equals(this.restoreToSnapshot(), other.restoreToSnapshot()) && Objects.equals(this.deleteIntermediateSnaphots(), other.deleteIntermediateSnaphots()) && Objects.equals(this.deleteClonedVolumes(), other.deleteClonedVolumes()) && Objects.equals(this.deleteIntermediateData(), other.deleteIntermediateData()) && Objects.equals(this.sourceSnapshotARN(), other.sourceSnapshotARN()) && Objects.equals(this.destinationSnapshot(), other.destinationSnapshot()) && Objects.equals(this.copyStrategyAsString(), other.copyStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OpenZFSVolumeConfiguration").add("ParentVolumeId", (Object)this.parentVolumeId()).add("VolumePath", (Object)this.volumePath()).add("StorageCapacityReservationGiB", (Object)this.storageCapacityReservationGiB()).add("StorageCapacityQuotaGiB", (Object)this.storageCapacityQuotaGiB()).add("RecordSizeKiB", (Object)this.recordSizeKiB()).add("DataCompressionType", (Object)this.dataCompressionTypeAsString()).add("CopyTagsToSnapshots", (Object)this.copyTagsToSnapshots()).add("OriginSnapshot", (Object)this.originSnapshot()).add("ReadOnly", (Object)this.readOnly()).add("NfsExports", this.hasNfsExports() ? this.nfsExports() : null).add("UserAndGroupQuotas", this.hasUserAndGroupQuotas() ? this.userAndGroupQuotas() : null).add("RestoreToSnapshot", (Object)this.restoreToSnapshot()).add("DeleteIntermediateSnaphots", (Object)this.deleteIntermediateSnaphots()).add("DeleteClonedVolumes", (Object)this.deleteClonedVolumes()).add("DeleteIntermediateData", (Object)this.deleteIntermediateData()).add("SourceSnapshotARN", (Object)this.sourceSnapshotARN()).add("DestinationSnapshot", (Object)this.destinationSnapshot()).add("CopyStrategy", (Object)this.copyStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentVolumeId": {
                return Optional.ofNullable(clazz.cast(this.parentVolumeId()));
            }
            case "VolumePath": {
                return Optional.ofNullable(clazz.cast(this.volumePath()));
            }
            case "StorageCapacityReservationGiB": {
                return Optional.ofNullable(clazz.cast(this.storageCapacityReservationGiB()));
            }
            case "StorageCapacityQuotaGiB": {
                return Optional.ofNullable(clazz.cast(this.storageCapacityQuotaGiB()));
            }
            case "RecordSizeKiB": {
                return Optional.ofNullable(clazz.cast(this.recordSizeKiB()));
            }
            case "DataCompressionType": {
                return Optional.ofNullable(clazz.cast(this.dataCompressionTypeAsString()));
            }
            case "CopyTagsToSnapshots": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshots()));
            }
            case "OriginSnapshot": {
                return Optional.ofNullable(clazz.cast(this.originSnapshot()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "NfsExports": {
                return Optional.ofNullable(clazz.cast(this.nfsExports()));
            }
            case "UserAndGroupQuotas": {
                return Optional.ofNullable(clazz.cast(this.userAndGroupQuotas()));
            }
            case "RestoreToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.restoreToSnapshot()));
            }
            case "DeleteIntermediateSnaphots": {
                return Optional.ofNullable(clazz.cast(this.deleteIntermediateSnaphots()));
            }
            case "DeleteClonedVolumes": {
                return Optional.ofNullable(clazz.cast(this.deleteClonedVolumes()));
            }
            case "DeleteIntermediateData": {
                return Optional.ofNullable(clazz.cast(this.deleteIntermediateData()));
            }
            case "SourceSnapshotARN": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotARN()));
            }
            case "DestinationSnapshot": {
                return Optional.ofNullable(clazz.cast(this.destinationSnapshot()));
            }
            case "CopyStrategy": {
                return Optional.ofNullable(clazz.cast(this.copyStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSVolumeConfiguration, T> g) {
        return obj -> g.apply((OpenZFSVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentVolumeId;
        private String volumePath;
        private Integer storageCapacityReservationGiB;
        private Integer storageCapacityQuotaGiB;
        private Integer recordSizeKiB;
        private String dataCompressionType;
        private Boolean copyTagsToSnapshots;
        private OpenZFSOriginSnapshotConfiguration originSnapshot;
        private Boolean readOnly;
        private List<OpenZFSNfsExport> nfsExports = DefaultSdkAutoConstructList.getInstance();
        private List<OpenZFSUserOrGroupQuota> userAndGroupQuotas = DefaultSdkAutoConstructList.getInstance();
        private String restoreToSnapshot;
        private Boolean deleteIntermediateSnaphots;
        private Boolean deleteClonedVolumes;
        private Boolean deleteIntermediateData;
        private String sourceSnapshotARN;
        private String destinationSnapshot;
        private String copyStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSVolumeConfiguration model) {
            this.parentVolumeId(model.parentVolumeId);
            this.volumePath(model.volumePath);
            this.storageCapacityReservationGiB(model.storageCapacityReservationGiB);
            this.storageCapacityQuotaGiB(model.storageCapacityQuotaGiB);
            this.recordSizeKiB(model.recordSizeKiB);
            this.dataCompressionType(model.dataCompressionType);
            this.copyTagsToSnapshots(model.copyTagsToSnapshots);
            this.originSnapshot(model.originSnapshot);
            this.readOnly(model.readOnly);
            this.nfsExports(model.nfsExports);
            this.userAndGroupQuotas(model.userAndGroupQuotas);
            this.restoreToSnapshot(model.restoreToSnapshot);
            this.deleteIntermediateSnaphots(model.deleteIntermediateSnaphots);
            this.deleteClonedVolumes(model.deleteClonedVolumes);
            this.deleteIntermediateData(model.deleteIntermediateData);
            this.sourceSnapshotARN(model.sourceSnapshotARN);
            this.destinationSnapshot(model.destinationSnapshot);
            this.copyStrategy(model.copyStrategy);
        }

        public final String getParentVolumeId() {
            return this.parentVolumeId;
        }

        public final void setParentVolumeId(String parentVolumeId) {
            this.parentVolumeId = parentVolumeId;
        }

        @Override
        public final Builder parentVolumeId(String parentVolumeId) {
            this.parentVolumeId = parentVolumeId;
            return this;
        }

        public final String getVolumePath() {
            return this.volumePath;
        }

        public final void setVolumePath(String volumePath) {
            this.volumePath = volumePath;
        }

        @Override
        public final Builder volumePath(String volumePath) {
            this.volumePath = volumePath;
            return this;
        }

        public final Integer getStorageCapacityReservationGiB() {
            return this.storageCapacityReservationGiB;
        }

        public final void setStorageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
            this.storageCapacityReservationGiB = storageCapacityReservationGiB;
        }

        @Override
        public final Builder storageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
            this.storageCapacityReservationGiB = storageCapacityReservationGiB;
            return this;
        }

        public final Integer getStorageCapacityQuotaGiB() {
            return this.storageCapacityQuotaGiB;
        }

        public final void setStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
        }

        @Override
        public final Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
            return this;
        }

        public final Integer getRecordSizeKiB() {
            return this.recordSizeKiB;
        }

        public final void setRecordSizeKiB(Integer recordSizeKiB) {
            this.recordSizeKiB = recordSizeKiB;
        }

        @Override
        public final Builder recordSizeKiB(Integer recordSizeKiB) {
            this.recordSizeKiB = recordSizeKiB;
            return this;
        }

        public final String getDataCompressionType() {
            return this.dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        public final Builder dataCompressionType(OpenZFSDataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public final Boolean getCopyTagsToSnapshots() {
            return this.copyTagsToSnapshots;
        }

        public final void setCopyTagsToSnapshots(Boolean copyTagsToSnapshots) {
            this.copyTagsToSnapshots = copyTagsToSnapshots;
        }

        @Override
        public final Builder copyTagsToSnapshots(Boolean copyTagsToSnapshots) {
            this.copyTagsToSnapshots = copyTagsToSnapshots;
            return this;
        }

        public final OpenZFSOriginSnapshotConfiguration.Builder getOriginSnapshot() {
            return this.originSnapshot != null ? this.originSnapshot.toBuilder() : null;
        }

        public final void setOriginSnapshot(OpenZFSOriginSnapshotConfiguration.BuilderImpl originSnapshot) {
            this.originSnapshot = originSnapshot != null ? originSnapshot.build() : null;
        }

        @Override
        public final Builder originSnapshot(OpenZFSOriginSnapshotConfiguration originSnapshot) {
            this.originSnapshot = originSnapshot;
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final List<OpenZFSNfsExport.Builder> getNfsExports() {
            List<OpenZFSNfsExport.Builder> result = OpenZFSNfsExportsCopier.copyToBuilder(this.nfsExports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNfsExports(Collection<OpenZFSNfsExport.BuilderImpl> nfsExports) {
            this.nfsExports = OpenZFSNfsExportsCopier.copyFromBuilder(nfsExports);
        }

        @Override
        public final Builder nfsExports(Collection<OpenZFSNfsExport> nfsExports) {
            this.nfsExports = OpenZFSNfsExportsCopier.copy(nfsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsExports(OpenZFSNfsExport ... nfsExports) {
            this.nfsExports(Arrays.asList(nfsExports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsExports(Consumer<OpenZFSNfsExport.Builder> ... nfsExports) {
            this.nfsExports(Stream.of(nfsExports).map(c -> (OpenZFSNfsExport)((OpenZFSNfsExport.Builder)OpenZFSNfsExport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OpenZFSUserOrGroupQuota.Builder> getUserAndGroupQuotas() {
            List<OpenZFSUserOrGroupQuota.Builder> result = OpenZFSUserAndGroupQuotasCopier.copyToBuilder(this.userAndGroupQuotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota.BuilderImpl> userAndGroupQuotas) {
            this.userAndGroupQuotas = OpenZFSUserAndGroupQuotasCopier.copyFromBuilder(userAndGroupQuotas);
        }

        @Override
        public final Builder userAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
            this.userAndGroupQuotas = OpenZFSUserAndGroupQuotasCopier.copy(userAndGroupQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAndGroupQuotas(OpenZFSUserOrGroupQuota ... userAndGroupQuotas) {
            this.userAndGroupQuotas(Arrays.asList(userAndGroupQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAndGroupQuotas(Consumer<OpenZFSUserOrGroupQuota.Builder> ... userAndGroupQuotas) {
            this.userAndGroupQuotas(Stream.of(userAndGroupQuotas).map(c -> (OpenZFSUserOrGroupQuota)((OpenZFSUserOrGroupQuota.Builder)OpenZFSUserOrGroupQuota.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRestoreToSnapshot() {
            return this.restoreToSnapshot;
        }

        public final void setRestoreToSnapshot(String restoreToSnapshot) {
            this.restoreToSnapshot = restoreToSnapshot;
        }

        @Override
        public final Builder restoreToSnapshot(String restoreToSnapshot) {
            this.restoreToSnapshot = restoreToSnapshot;
            return this;
        }

        public final Boolean getDeleteIntermediateSnaphots() {
            return this.deleteIntermediateSnaphots;
        }

        public final void setDeleteIntermediateSnaphots(Boolean deleteIntermediateSnaphots) {
            this.deleteIntermediateSnaphots = deleteIntermediateSnaphots;
        }

        @Override
        public final Builder deleteIntermediateSnaphots(Boolean deleteIntermediateSnaphots) {
            this.deleteIntermediateSnaphots = deleteIntermediateSnaphots;
            return this;
        }

        public final Boolean getDeleteClonedVolumes() {
            return this.deleteClonedVolumes;
        }

        public final void setDeleteClonedVolumes(Boolean deleteClonedVolumes) {
            this.deleteClonedVolumes = deleteClonedVolumes;
        }

        @Override
        public final Builder deleteClonedVolumes(Boolean deleteClonedVolumes) {
            this.deleteClonedVolumes = deleteClonedVolumes;
            return this;
        }

        public final Boolean getDeleteIntermediateData() {
            return this.deleteIntermediateData;
        }

        public final void setDeleteIntermediateData(Boolean deleteIntermediateData) {
            this.deleteIntermediateData = deleteIntermediateData;
        }

        @Override
        public final Builder deleteIntermediateData(Boolean deleteIntermediateData) {
            this.deleteIntermediateData = deleteIntermediateData;
            return this;
        }

        public final String getSourceSnapshotARN() {
            return this.sourceSnapshotARN;
        }

        public final void setSourceSnapshotARN(String sourceSnapshotARN) {
            this.sourceSnapshotARN = sourceSnapshotARN;
        }

        @Override
        public final Builder sourceSnapshotARN(String sourceSnapshotARN) {
            this.sourceSnapshotARN = sourceSnapshotARN;
            return this;
        }

        public final String getDestinationSnapshot() {
            return this.destinationSnapshot;
        }

        public final void setDestinationSnapshot(String destinationSnapshot) {
            this.destinationSnapshot = destinationSnapshot;
        }

        @Override
        public final Builder destinationSnapshot(String destinationSnapshot) {
            this.destinationSnapshot = destinationSnapshot;
            return this;
        }

        public final String getCopyStrategy() {
            return this.copyStrategy;
        }

        public final void setCopyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
        }

        @Override
        public final Builder copyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
            return this;
        }

        @Override
        public final Builder copyStrategy(OpenZFSCopyStrategy copyStrategy) {
            this.copyStrategy(copyStrategy == null ? null : copyStrategy.toString());
            return this;
        }

        public OpenZFSVolumeConfiguration build() {
            return new OpenZFSVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenZFSVolumeConfiguration> {
        public Builder parentVolumeId(String var1);

        public Builder volumePath(String var1);

        public Builder storageCapacityReservationGiB(Integer var1);

        public Builder storageCapacityQuotaGiB(Integer var1);

        public Builder recordSizeKiB(Integer var1);

        public Builder dataCompressionType(String var1);

        public Builder dataCompressionType(OpenZFSDataCompressionType var1);

        public Builder copyTagsToSnapshots(Boolean var1);

        public Builder originSnapshot(OpenZFSOriginSnapshotConfiguration var1);

        default public Builder originSnapshot(Consumer<OpenZFSOriginSnapshotConfiguration.Builder> originSnapshot) {
            return this.originSnapshot((OpenZFSOriginSnapshotConfiguration)((OpenZFSOriginSnapshotConfiguration.Builder)OpenZFSOriginSnapshotConfiguration.builder().applyMutation(originSnapshot)).build());
        }

        public Builder readOnly(Boolean var1);

        public Builder nfsExports(Collection<OpenZFSNfsExport> var1);

        public Builder nfsExports(OpenZFSNfsExport ... var1);

        public Builder nfsExports(Consumer<OpenZFSNfsExport.Builder> ... var1);

        public Builder userAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> var1);

        public Builder userAndGroupQuotas(OpenZFSUserOrGroupQuota ... var1);

        public Builder userAndGroupQuotas(Consumer<OpenZFSUserOrGroupQuota.Builder> ... var1);

        public Builder restoreToSnapshot(String var1);

        public Builder deleteIntermediateSnaphots(Boolean var1);

        public Builder deleteClonedVolumes(Boolean var1);

        public Builder deleteIntermediateData(Boolean var1);

        public Builder sourceSnapshotARN(String var1);

        public Builder destinationSnapshot(String var1);

        public Builder copyStrategy(String var1);

        public Builder copyStrategy(OpenZFSCopyStrategy var1);
    }
}

