/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify changes to the ONTAP configuration for the volume you are updating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOntapVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateOntapVolumeConfiguration.Builder, UpdateOntapVolumeConfiguration> {
    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JunctionPath").getter(getter(UpdateOntapVolumeConfiguration::junctionPath))
            .setter(setter(Builder::junctionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()).build();

    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityStyle").getter(getter(UpdateOntapVolumeConfiguration::securityStyleAsString))
            .setter(setter(Builder::securityStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()).build();

    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMegabytes").getter(getter(UpdateOntapVolumeConfiguration::sizeInMegabytes))
            .setter(setter(Builder::sizeInMegabytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()).build();

    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEfficiencyEnabled").getter(getter(UpdateOntapVolumeConfiguration::storageEfficiencyEnabled))
            .setter(setter(Builder::storageEfficiencyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build())
            .build();

    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField
            .<TieringPolicy> builder(MarshallingType.SDK_POJO).memberName("TieringPolicy")
            .getter(getter(UpdateOntapVolumeConfiguration::tieringPolicy)).setter(setter(Builder::tieringPolicy))
            .constructor(TieringPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()).build();

    private static final SdkField<String> SNAPSHOT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotPolicy").getter(getter(UpdateOntapVolumeConfiguration::snapshotPolicy))
            .setter(setter(Builder::snapshotPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotPolicy").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(UpdateOntapVolumeConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUNCTION_PATH_FIELD,
            SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD, STORAGE_EFFICIENCY_ENABLED_FIELD, TIERING_POLICY_FIELD,
            SNAPSHOT_POLICY_FIELD, COPY_TAGS_TO_BACKUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String junctionPath;

    private final String securityStyle;

    private final Integer sizeInMegabytes;

    private final Boolean storageEfficiencyEnabled;

    private final TieringPolicy tieringPolicy;

    private final String snapshotPolicy;

    private final Boolean copyTagsToBackups;

    private UpdateOntapVolumeConfiguration(BuilderImpl builder) {
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.tieringPolicy = builder.tieringPolicy;
        this.snapshotPolicy = builder.snapshotPolicy;
        this.copyTagsToBackups = builder.copyTagsToBackups;
    }

    /**
     * <p>
     * Specifies the location in the SVM's namespace where the volume is mounted. The <code>JunctionPath</code> must
     * have a leading forward slash, such as <code>/vol3</code>.
     * </p>
     * 
     * @return Specifies the location in the SVM's namespace where the volume is mounted. The <code>JunctionPath</code>
     *         must have a leading forward slash, such as <code>/vol3</code>.
     */
    public final String junctionPath() {
        return junctionPath;
    }

    /**
     * <p>
     * The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or <code>MIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or
     *         <code>MIXED</code>.
     * @see SecurityStyle
     */
    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(securityStyle);
    }

    /**
     * <p>
     * The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or <code>MIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or
     *         <code>MIXED</code>.
     * @see SecurityStyle
     */
    public final String securityStyleAsString() {
        return securityStyle;
    }

    /**
     * <p>
     * Specifies the size of the volume in megabytes.
     * </p>
     * 
     * @return Specifies the size of the volume in megabytes.
     */
    public final Integer sizeInMegabytes() {
        return sizeInMegabytes;
    }

    /**
     * <p>
     * Default is <code>false</code>. Set to true to enable the deduplication, compression, and compaction storage
     * efficiency features on the volume.
     * </p>
     * 
     * @return Default is <code>false</code>. Set to true to enable the deduplication, compression, and compaction
     *         storage efficiency features on the volume.
     */
    public final Boolean storageEfficiencyEnabled() {
        return storageEfficiencyEnabled;
    }

    /**
     * <p>
     * Update the volume's data tiering policy.
     * </p>
     * 
     * @return Update the volume's data tiering policy.
     */
    public final TieringPolicy tieringPolicy() {
        return tieringPolicy;
    }

    /**
     * <p>
     * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes past the
     * hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of
     * two weekly snapshots taken every Sunday at 15 minutes after midnight.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it only
     * retains one snapshot from the weekly schedule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to prevent
     * automatic snapshots from being taken.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
     * policies</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
     * </p>
     * 
     * @return Specifies the snapshot policy for the volume. There are three built-in snapshot policies:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes
     *         past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after
     *         midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it
     *         only retains one snapshot from the weekly schedule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to
     *         prevent automatic snapshots from being taken.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
     *         policies</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
     */
    public final String snapshotPolicy() {
        return snapshotPolicy;
    }

    /**
     * <p>
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false.
     * If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the
     * user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are
     * copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from
     * the volume, regardless of this value.
     * </p>
     * 
     * @return A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to
     *         false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated
     *         backups where the user doesn't specify tags. If this value is true, and you specify one or more tags,
     *         only the specified tags are copied to backups. If you specify one or more tags when creating a
     *         user-initiated backup, no tags are copied from the volume, regardless of this value.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(tieringPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOntapVolumeConfiguration)) {
            return false;
        }
        UpdateOntapVolumeConfiguration other = (UpdateOntapVolumeConfiguration) obj;
        return Objects.equals(junctionPath(), other.junctionPath())
                && Objects.equals(securityStyleAsString(), other.securityStyleAsString())
                && Objects.equals(sizeInMegabytes(), other.sizeInMegabytes())
                && Objects.equals(storageEfficiencyEnabled(), other.storageEfficiencyEnabled())
                && Objects.equals(tieringPolicy(), other.tieringPolicy())
                && Objects.equals(snapshotPolicy(), other.snapshotPolicy())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOntapVolumeConfiguration").add("JunctionPath", junctionPath())
                .add("SecurityStyle", securityStyleAsString()).add("SizeInMegabytes", sizeInMegabytes())
                .add("StorageEfficiencyEnabled", storageEfficiencyEnabled()).add("TieringPolicy", tieringPolicy())
                .add("SnapshotPolicy", snapshotPolicy()).add("CopyTagsToBackups", copyTagsToBackups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JunctionPath":
            return Optional.ofNullable(clazz.cast(junctionPath()));
        case "SecurityStyle":
            return Optional.ofNullable(clazz.cast(securityStyleAsString()));
        case "SizeInMegabytes":
            return Optional.ofNullable(clazz.cast(sizeInMegabytes()));
        case "StorageEfficiencyEnabled":
            return Optional.ofNullable(clazz.cast(storageEfficiencyEnabled()));
        case "TieringPolicy":
            return Optional.ofNullable(clazz.cast(tieringPolicy()));
        case "SnapshotPolicy":
            return Optional.ofNullable(clazz.cast(snapshotPolicy()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOntapVolumeConfiguration, T> g) {
        return obj -> g.apply((UpdateOntapVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateOntapVolumeConfiguration> {
        /**
         * <p>
         * Specifies the location in the SVM's namespace where the volume is mounted. The <code>JunctionPath</code> must
         * have a leading forward slash, such as <code>/vol3</code>.
         * </p>
         * 
         * @param junctionPath
         *        Specifies the location in the SVM's namespace where the volume is mounted. The
         *        <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder junctionPath(String junctionPath);

        /**
         * <p>
         * The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or <code>MIXED</code>.
         * </p>
         * 
         * @param securityStyle
         *        The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or
         *        <code>MIXED</code>.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(String securityStyle);

        /**
         * <p>
         * The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or <code>MIXED</code>.
         * </p>
         * 
         * @param securityStyle
         *        The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or
         *        <code>MIXED</code>.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(SecurityStyle securityStyle);

        /**
         * <p>
         * Specifies the size of the volume in megabytes.
         * </p>
         * 
         * @param sizeInMegabytes
         *        Specifies the size of the volume in megabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMegabytes(Integer sizeInMegabytes);

        /**
         * <p>
         * Default is <code>false</code>. Set to true to enable the deduplication, compression, and compaction storage
         * efficiency features on the volume.
         * </p>
         * 
         * @param storageEfficiencyEnabled
         *        Default is <code>false</code>. Set to true to enable the deduplication, compression, and compaction
         *        storage efficiency features on the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled);

        /**
         * <p>
         * Update the volume's data tiering policy.
         * </p>
         * 
         * @param tieringPolicy
         *        Update the volume's data tiering policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringPolicy(TieringPolicy tieringPolicy);

        /**
         * <p>
         * Update the volume's data tiering policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link TieringPolicy.Builder} avoiding the need
         * to create one manually via {@link TieringPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #tieringPolicy(TieringPolicy)}.
         * 
         * @param tieringPolicy
         *        a consumer that will call methods on {@link TieringPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringPolicy(TieringPolicy)
         */
        default Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return tieringPolicy(TieringPolicy.builder().applyMutation(tieringPolicy).build());
        }

        /**
         * <p>
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes past
         * the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A
         * maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it only
         * retains one snapshot from the weekly schedule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to prevent
         * automatic snapshots from being taken.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
         * policies</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
         * </p>
         * 
         * @param snapshotPolicy
         *        Specifies the snapshot policy for the volume. There are three built-in snapshot policies:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes
         *        past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after
         *        midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that
         *        it only retains one snapshot from the weekly schedule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to
         *        prevent automatic snapshots from being taken.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies"
         *        >Snapshot policies</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotPolicy(String snapshotPolicy);

        /**
         * <p>
         * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to
         * false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups
         * where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the
         * specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup,
         * no tags are copied from the volume, regardless of this value.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults
         *        to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated
         *        backups where the user doesn't specify tags. If this value is true, and you specify one or more tags,
         *        only the specified tags are copied to backups. If you specify one or more tags when creating a
         *        user-initiated backup, no tags are copied from the volume, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);
    }

    static final class BuilderImpl implements Builder {
        private String junctionPath;

        private String securityStyle;

        private Integer sizeInMegabytes;

        private Boolean storageEfficiencyEnabled;

        private TieringPolicy tieringPolicy;

        private String snapshotPolicy;

        private Boolean copyTagsToBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOntapVolumeConfiguration model) {
            junctionPath(model.junctionPath);
            securityStyle(model.securityStyle);
            sizeInMegabytes(model.sizeInMegabytes);
            storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            tieringPolicy(model.tieringPolicy);
            snapshotPolicy(model.snapshotPolicy);
            copyTagsToBackups(model.copyTagsToBackups);
        }

        public final String getJunctionPath() {
            return junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return tieringPolicy != null ? tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public final String getSnapshotPolicy() {
            return snapshotPolicy;
        }

        public final void setSnapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
        }

        @Override
        public final Builder snapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        @Override
        public UpdateOntapVolumeConfiguration build() {
            return new UpdateOntapVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
