/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse;

public class DescribeVolumesPublisher
implements SdkPublisher<DescribeVolumesResponse> {
    private final FSxAsyncClient client;
    private final DescribeVolumesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVolumesPublisher(FSxAsyncClient client, DescribeVolumesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVolumesPublisher(FSxAsyncClient client, DescribeVolumesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVolumesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVolumesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeVolumesResponseFetcher
    implements AsyncPageFetcher<DescribeVolumesResponse> {
        private DescribeVolumesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVolumesResponse> nextPage(DescribeVolumesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesPublisher.this.client.describeVolumes(DescribeVolumesPublisher.this.firstRequest);
            }
            return DescribeVolumesPublisher.this.client.describeVolumes((DescribeVolumesRequest)((Object)DescribeVolumesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

