/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse;

public class DescribeDataRepositoryTasksIterable
implements SdkIterable<DescribeDataRepositoryTasksResponse> {
    private final FSxClient client;
    private final DescribeDataRepositoryTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataRepositoryTasksIterable(FSxClient client, DescribeDataRepositoryTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataRepositoryTasksResponseFetcher();
    }

    public Iterator<DescribeDataRepositoryTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeDataRepositoryTasksResponseFetcher
    implements SyncPageFetcher<DescribeDataRepositoryTasksResponse> {
        private DescribeDataRepositoryTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataRepositoryTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDataRepositoryTasksResponse nextPage(DescribeDataRepositoryTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataRepositoryTasksIterable.this.client.describeDataRepositoryTasks(DescribeDataRepositoryTasksIterable.this.firstRequest);
            }
            return DescribeDataRepositoryTasksIterable.this.client.describeDataRepositoryTasks((DescribeDataRepositoryTasksRequest)((Object)DescribeDataRepositoryTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

