/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.AutoImportPolicyType;
import software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails;
import software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataRepositoryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataRepositoryConfiguration> {
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DataRepositoryConfiguration.getter(DataRepositoryConfiguration::lifecycleAsString)).setter(DataRepositoryConfiguration.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> IMPORT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportPath").getter(DataRepositoryConfiguration.getter(DataRepositoryConfiguration::importPath)).setter(DataRepositoryConfiguration.setter(Builder::importPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportPath").build()}).build();
    private static final SdkField<String> EXPORT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportPath").getter(DataRepositoryConfiguration.getter(DataRepositoryConfiguration::exportPath)).setter(DataRepositoryConfiguration.setter(Builder::exportPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportPath").build()}).build();
    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ImportedFileChunkSize").getter(DataRepositoryConfiguration.getter(DataRepositoryConfiguration::importedFileChunkSize)).setter(DataRepositoryConfiguration.setter(Builder::importedFileChunkSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build()}).build();
    private static final SdkField<String> AUTO_IMPORT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoImportPolicy").getter(DataRepositoryConfiguration.getter(DataRepositoryConfiguration::autoImportPolicyAsString)).setter(DataRepositoryConfiguration.setter(Builder::autoImportPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImportPolicy").build()}).build();
    private static final SdkField<DataRepositoryFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(DataRepositoryConfiguration.getter(DataRepositoryConfiguration::failureDetails)).setter(DataRepositoryConfiguration.setter(Builder::failureDetails)).constructor(DataRepositoryFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_FIELD, IMPORT_PATH_FIELD, EXPORT_PATH_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD, AUTO_IMPORT_POLICY_FIELD, FAILURE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lifecycle;
    private final String importPath;
    private final String exportPath;
    private final Integer importedFileChunkSize;
    private final String autoImportPolicy;
    private final DataRepositoryFailureDetails failureDetails;

    private DataRepositoryConfiguration(BuilderImpl builder) {
        this.lifecycle = builder.lifecycle;
        this.importPath = builder.importPath;
        this.exportPath = builder.exportPath;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.autoImportPolicy = builder.autoImportPolicy;
        this.failureDetails = builder.failureDetails;
    }

    public final DataRepositoryLifecycle lifecycle() {
        return DataRepositoryLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final String importPath() {
        return this.importPath;
    }

    public final String exportPath() {
        return this.exportPath;
    }

    public final Integer importedFileChunkSize() {
        return this.importedFileChunkSize;
    }

    public final AutoImportPolicyType autoImportPolicy() {
        return AutoImportPolicyType.fromValue(this.autoImportPolicy);
    }

    public final String autoImportPolicyAsString() {
        return this.autoImportPolicy;
    }

    public final DataRepositoryFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImportPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryConfiguration)) {
            return false;
        }
        DataRepositoryConfiguration other = (DataRepositoryConfiguration)obj;
        return Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.importPath(), other.importPath()) && Objects.equals(this.exportPath(), other.exportPath()) && Objects.equals(this.importedFileChunkSize(), other.importedFileChunkSize()) && Objects.equals(this.autoImportPolicyAsString(), other.autoImportPolicyAsString()) && Objects.equals(this.failureDetails(), other.failureDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DataRepositoryConfiguration").add("Lifecycle", (Object)this.lifecycleAsString()).add("ImportPath", (Object)this.importPath()).add("ExportPath", (Object)this.exportPath()).add("ImportedFileChunkSize", (Object)this.importedFileChunkSize()).add("AutoImportPolicy", (Object)this.autoImportPolicyAsString()).add("FailureDetails", (Object)this.failureDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "ImportPath": {
                return Optional.ofNullable(clazz.cast(this.importPath()));
            }
            case "ExportPath": {
                return Optional.ofNullable(clazz.cast(this.exportPath()));
            }
            case "ImportedFileChunkSize": {
                return Optional.ofNullable(clazz.cast(this.importedFileChunkSize()));
            }
            case "AutoImportPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoImportPolicyAsString()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataRepositoryConfiguration, T> g) {
        return obj -> g.apply((DataRepositoryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycle;
        private String importPath;
        private String exportPath;
        private Integer importedFileChunkSize;
        private String autoImportPolicy;
        private DataRepositoryFailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRepositoryConfiguration model) {
            this.lifecycle(model.lifecycle);
            this.importPath(model.importPath);
            this.exportPath(model.exportPath);
            this.importedFileChunkSize(model.importedFileChunkSize);
            this.autoImportPolicy(model.autoImportPolicy);
            this.failureDetails(model.failureDetails);
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(DataRepositoryLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getImportPath() {
            return this.importPath;
        }

        public final void setImportPath(String importPath) {
            this.importPath = importPath;
        }

        @Override
        public final Builder importPath(String importPath) {
            this.importPath = importPath;
            return this;
        }

        public final String getExportPath() {
            return this.exportPath;
        }

        public final void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        @Override
        public final Builder exportPath(String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        public final Integer getImportedFileChunkSize() {
            return this.importedFileChunkSize;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        @Override
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final String getAutoImportPolicy() {
            return this.autoImportPolicy;
        }

        public final void setAutoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
        }

        @Override
        public final Builder autoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        @Override
        public final Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy) {
            this.autoImportPolicy(autoImportPolicy == null ? null : autoImportPolicy.toString());
            return this;
        }

        public final DataRepositoryFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(DataRepositoryFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(DataRepositoryFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public DataRepositoryConfiguration build() {
            return new DataRepositoryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataRepositoryConfiguration> {
        public Builder lifecycle(String var1);

        public Builder lifecycle(DataRepositoryLifecycle var1);

        public Builder importPath(String var1);

        public Builder exportPath(String var1);

        public Builder importedFileChunkSize(Integer var1);

        public Builder autoImportPolicy(String var1);

        public Builder autoImportPolicy(AutoImportPolicyType var1);

        public Builder failureDetails(DataRepositoryFailureDetails var1);

        default public Builder failureDetails(Consumer<DataRepositoryFailureDetails.Builder> failureDetails) {
            return this.failureDetails((DataRepositoryFailureDetails)((DataRepositoryFailureDetails.Builder)DataRepositoryFailureDetails.builder().applyMutation(failureDetails)).build());
        }
    }
}

