/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataRepositoryTaskType {
    EXPORT_TO_REPOSITORY("EXPORT_TO_REPOSITORY"),
    IMPORT_METADATA_FROM_REPOSITORY("IMPORT_METADATA_FROM_REPOSITORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataRepositoryTaskType> VALUE_MAP;
    private final String value;

    private DataRepositoryTaskType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataRepositoryTaskType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataRepositoryTaskType> knownValues() {
        EnumSet<DataRepositoryTaskType> knownValues = EnumSet.allOf(DataRepositoryTaskType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataRepositoryTaskType.class, DataRepositoryTaskType::toString);
    }
}

