/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.ActiveDirectoryErrorException;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.BackupBeingCopiedException;
import software.amazon.awssdk.services.fsx.model.BackupInProgressException;
import software.amazon.awssdk.services.fsx.model.BackupNotFoundException;
import software.amazon.awssdk.services.fsx.model.BackupRestoringException;
import software.amazon.awssdk.services.fsx.model.BadRequestException;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CopyBackupRequest;
import software.amazon.awssdk.services.fsx.model.CopyBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest;
import software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest;
import software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse;
import software.amazon.awssdk.services.fsx.model.CreateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.CreateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociationNotFoundException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskEndedException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskExecutingException;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskNotFoundException;
import software.amazon.awssdk.services.fsx.model.DeleteBackupRequest;
import software.amazon.awssdk.services.fsx.model.DeleteBackupResponse;
import software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesResponse;
import software.amazon.awssdk.services.fsx.model.FSxException;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.fsx.model.IncompatibleParameterErrorException;
import software.amazon.awssdk.services.fsx.model.IncompatibleRegionForMultiAzException;
import software.amazon.awssdk.services.fsx.model.InternalServerErrorException;
import software.amazon.awssdk.services.fsx.model.InvalidDataRepositoryTypeException;
import software.amazon.awssdk.services.fsx.model.InvalidDestinationKmsKeyException;
import software.amazon.awssdk.services.fsx.model.InvalidExportPathException;
import software.amazon.awssdk.services.fsx.model.InvalidImportPathException;
import software.amazon.awssdk.services.fsx.model.InvalidNetworkSettingsException;
import software.amazon.awssdk.services.fsx.model.InvalidPerUnitStorageThroughputException;
import software.amazon.awssdk.services.fsx.model.InvalidRegionException;
import software.amazon.awssdk.services.fsx.model.InvalidSourceKmsKeyException;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fsx.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fsx.model.MissingFileSystemConfigurationException;
import software.amazon.awssdk.services.fsx.model.MissingVolumeConfigurationException;
import software.amazon.awssdk.services.fsx.model.NotServiceResourceErrorException;
import software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest;
import software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse;
import software.amazon.awssdk.services.fsx.model.ResourceDoesNotSupportTaggingException;
import software.amazon.awssdk.services.fsx.model.ResourceNotFoundException;
import software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.fsx.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.fsx.model.SourceBackupUnavailableException;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineNotFoundException;
import software.amazon.awssdk.services.fsx.model.TagResourceRequest;
import software.amazon.awssdk.services.fsx.model.TagResourceResponse;
import software.amazon.awssdk.services.fsx.model.UnsupportedOperationException;
import software.amazon.awssdk.services.fsx.model.UntagResourceRequest;
import software.amazon.awssdk.services.fsx.model.UntagResourceResponse;
import software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest;
import software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest;
import software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse;
import software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest;
import software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse;
import software.amazon.awssdk.services.fsx.model.VolumeNotFoundException;
import software.amazon.awssdk.services.fsx.paginators.DescribeBackupsIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryAssociationsIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeDataRepositoryTasksIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemAliasesIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeFileSystemsIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeSnapshotsIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeStorageVirtualMachinesIterable;
import software.amazon.awssdk.services.fsx.paginators.DescribeVolumesIterable;
import software.amazon.awssdk.services.fsx.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.fsx.transform.AssociateFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CancelDataRepositoryTaskRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CopyBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateDataRepositoryTaskRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileSystemFromBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateVolumeFromBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeDataRepositoryAssociationsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeDataRepositoryTasksRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeFileSystemsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeStorageVirtualMachinesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.DisassociateFileSystemAliasesRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.ReleaseFileSystemNfsV3LocksRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.RestoreVolumeFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateDataRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateStorageVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.fsx.transform.UpdateVolumeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultFSxClient
implements FSxClient {
    private static final Logger log = Logger.loggerFor(DefaultFSxClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFSxClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "fsx";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateFileSystemAliasesResponse associateFileSystemAliases(AssociateFileSystemAliasesRequest associateFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFileSystemAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, associateFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFileSystemAliases");
            AssociateFileSystemAliasesResponse associateFileSystemAliasesResponse = (AssociateFileSystemAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFileSystemAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateFileSystemAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateFileSystemAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$associateFileSystemAliases$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelDataRepositoryTaskResponse cancelDataRepositoryTask(CancelDataRepositoryTaskRequest cancelDataRepositoryTaskRequest) throws BadRequestException, UnsupportedOperationException, DataRepositoryTaskNotFoundException, DataRepositoryTaskEndedException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDataRepositoryTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, cancelDataRepositoryTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDataRepositoryTask");
            CancelDataRepositoryTaskResponse cancelDataRepositoryTaskResponse = (CancelDataRepositoryTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDataRepositoryTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelDataRepositoryTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelDataRepositoryTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelDataRepositoryTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$cancelDataRepositoryTask$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyBackupResponse copyBackup(CopyBackupRequest copyBackupRequest) throws BadRequestException, BackupNotFoundException, ServiceLimitExceededException, UnsupportedOperationException, IncompatibleParameterErrorException, InternalServerErrorException, InvalidSourceKmsKeyException, InvalidDestinationKmsKeyException, InvalidRegionException, SourceBackupUnavailableException, IncompatibleRegionForMultiAzException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, copyBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyBackup");
            CopyBackupResponse copyBackupResponse = (CopyBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copyBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$copyBackup$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws BadRequestException, UnsupportedOperationException, FileSystemNotFoundException, VolumeNotFoundException, BackupInProgressException, IncompatibleParameterErrorException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            CreateBackupResponse createBackupResponse = (CreateBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createBackup$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataRepositoryAssociationResponse createDataRepositoryAssociation(CreateDataRepositoryAssociationRequest createDataRepositoryAssociationRequest) throws BadRequestException, UnsupportedOperationException, FileSystemNotFoundException, IncompatibleParameterErrorException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRepositoryAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRepositoryAssociation");
            CreateDataRepositoryAssociationResponse createDataRepositoryAssociationResponse = (CreateDataRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRepositoryAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createDataRepositoryAssociation$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataRepositoryTaskResponse createDataRepositoryTask(CreateDataRepositoryTaskRequest createDataRepositoryTaskRequest) throws BadRequestException, UnsupportedOperationException, FileSystemNotFoundException, IncompatibleParameterErrorException, ServiceLimitExceededException, InternalServerErrorException, DataRepositoryTaskExecutingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataRepositoryTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createDataRepositoryTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataRepositoryTask");
            CreateDataRepositoryTaskResponse createDataRepositoryTaskResponse = (CreateDataRepositoryTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataRepositoryTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataRepositoryTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataRepositoryTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataRepositoryTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createDataRepositoryTask$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, ActiveDirectoryErrorException, IncompatibleParameterErrorException, InvalidImportPathException, InvalidExportPathException, InvalidNetworkSettingsException, InvalidPerUnitStorageThroughputException, ServiceLimitExceededException, InternalServerErrorException, MissingFileSystemConfigurationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystem");
            CreateFileSystemResponse createFileSystemResponse = (CreateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createFileSystem$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemFromBackupResponse createFileSystemFromBackup(CreateFileSystemFromBackupRequest createFileSystemFromBackupRequest) throws BadRequestException, ActiveDirectoryErrorException, IncompatibleParameterErrorException, InvalidNetworkSettingsException, InvalidPerUnitStorageThroughputException, ServiceLimitExceededException, BackupNotFoundException, InternalServerErrorException, MissingFileSystemConfigurationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemFromBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createFileSystemFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystemFromBackup");
            CreateFileSystemFromBackupResponse createFileSystemFromBackupResponse = (CreateFileSystemFromBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystemFromBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFileSystemFromBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileSystemFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileSystemFromBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createFileSystemFromBackup$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws BadRequestException, VolumeNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createSnapshot$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStorageVirtualMachineResponse createStorageVirtualMachine(CreateStorageVirtualMachineRequest createStorageVirtualMachineRequest) throws ActiveDirectoryErrorException, BadRequestException, FileSystemNotFoundException, IncompatibleParameterErrorException, InternalServerErrorException, ServiceLimitExceededException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStorageVirtualMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStorageVirtualMachine");
            CreateStorageVirtualMachineResponse createStorageVirtualMachineResponse = (CreateStorageVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStorageVirtualMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStorageVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStorageVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createStorageVirtualMachine$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVolumeResponse createVolume(CreateVolumeRequest createVolumeRequest) throws BadRequestException, FileSystemNotFoundException, IncompatibleParameterErrorException, InternalServerErrorException, MissingVolumeConfigurationException, ServiceLimitExceededException, StorageVirtualMachineNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVolumeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVolume");
            CreateVolumeResponse createVolumeResponse = (CreateVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVolume").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createVolume$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVolumeFromBackupResponse createVolumeFromBackup(CreateVolumeFromBackupRequest createVolumeFromBackupRequest) throws BackupNotFoundException, BadRequestException, FileSystemNotFoundException, IncompatibleParameterErrorException, InternalServerErrorException, MissingVolumeConfigurationException, ServiceLimitExceededException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVolumeFromBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, createVolumeFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVolumeFromBackup");
            CreateVolumeFromBackupResponse createVolumeFromBackupResponse = (CreateVolumeFromBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVolumeFromBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVolumeFromBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVolumeFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVolumeFromBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$createVolumeFromBackup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws BadRequestException, BackupInProgressException, BackupNotFoundException, BackupRestoringException, IncompatibleParameterErrorException, InternalServerErrorException, BackupBeingCopiedException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            DeleteBackupResponse deleteBackupResponse = (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteBackup$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataRepositoryAssociationResponse deleteDataRepositoryAssociation(DeleteDataRepositoryAssociationRequest deleteDataRepositoryAssociationRequest) throws BadRequestException, IncompatibleParameterErrorException, DataRepositoryAssociationNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataRepositoryAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, deleteDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataRepositoryAssociation");
            DeleteDataRepositoryAssociationResponse deleteDataRepositoryAssociationResponse = (DeleteDataRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataRepositoryAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteDataRepositoryAssociation$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, IncompatibleParameterErrorException, FileSystemNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, deleteFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystem");
            DeleteFileSystemResponse deleteFileSystemResponse = (DeleteFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteFileSystem$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws BadRequestException, InternalServerErrorException, SnapshotNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteSnapshot$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStorageVirtualMachineResponse deleteStorageVirtualMachine(DeleteStorageVirtualMachineRequest deleteStorageVirtualMachineRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStorageVirtualMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, deleteStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageVirtualMachine");
            DeleteStorageVirtualMachineResponse deleteStorageVirtualMachineResponse = (DeleteStorageVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageVirtualMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStorageVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStorageVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteStorageVirtualMachine$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVolumeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, deleteVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVolume");
            DeleteVolumeResponse deleteVolumeResponse = (DeleteVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVolume").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$deleteVolume$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws BadRequestException, FileSystemNotFoundException, VolumeNotFoundException, BackupNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackups");
            DescribeBackupsResponse describeBackupsResponse = (DescribeBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeBackups$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeBackupsIterable describeBackupsPaginator(DescribeBackupsRequest describeBackupsRequest) throws BadRequestException, FileSystemNotFoundException, VolumeNotFoundException, BackupNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeBackupsIterable(this, this.applyPaginatorUserAgent(describeBackupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataRepositoryAssociationsResponse describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsRequest describeDataRepositoryAssociationsRequest) throws BadRequestException, FileSystemNotFoundException, DataRepositoryAssociationNotFoundException, InvalidDataRepositoryTypeException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataRepositoryAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeDataRepositoryAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataRepositoryAssociations");
            DescribeDataRepositoryAssociationsResponse describeDataRepositoryAssociationsResponse = (DescribeDataRepositoryAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataRepositoryAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDataRepositoryAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataRepositoryAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataRepositoryAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeDataRepositoryAssociations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDataRepositoryAssociationsIterable describeDataRepositoryAssociationsPaginator(DescribeDataRepositoryAssociationsRequest describeDataRepositoryAssociationsRequest) throws BadRequestException, FileSystemNotFoundException, DataRepositoryAssociationNotFoundException, InvalidDataRepositoryTypeException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeDataRepositoryAssociationsIterable(this, this.applyPaginatorUserAgent(describeDataRepositoryAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataRepositoryTasksResponse describeDataRepositoryTasks(DescribeDataRepositoryTasksRequest describeDataRepositoryTasksRequest) throws BadRequestException, FileSystemNotFoundException, DataRepositoryTaskNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataRepositoryTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeDataRepositoryTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataRepositoryTasks");
            DescribeDataRepositoryTasksResponse describeDataRepositoryTasksResponse = (DescribeDataRepositoryTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataRepositoryTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDataRepositoryTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataRepositoryTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataRepositoryTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeDataRepositoryTasks$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDataRepositoryTasksIterable describeDataRepositoryTasksPaginator(DescribeDataRepositoryTasksRequest describeDataRepositoryTasksRequest) throws BadRequestException, FileSystemNotFoundException, DataRepositoryTaskNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeDataRepositoryTasksIterable(this, this.applyPaginatorUserAgent(describeDataRepositoryTasksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemAliasesResponse describeFileSystemAliases(DescribeFileSystemAliasesRequest describeFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystemAliases");
            DescribeFileSystemAliasesResponse describeFileSystemAliasesResponse = (DescribeFileSystemAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystemAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFileSystemAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeFileSystemAliases$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeFileSystemAliasesIterable describeFileSystemAliasesPaginator(DescribeFileSystemAliasesRequest describeFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeFileSystemAliasesIterable(this, this.applyPaginatorUserAgent(describeFileSystemAliasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeFileSystemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystems");
            DescribeFileSystemsResponse describeFileSystemsResponse = (DescribeFileSystemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystems").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFileSystemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeFileSystems$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeFileSystemsIterable describeFileSystemsPaginator(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeFileSystemsIterable(this, this.applyPaginatorUserAgent(describeFileSystemsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws BadRequestException, InternalServerErrorException, SnapshotNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            DescribeSnapshotsResponse describeSnapshotsResponse = (DescribeSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeSnapshots$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeSnapshotsIterable describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) throws BadRequestException, InternalServerErrorException, SnapshotNotFoundException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeSnapshotsIterable(this, this.applyPaginatorUserAgent(describeSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStorageVirtualMachinesResponse describeStorageVirtualMachines(DescribeStorageVirtualMachinesRequest describeStorageVirtualMachinesRequest) throws BadRequestException, InternalServerErrorException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStorageVirtualMachinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeStorageVirtualMachinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStorageVirtualMachines");
            DescribeStorageVirtualMachinesResponse describeStorageVirtualMachinesResponse = (DescribeStorageVirtualMachinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorageVirtualMachines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStorageVirtualMachinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStorageVirtualMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStorageVirtualMachinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeStorageVirtualMachines$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeStorageVirtualMachinesIterable describeStorageVirtualMachinesPaginator(DescribeStorageVirtualMachinesRequest describeStorageVirtualMachinesRequest) throws BadRequestException, InternalServerErrorException, StorageVirtualMachineNotFoundException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeStorageVirtualMachinesIterable(this, this.applyPaginatorUserAgent(describeStorageVirtualMachinesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVolumesResponse describeVolumes(DescribeVolumesRequest describeVolumesRequest) throws BadRequestException, InternalServerErrorException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVolumesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, describeVolumesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVolumes");
            DescribeVolumesResponse describeVolumesResponse = (DescribeVolumesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVolumes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVolumesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVolumesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVolumesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$describeVolumes$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeVolumesIterable describeVolumesPaginator(DescribeVolumesRequest describeVolumesRequest) throws BadRequestException, InternalServerErrorException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        return new DescribeVolumesIterable(this, this.applyPaginatorUserAgent(describeVolumesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateFileSystemAliasesResponse disassociateFileSystemAliases(DisassociateFileSystemAliasesRequest disassociateFileSystemAliasesRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFileSystemAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, disassociateFileSystemAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFileSystemAliases");
            DisassociateFileSystemAliasesResponse disassociateFileSystemAliasesResponse = (DisassociateFileSystemAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFileSystemAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateFileSystemAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateFileSystemAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateFileSystemAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$disassociateFileSystemAliases$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$listTagsForResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseFileSystemNfsV3LocksResponse releaseFileSystemNfsV3Locks(ReleaseFileSystemNfsV3LocksRequest releaseFileSystemNfsV3LocksRequest) throws BadRequestException, IncompatibleParameterErrorException, FileSystemNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReleaseFileSystemNfsV3LocksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, releaseFileSystemNfsV3LocksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReleaseFileSystemNfsV3Locks");
            ReleaseFileSystemNfsV3LocksResponse releaseFileSystemNfsV3LocksResponse = (ReleaseFileSystemNfsV3LocksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReleaseFileSystemNfsV3Locks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)releaseFileSystemNfsV3LocksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReleaseFileSystemNfsV3LocksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return releaseFileSystemNfsV3LocksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$releaseFileSystemNfsV3Locks$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreVolumeFromSnapshotResponse restoreVolumeFromSnapshot(RestoreVolumeFromSnapshotRequest restoreVolumeFromSnapshotRequest) throws BadRequestException, InternalServerErrorException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreVolumeFromSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, restoreVolumeFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreVolumeFromSnapshot");
            RestoreVolumeFromSnapshotResponse restoreVolumeFromSnapshotResponse = (RestoreVolumeFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreVolumeFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreVolumeFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreVolumeFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreVolumeFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$restoreVolumeFromSnapshot$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$tagResource$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, InternalServerErrorException, ResourceNotFoundException, NotServiceResourceErrorException, ResourceDoesNotSupportTaggingException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$untagResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataRepositoryAssociationResponse updateDataRepositoryAssociation(UpdateDataRepositoryAssociationRequest updateDataRepositoryAssociationRequest) throws BadRequestException, IncompatibleParameterErrorException, DataRepositoryAssociationNotFoundException, ServiceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRepositoryAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, updateDataRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataRepositoryAssociation");
            UpdateDataRepositoryAssociationResponse updateDataRepositoryAssociationResponse = (UpdateDataRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRepositoryAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateDataRepositoryAssociation$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) throws BadRequestException, UnsupportedOperationException, IncompatibleParameterErrorException, InternalServerErrorException, FileSystemNotFoundException, MissingFileSystemConfigurationException, ServiceLimitExceededException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, updateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystem");
            UpdateFileSystemResponse updateFileSystemResponse = (UpdateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateFileSystem$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws BadRequestException, SnapshotNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, updateSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSnapshot");
            UpdateSnapshotResponse updateSnapshotResponse = (UpdateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateSnapshot$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStorageVirtualMachineResponse updateStorageVirtualMachine(UpdateStorageVirtualMachineRequest updateStorageVirtualMachineRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, StorageVirtualMachineNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStorageVirtualMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, updateStorageVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStorageVirtualMachine");
            UpdateStorageVirtualMachineResponse updateStorageVirtualMachineResponse = (UpdateStorageVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStorageVirtualMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStorageVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStorageVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStorageVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateStorageVirtualMachine$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVolumeResponse updateVolume(UpdateVolumeRequest updateVolumeRequest) throws BadRequestException, IncompatibleParameterErrorException, InternalServerErrorException, MissingVolumeConfigurationException, VolumeNotFoundException, AwsServiceException, SdkClientException, FSxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVolumeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultFSxClient.resolveMetricPublishers(this.clientConfiguration, updateVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"FSx");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVolume");
            UpdateVolumeResponse updateVolumeResponse = (UpdateVolumeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVolume").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateVolumeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVolumeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultFSxClient.lambda$updateVolume$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(FSxException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidImportPath").exceptionBuilderSupplier(InvalidImportPathException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNetworkSettings").exceptionBuilderSupplier(InvalidNetworkSettingsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileSystemNotFound").exceptionBuilderSupplier(FileSystemNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataRepositoryAssociationNotFound").exceptionBuilderSupplier(DataRepositoryAssociationNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceDoesNotSupportTagging").exceptionBuilderSupplier(ResourceDoesNotSupportTaggingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataRepositoryTaskNotFound").exceptionBuilderSupplier(DataRepositoryTaskNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceBackupUnavailable").exceptionBuilderSupplier(SourceBackupUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageVirtualMachineNotFound").exceptionBuilderSupplier(StorageVirtualMachineNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupRestoring").exceptionBuilderSupplier(BackupRestoringException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupInProgress").exceptionBuilderSupplier(BackupInProgressException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidExportPath").exceptionBuilderSupplier(InvalidExportPathException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRegion").exceptionBuilderSupplier(InvalidRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingVolumeConfiguration").exceptionBuilderSupplier(MissingVolumeConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSourceKmsKey").exceptionBuilderSupplier(InvalidSourceKmsKeyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataRepositoryTaskExecuting").exceptionBuilderSupplier(DataRepositoryTaskExecutingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleRegionForMultiAZ").exceptionBuilderSupplier(IncompatibleRegionForMultiAzException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupNotFound").exceptionBuilderSupplier(BackupNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDestinationKmsKey").exceptionBuilderSupplier(InvalidDestinationKmsKeyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VolumeNotFound").exceptionBuilderSupplier(VolumeNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLimitExceeded").exceptionBuilderSupplier(ServiceLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotServiceResourceError").exceptionBuilderSupplier(NotServiceResourceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingFileSystemConfiguration").exceptionBuilderSupplier(MissingFileSystemConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupBeingCopied").exceptionBuilderSupplier(BackupBeingCopiedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleParameterError").exceptionBuilderSupplier(IncompatibleParameterErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataRepositoryTaskEnded").exceptionBuilderSupplier(DataRepositoryTaskEndedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDataRepositoryType").exceptionBuilderSupplier(InvalidDataRepositoryTypeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotNotFound").exceptionBuilderSupplier(SnapshotNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPerUnitStorageThroughput").exceptionBuilderSupplier(InvalidPerUnitStorageThroughputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActiveDirectoryError").exceptionBuilderSupplier(ActiveDirectoryErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequest").exceptionBuilderSupplier(BadRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends FSxRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.115").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((FSxRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateVolume$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStorageVirtualMachine$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSnapshot$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileSystem$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataRepositoryAssociation$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreVolumeFromSnapshot$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$releaseFileSystemNfsV3Locks$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateFileSystemAliases$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVolumes$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStorageVirtualMachines$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshots$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystems$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystemAliases$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataRepositoryTasks$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataRepositoryAssociations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackups$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVolume$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageVirtualMachine$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystem$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataRepositoryAssociation$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVolumeFromBackup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVolume$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStorageVirtualMachine$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystemFromBackup$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystem$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRepositoryTask$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataRepositoryAssociation$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyBackup$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDataRepositoryTask$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFileSystemAliases$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

