/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpenZFSDataCompressionType {
    NONE("NONE"),
    ZSTD("ZSTD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpenZFSDataCompressionType> VALUE_MAP;
    private final String value;

    private OpenZFSDataCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpenZFSDataCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpenZFSDataCompressionType> knownValues() {
        EnumSet<OpenZFSDataCompressionType> knownValues = EnumSet.allOf(OpenZFSDataCompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpenZFSDataCompressionType.class, OpenZFSDataCompressionType::toString);
    }
}

