/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelDataRepositoryTaskResponse extends FSxResponse implements
        ToCopyableBuilder<CancelDataRepositoryTaskResponse.Builder, CancelDataRepositoryTaskResponse> {
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(CancelDataRepositoryTaskResponse::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(CancelDataRepositoryTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LIFECYCLE_FIELD, TASK_ID_FIELD));

    private final String lifecycle;

    private final String taskId;

    private CancelDataRepositoryTaskResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycle = builder.lifecycle;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The lifecycle status of the data repository task, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx has not started the task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXECUTING</code> - Amazon FSx is processing the task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task
     * failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task
     * failures.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code> - FSx completed the task successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELING</code> - FSx is in process of canceling the task.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link DataRepositoryTaskLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the data repository task, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx has not started the task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXECUTING</code> - Amazon FSx is processing the task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the
     *         task failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information
     *         about task failures.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code> - FSx completed the task successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELING</code> - FSx is in process of canceling the task.
     *         </p>
     *         </li>
     * @see DataRepositoryTaskLifecycle
     */
    public final DataRepositoryTaskLifecycle lifecycle() {
        return DataRepositoryTaskLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle status of the data repository task, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx has not started the task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXECUTING</code> - Amazon FSx is processing the task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task
     * failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task
     * failures.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code> - FSx completed the task successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELING</code> - FSx is in process of canceling the task.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link DataRepositoryTaskLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the data repository task, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx has not started the task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXECUTING</code> - Amazon FSx is processing the task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the
     *         task failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information
     *         about task failures.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code> - FSx completed the task successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELING</code> - FSx is in process of canceling the task.
     *         </p>
     *         </li>
     * @see DataRepositoryTaskLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * <p>
     * The ID of the task being canceled.
     * </p>
     * 
     * @return The ID of the task being canceled.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelDataRepositoryTaskResponse)) {
            return false;
        }
        CancelDataRepositoryTaskResponse other = (CancelDataRepositoryTaskResponse) obj;
        return Objects.equals(lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelDataRepositoryTaskResponse").add("Lifecycle", lifecycleAsString()).add("TaskId", taskId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelDataRepositoryTaskResponse, T> g) {
        return obj -> g.apply((CancelDataRepositoryTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelDataRepositoryTaskResponse> {
        /**
         * <p>
         * The lifecycle status of the data repository task, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx has not started the task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXECUTING</code> - Amazon FSx is processing the task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task
         * failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task
         * failures.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code> - FSx completed the task successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELING</code> - FSx is in process of canceling the task.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the data repository task, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx has not started the task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXECUTING</code> - Amazon FSx is processing the task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files
         *        the task failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more
         *        information about task failures.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code> - FSx completed the task successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELING</code> - FSx is in process of canceling the task.
         *        </p>
         *        </li>
         * @see DataRepositoryTaskLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryTaskLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle status of the data repository task, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx has not started the task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXECUTING</code> - Amazon FSx is processing the task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task
         * failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task
         * failures.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code> - FSx completed the task successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELING</code> - FSx is in process of canceling the task.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the data repository task, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx has not started the task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXECUTING</code> - Amazon FSx is processing the task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files
         *        the task failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more
         *        information about task failures.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code> - FSx completed the task successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELING</code> - FSx is in process of canceling the task.
         *        </p>
         *        </li>
         * @see DataRepositoryTaskLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryTaskLifecycle
         */
        Builder lifecycle(DataRepositoryTaskLifecycle lifecycle);

        /**
         * <p>
         * The ID of the task being canceled.
         * </p>
         * 
         * @param taskId
         *        The ID of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String lifecycle;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelDataRepositoryTaskResponse model) {
            super(model);
            lifecycle(model.lifecycle);
            taskId(model.taskId);
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(DataRepositoryTaskLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public CancelDataRepositoryTaskResponse build() {
            return new CancelDataRepositoryTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
