/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes;
import software.amazon.awssdk.services.fsx.model.BackupFailureDetails;
import software.amazon.awssdk.services.fsx.model.BackupLifecycle;
import software.amazon.awssdk.services.fsx.model.BackupType;
import software.amazon.awssdk.services.fsx.model.FileSystem;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Backup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Backup> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Backup.getter(Backup::backupId)).setter(Backup.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Backup.getter(Backup::lifecycleAsString)).setter(Backup.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<BackupFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Backup.getter(Backup::failureDetails)).setter(Backup.setter(Builder::failureDetails)).constructor(BackupFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Backup.getter(Backup::typeAsString)).setter(Backup.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Backup.getter(Backup::progressPercent)).setter(Backup.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Backup.getter(Backup::creationTime)).setter(Backup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Backup.getter(Backup::kmsKeyId)).setter(Backup.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Backup.getter(Backup::resourceARN)).setter(Backup.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Backup.getter(Backup::tags)).setter(Backup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FileSystem> FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Backup.getter(Backup::fileSystem)).setter(Backup.setter(Builder::fileSystem)).constructor(FileSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystem").build()}).build();
    private static final SdkField<ActiveDirectoryBackupAttributes> DIRECTORY_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Backup.getter(Backup::directoryInformation)).setter(Backup.setter(Builder::directoryInformation)).constructor(ActiveDirectoryBackupAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD, LIFECYCLE_FIELD, FAILURE_DETAILS_FIELD, TYPE_FIELD, PROGRESS_PERCENT_FIELD, CREATION_TIME_FIELD, KMS_KEY_ID_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, FILE_SYSTEM_FIELD, DIRECTORY_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupId;
    private final String lifecycle;
    private final BackupFailureDetails failureDetails;
    private final String type;
    private final Integer progressPercent;
    private final Instant creationTime;
    private final String kmsKeyId;
    private final String resourceARN;
    private final List<Tag> tags;
    private final FileSystem fileSystem;
    private final ActiveDirectoryBackupAttributes directoryInformation;

    private Backup(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.lifecycle = builder.lifecycle;
        this.failureDetails = builder.failureDetails;
        this.type = builder.type;
        this.progressPercent = builder.progressPercent;
        this.creationTime = builder.creationTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.fileSystem = builder.fileSystem;
        this.directoryInformation = builder.directoryInformation;
    }

    public String backupId() {
        return this.backupId;
    }

    public BackupLifecycle lifecycle() {
        return BackupLifecycle.fromValue(this.lifecycle);
    }

    public String lifecycleAsString() {
        return this.lifecycle;
    }

    public BackupFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public BackupType type() {
        return BackupType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Integer progressPercent() {
        return this.progressPercent;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public ActiveDirectoryBackupAttributes directoryInformation() {
        return this.directoryInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryInformation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fileSystem(), other.fileSystem()) && Objects.equals(this.directoryInformation(), other.directoryInformation());
    }

    public String toString() {
        return ToString.builder((String)"Backup").add("BackupId", (Object)this.backupId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("FailureDetails", (Object)this.failureDetails()).add("Type", (Object)this.typeAsString()).add("ProgressPercent", (Object)this.progressPercent()).add("CreationTime", (Object)this.creationTime()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ResourceARN", (Object)this.resourceARN()).add("Tags", this.tags()).add("FileSystem", (Object)this.fileSystem()).add("DirectoryInformation", (Object)this.directoryInformation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FileSystem": {
                return Optional.ofNullable(clazz.cast(this.fileSystem()));
            }
            case "DirectoryInformation": {
                return Optional.ofNullable(clazz.cast(this.directoryInformation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Backup, T> g) {
        return obj -> g.apply((Backup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupId;
        private String lifecycle;
        private BackupFailureDetails failureDetails;
        private String type;
        private Integer progressPercent;
        private Instant creationTime;
        private String kmsKeyId;
        private String resourceARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private FileSystem fileSystem;
        private ActiveDirectoryBackupAttributes directoryInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            this.backupId(model.backupId);
            this.lifecycle(model.lifecycle);
            this.failureDetails(model.failureDetails);
            this.type(model.type);
            this.progressPercent(model.progressPercent);
            this.creationTime(model.creationTime);
            this.kmsKeyId(model.kmsKeyId);
            this.resourceARN(model.resourceARN);
            this.tags(model.tags);
            this.fileSystem(model.fileSystem);
            this.directoryInformation(model.directoryInformation);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(BackupLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final BackupFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        @Override
        public final Builder failureDetails(BackupFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(BackupFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BackupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getProgressPercent() {
            return this.progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final FileSystem.Builder getFileSystem() {
            return this.fileSystem != null ? this.fileSystem.toBuilder() : null;
        }

        @Override
        public final Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public final void setFileSystem(FileSystem.BuilderImpl fileSystem) {
            this.fileSystem = fileSystem != null ? fileSystem.build() : null;
        }

        public final ActiveDirectoryBackupAttributes.Builder getDirectoryInformation() {
            return this.directoryInformation != null ? this.directoryInformation.toBuilder() : null;
        }

        @Override
        public final Builder directoryInformation(ActiveDirectoryBackupAttributes directoryInformation) {
            this.directoryInformation = directoryInformation;
            return this;
        }

        public final void setDirectoryInformation(ActiveDirectoryBackupAttributes.BuilderImpl directoryInformation) {
            this.directoryInformation = directoryInformation != null ? directoryInformation.build() : null;
        }

        public Backup build() {
            return new Backup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Backup> {
        public Builder backupId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(BackupLifecycle var1);

        public Builder failureDetails(BackupFailureDetails var1);

        default public Builder failureDetails(Consumer<BackupFailureDetails.Builder> failureDetails) {
            return this.failureDetails((BackupFailureDetails)((BackupFailureDetails.Builder)BackupFailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder type(String var1);

        public Builder type(BackupType var1);

        public Builder progressPercent(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder kmsKeyId(String var1);

        public Builder resourceARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder fileSystem(FileSystem var1);

        default public Builder fileSystem(Consumer<FileSystem.Builder> fileSystem) {
            return this.fileSystem((FileSystem)((FileSystem.Builder)FileSystem.builder().applyMutation(fileSystem)).build());
        }

        public Builder directoryInformation(ActiveDirectoryBackupAttributes var1);

        default public Builder directoryInformation(Consumer<ActiveDirectoryBackupAttributes.Builder> directoryInformation) {
            return this.directoryInformation((ActiveDirectoryBackupAttributes)((ActiveDirectoryBackupAttributes.Builder)ActiveDirectoryBackupAttributes.builder().applyMutation(directoryInformation)).build());
        }
    }
}

