/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of activities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivitySummary implements SdkPojo, Serializable, ToCopyableBuilder<ActivitySummary.Builder, ActivitySummary> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityId").getter(getter(ActivitySummary::activityId)).setter(setter(Builder::activityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(ActivitySummary::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<ActivityReward> REWARD_FIELD = SdkField.<ActivityReward> builder(MarshallingType.SDK_POJO)
            .memberName("reward").getter(getter(ActivitySummary::reward)).setter(setter(Builder::reward))
            .constructor(ActivityReward::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reward").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ActivitySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD,
            TITLE_FIELD, REWARD_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activityId;

    private final String title;

    private final ActivityReward reward;

    private final String status;

    private ActivitySummary(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.title = builder.title;
        this.reward = builder.reward;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique identifier that identifies the activity.
     * </p>
     * 
     * @return A unique identifier that identifies the activity.
     */
    public final String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The title of the activity.
     * </p>
     * 
     * @return The title of the activity.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The reward for the activity.
     * </p>
     * 
     * @return The reward for the activity.
     */
    public final ActivityReward reward() {
        return reward;
    }

    /**
     * <p>
     * The current status of the activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the activity.
     * @see ActivityStatus
     */
    public final ActivityStatus status() {
        return ActivityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the activity.
     * @see ActivityStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(reward());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivitySummary)) {
            return false;
        }
        ActivitySummary other = (ActivitySummary) obj;
        return Objects.equals(activityId(), other.activityId()) && Objects.equals(title(), other.title())
                && Objects.equals(reward(), other.reward()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivitySummary").add("ActivityId", activityId()).add("Title", title()).add("Reward", reward())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityId":
            return Optional.ofNullable(clazz.cast(activityId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "reward":
            return Optional.ofNullable(clazz.cast(reward()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activityId", ACTIVITY_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("reward", REWARD_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActivitySummary, T> g) {
        return obj -> g.apply((ActivitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivitySummary> {
        /**
         * <p>
         * A unique identifier that identifies the activity.
         * </p>
         * 
         * @param activityId
         *        A unique identifier that identifies the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The title of the activity.
         * </p>
         * 
         * @param title
         *        The title of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The reward for the activity.
         * </p>
         * 
         * @param reward
         *        The reward for the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reward(ActivityReward reward);

        /**
         * <p>
         * The reward for the activity.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityReward.Builder} avoiding the need
         * to create one manually via {@link ActivityReward#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityReward.Builder#build()} is called immediately and its
         * result is passed to {@link #reward(ActivityReward)}.
         * 
         * @param reward
         *        a consumer that will call methods on {@link ActivityReward.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reward(ActivityReward)
         */
        default Builder reward(Consumer<ActivityReward.Builder> reward) {
            return reward(ActivityReward.builder().applyMutation(reward).build());
        }

        /**
         * <p>
         * The current status of the activity.
         * </p>
         * 
         * @param status
         *        The current status of the activity.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the activity.
         * </p>
         * 
         * @param status
         *        The current status of the activity.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder status(ActivityStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String activityId;

        private String title;

        private ActivityReward reward;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivitySummary model) {
            activityId(model.activityId);
            title(model.title);
            reward(model.reward);
            status(model.status);
        }

        public final String getActivityId() {
            return activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ActivityReward.Builder getReward() {
            return reward != null ? reward.toBuilder() : null;
        }

        public final void setReward(ActivityReward.BuilderImpl reward) {
            this.reward = reward != null ? reward.build() : null;
        }

        @Override
        public final Builder reward(ActivityReward reward) {
            this.reward = reward;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActivityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ActivitySummary build() {
            return new ActivitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
